/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.sdpDemo.populator.portlet.populator;

import java.util.Collection;
import javax.inject.Inject;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import juzu.template.Template;
import org.exoplatform.addons.sdpDemo.populator.services.PopulatorService;

@SessionScoped
public class Populator {
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    @Inject
    PopulatorService populatorService_;

    @View
    public Response.Content index() {
        Collection scenarios = this.populatorService_.getScenarios().values();
        return this.index.with().set("scenarios", scenarios).ok();
    }

    @Ajax
    @Resource
    public Response.Content populate(String scenarioName) {
        String downloadUrl = this.populatorService_.populate(scenarioName);
        StringBuilder sb = new StringBuilder();
        sb.append("{\"status\": \"OK\",\"downloadUrl\": \"" + downloadUrl + "\"}");
        return Response.ok((CharSequence)sb.toString()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content elements() {
        return Response.ok((CharSequence)this.populatorService_.getCompletionAsJson()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }
}

