/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.activity.listener;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.dlp.activity.listener.DlpActivityAttachmentListener;
import org.exoplatform.dlp.domain.DlpPositiveItemEntity;
import org.exoplatform.dlp.dto.DlpPositiveItem;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DlpActivityAttachmentListenerTest {
    private PortalContainer container;
    @Mock
    private DlpPositiveItemService dlpPositiveItemService;
    private DlpActivityAttachmentListener dlpActivityAttachmentListener;
    @Mock
    private CachedActivityStorage activityStorage;

    @Before
    public void setUp() {
        this.container = PortalContainer.getInstance();
        CachedActivityStorage cachedActivityStorage = (CachedActivityStorage)this.container.getComponentInstanceOfType(CachedActivityStorage.class);
        Assert.assertNotNull((Object)cachedActivityStorage);
        this.dlpActivityAttachmentListener = new DlpActivityAttachmentListener(this.dlpPositiveItemService, (ActivityStorage)this.activityStorage, this.container);
    }

    @Test
    public void onEvent() throws Exception {
        DlpPositiveItem dlpPositiveItem = new DlpPositiveItem();
        dlpPositiveItem.setReference("12zeddzed2ze25eedzed");
        dlpPositiveItem.setType("file");
        Event event = new Event("event_name", null, (Object)dlpPositiveItem);
        this.dlpActivityAttachmentListener.onEvent(event);
        ((CachedActivityStorage)Mockito.verify((Object)this.activityStorage, (VerificationMode)Mockito.times((int)1))).clearActivityCachedByAttachmentId(dlpPositiveItem.getReference());
        DlpPositiveItemEntity dlpPositiveItemEntity = new DlpPositiveItemEntity();
        dlpPositiveItemEntity.setReference("12zeddzed2ze25eedzed");
        dlpPositiveItemEntity.setType("file");
        Event event1 = new Event("event_name", null, (Object)dlpPositiveItemEntity);
        this.dlpActivityAttachmentListener.onEvent(event1);
        ((CachedActivityStorage)Mockito.verify((Object)this.activityStorage, (VerificationMode)Mockito.times((int)2))).clearActivityCachedByAttachmentId(dlpPositiveItemEntity.getReference());
        Mockito.when((Object)this.dlpPositiveItemService.getDlpPositiveItemById(Long.valueOf(1L))).thenReturn((Object)dlpPositiveItem);
        Mockito.when((Object)this.dlpPositiveItemService.getDlpPositiveItemByReference("12zeddzed2ze25eedzed")).thenReturn((Object)dlpPositiveItem);
        Event event2 = new Event("event_name", null, (Object)1L);
        this.dlpActivityAttachmentListener.onEvent(event2);
        ((CachedActivityStorage)Mockito.verify((Object)this.activityStorage, (VerificationMode)Mockito.times((int)3))).clearActivityCachedByAttachmentId(dlpPositiveItem.getReference());
        Event event3 = new Event("event_name", null, (Object)"12zeddzed2ze25eedzed");
        this.dlpActivityAttachmentListener.onEvent(event3);
        ((CachedActivityStorage)Mockito.verify((Object)this.activityStorage, (VerificationMode)Mockito.times((int)4))).clearActivityCachedByAttachmentId(dlpPositiveItem.getReference());
    }
}

