/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Date;
import microsoft.exchange.webservices.data.EmailAddress;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.MeetingResponseType;

public final class Attendee
extends EmailAddress {
    private MeetingResponseType responseType;
    private Date lastResponseTime;

    public Attendee() {
    }

    public Attendee(String smtpAddress) throws Exception {
        super(smtpAddress);
        EwsUtilities.validateParam(smtpAddress, "smtpAddress");
    }

    public Attendee(String name, String smtpAddress) {
        super(name, smtpAddress);
    }

    public Attendee(String name, String smtpAddress, String routingType) {
        super(name, smtpAddress, routingType);
    }

    public Attendee(EmailAddress mailbox) throws Exception {
        super(mailbox);
    }

    public MeetingResponseType getResponseType() {
        return this.responseType;
    }

    public Date getLastResponseTime() {
        return this.lastResponseTime;
    }

    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("Mailbox")) {
            this.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("ResponseType")) {
            this.responseType = reader.readElementValue(MeetingResponseType.class);
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("LastResponseTime")) {
            this.lastResponseTime = reader.readElementValueAsDateTime();
            return true;
        }
        return super.tryReadElementFromXml(reader);
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(this.getNamespace(), "Mailbox");
        super.writeElementsToXml(writer);
        writer.writeEndElement();
    }
}

