/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.AlternateIdBase;
import microsoft.exchange.webservices.data.ConvertIdResponse;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.IdFormat;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConvertIdRequest
extends MultiResponseServiceRequest<ConvertIdResponse> {
    private IdFormat destinationFormat = IdFormat.EwsId;
    private List<AlternateIdBase> ids = new ArrayList<AlternateIdBase>();

    protected ConvertIdRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected ConvertIdResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ConvertIdResponse();
    }

    @Override
    protected String getResponseXmlElementName() {
        return "ConvertIdResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "ConvertIdResponseMessage";
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.ids.size();
    }

    @Override
    protected String getXmlElementName() {
        return "ConvertId";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.ids.iterator(), "Ids");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeAttributeValue("DestinationFormat", (Object)this.destinationFormat);
        writer.writeStartElement(XmlNamespace.Messages, "SourceIds");
        for (AlternateIdBase alternateId : this.ids) {
            alternateId.writeToXml(writer);
        }
        writer.writeEndElement();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public IdFormat getDestinationFormat() {
        return this.destinationFormat;
    }

    public void setDestinationFormat(IdFormat destinationFormat) {
        this.destinationFormat = destinationFormat;
    }

    public List<AlternateIdBase> getIds() {
        return this.ids;
    }
}

