/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Collection;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.DayOfTheWeek;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.LegacyAvailabilityTimeZone;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import microsoft.exchange.webservices.data.WorkingPeriod;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkingHours
extends ComplexProperty {
    private TimeZoneDefinition timeZone;
    private Collection<DayOfTheWeek> daysOfTheWeek = new ArrayList<DayOfTheWeek>();
    private long startTime;
    private long endTime;

    protected WorkingHours() {
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("TimeZone")) {
            LegacyAvailabilityTimeZone legacyTimeZone = new LegacyAvailabilityTimeZone();
            legacyTimeZone.loadFromXml(reader, reader.getLocalName());
            this.timeZone = legacyTimeZone.toTimeZoneInfo();
            return true;
        }
        if (reader.getLocalName().equals("WorkingPeriodArray")) {
            ArrayList<WorkingPeriod> workingPeriods = new ArrayList<WorkingPeriod>();
            do {
                reader.read();
                if (!reader.isStartElement(XmlNamespace.Types, "WorkingPeriod")) continue;
                WorkingPeriod workingPeriod = new WorkingPeriod();
                workingPeriod.loadFromXml(reader, reader.getLocalName());
                workingPeriods.add(workingPeriod);
            } while (!reader.isEndElement(XmlNamespace.Types, "WorkingPeriodArray"));
            this.startTime = ((WorkingPeriod)workingPeriods.get(0)).getStartTime();
            this.endTime = ((WorkingPeriod)workingPeriods.get(0)).getEndTime();
            for (WorkingPeriod workingPeriod : workingPeriods) {
                for (DayOfTheWeek dayOfWeek : ((WorkingPeriod)workingPeriods.get(0)).getDaysOfWeek()) {
                    if (this.daysOfTheWeek.contains((Object)dayOfWeek)) continue;
                    this.daysOfTheWeek.add(dayOfWeek);
                }
            }
            return true;
        }
        return false;
    }

    public TimeZoneDefinition getTimeZone() {
        return this.timeZone;
    }

    public Collection<DayOfTheWeek> getDaysOfTheWeek() {
        return this.daysOfTheWeek;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }
}

