/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.List;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.IGetObjectInstanceDelegate;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceResponse;

public final class GetItemResponse
extends ServiceResponse
implements IGetObjectInstanceDelegate {
    private Item item;
    private PropertySet propertySet;

    protected GetItemResponse(Item item, PropertySet propertySet) {
        this.item = item;
        this.propertySet = propertySet;
        EwsUtilities.EwsAssert(this.propertySet != null, "GetItemResponse.ctor", "PropertySet should not be null");
    }

    protected void readElementsFromXml(EwsServiceXmlReader reader) throws InstantiationException, IllegalAccessException, Exception {
        super.readElementsFromXml(reader);
        List items = reader.readServiceObjectsCollectionFromXml("Items", this, true, this.propertySet, false);
        this.item = (Item)items.get(0);
    }

    private Item getObjectInstance(ExchangeService service, String xmlElementName) throws Exception {
        if (this.getItem() != null) {
            return this.getItem();
        }
        return (Item)EwsUtilities.createEwsObjectFromXmlElementName(Item.class, service, xmlElementName);
    }

    public Item getItem() {
        return this.item;
    }

    public ServiceObject getObjectInstanceDelegate(ExchangeService service, String xmlElementName) throws Exception {
        return this.getObjectInstance(service, xmlElementName);
    }
}

