/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.ServiceObjectSchema;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyDefinitionBase {
    protected PropertyDefinitionBase() {
    }

    protected static boolean tryLoadFromXml(EwsServiceXmlReader reader, OutParam<PropertyDefinitionBase> propertyDefinition) throws Exception {
        String strLocalName = reader.getLocalName();
        if (strLocalName.equals("FieldURI")) {
            PropertyDefinitionBase p = ServiceObjectSchema.findPropertyDefinition(reader.readAttributeValue("FieldURI"));
            propertyDefinition.setParam((Object)p);
            return true;
        }
        if (strLocalName.equals("IndexedFieldURI")) {
            reader.skipCurrentElement();
            return true;
        }
        if (strLocalName.equals("ExtendedFieldURI")) {
            ExtendedPropertyDefinition p = new ExtendedPropertyDefinition();
            p.loadFromXml(reader);
            propertyDefinition.setParam((Object)p);
            return true;
        }
        return false;
    }

    protected abstract String getXmlElementName();

    protected abstract void writeAttributesToXml(EwsServiceXmlWriter var1) throws ServiceXmlSerializationException;

    public abstract ExchangeVersion getVersion();

    protected abstract String getPrintableName();

    public abstract Class getType();

    protected void writeToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, this.getXmlElementName());
        this.writeAttributesToXml(writer);
        writer.writeEndElement();
    }

    public String toString() {
        return this.getPrintableName();
    }
}

