/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.AbsoluteMonthTransition;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import microsoft.exchange.webservices.data.TimeZonePeriod;
import microsoft.exchange.webservices.data.XmlNamespace;

class AbsoluteDayOfMonthTransition
extends AbsoluteMonthTransition {
    private int dayOfMonth;

    protected String getXmlElementName() {
        return "RecurringDateTransition";
    }

    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (super.tryReadElementFromXml(reader)) {
            return true;
        }
        if (reader.getLocalName().equals("Day")) {
            this.dayOfMonth = reader.readElementValue(Integer.class);
            EwsUtilities.EwsAssert(this.dayOfMonth > 0 && this.dayOfMonth <= 31, "AbsoluteDayOfMonthTransition.TryReadElementFromXml", "dayOfMonth is not in the valid 1 - 31 range.");
            return true;
        }
        return false;
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        super.writeElementsToXml(writer);
        writer.writeElementValue(XmlNamespace.Types, "Day", this.dayOfMonth);
    }

    protected AbsoluteDayOfMonthTransition(TimeZoneDefinition timeZoneDefinition) {
        super(timeZoneDefinition);
    }

    protected AbsoluteDayOfMonthTransition(TimeZoneDefinition timeZoneDefinition, TimeZonePeriod targetPeriod) {
        super(timeZoneDefinition, targetPeriod);
    }

    protected int getDayOfMonth() {
        return this.dayOfMonth;
    }
}

