/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.ICustomXmlUpdateSerializer;
import microsoft.exchange.webservices.data.PropertyDefinition;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class ComplexPropertyCollection<TComplexProperty extends ComplexProperty>
extends ComplexProperty
implements ICustomXmlUpdateSerializer,
Iterable<TComplexProperty>,
IComplexPropertyChangedDelegate {
    private List<TComplexProperty> items = new ArrayList<TComplexProperty>();
    private List<TComplexProperty> addedItems = new ArrayList<TComplexProperty>();
    private List<TComplexProperty> modifiedItems = new ArrayList<TComplexProperty>();
    private List<TComplexProperty> removedItems = new ArrayList<TComplexProperty>();

    protected abstract TComplexProperty createComplexProperty(String var1);

    protected abstract String getCollectionItemXmlElementName(TComplexProperty var1);

    protected ComplexPropertyCollection() {
    }

    protected void itemChanged(ComplexProperty complexProperty) {
        EwsUtilities.EwsAssert(complexProperty instanceof ComplexProperty, "ComplexPropertyCollection.ItemChanged", String.format("ComplexPropertyCollection.ItemChanged: the type of the complexProperty argument (%s) is not supported.", complexProperty.getClass().getName()));
        ComplexProperty property = complexProperty;
        if (!this.addedItems.contains(property) && !this.modifiedItems.contains(property)) {
            this.modifiedItems.add(property);
            this.changed();
        }
    }

    @Override
    protected void loadFromXml(EwsServiceXmlReader reader, String localElementName) throws Exception {
        this.loadFromXml(reader, XmlNamespace.Types, localElementName);
    }

    @Override
    protected void loadFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String localElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(xmlNamespace, localElementName);
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (!reader.isStartElement()) continue;
                TComplexProperty complexProperty = this.createComplexProperty(reader.getLocalName());
                if (complexProperty != null) {
                    ((ComplexProperty)complexProperty).loadFromXml(reader, reader.getLocalName());
                    this.internalAdd(complexProperty, true);
                    continue;
                }
                reader.skipCurrentElement();
            } while (!reader.isEndElement(xmlNamespace, localElementName));
        } else {
            reader.read();
        }
    }

    @Override
    protected void updateFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(xmlNamespace, xmlElementName);
        if (!reader.isEmptyElement()) {
            int index = 0;
            do {
                reader.read();
                if (!reader.isStartElement()) continue;
                TComplexProperty complexProperty = this.createComplexProperty(reader.getLocalName());
                TComplexProperty actualComplexProperty = this.getPropertyAtIndex(index++);
                if (complexProperty == null || !complexProperty.getClass().equals(actualComplexProperty)) {
                    throw new ServiceLocalException(Strings.PropertyTypeIncompatibleWhenUpdatingCollection);
                }
                ((ComplexProperty)actualComplexProperty).updateFromXml(reader, xmlNamespace, reader.getLocalName());
            } while (!reader.isEndElement(xmlNamespace, xmlElementName));
        }
    }

    @Override
    protected void writeToXml(EwsServiceXmlWriter writer, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        if (this.shouldWriteToXml()) {
            super.writeToXml(writer, xmlNamespace, xmlElementName);
        }
    }

    protected boolean shouldWriteToXml() {
        return this.getCount() > 0;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        for (ComplexProperty complexProperty : this) {
            complexProperty.writeToXml(writer, this.getCollectionItemXmlElementName(complexProperty));
        }
    }

    @Override
    protected void clearChangeLog() {
        this.removedItems.clear();
        this.addedItems.clear();
        this.modifiedItems.clear();
    }

    protected void removeFromChangeLog(TComplexProperty complexProperty) {
        this.removedItems.remove(complexProperty);
        this.modifiedItems.remove(complexProperty);
        this.addedItems.remove(complexProperty);
    }

    protected List<TComplexProperty> getItems() {
        return this.items;
    }

    protected List<TComplexProperty> getAddedItems() {
        return this.addedItems;
    }

    protected List<TComplexProperty> getModifiedItems() {
        return this.modifiedItems;
    }

    protected List<TComplexProperty> getRemovedItems() {
        return this.removedItems;
    }

    protected void internalAdd(TComplexProperty complexProperty) {
        this.internalAdd(complexProperty, false);
    }

    private void internalAdd(TComplexProperty complexProperty, boolean loading) {
        EwsUtilities.EwsAssert(complexProperty != null, "ComplexPropertyCollection.InternalAdd", "complexProperty is null");
        if (!this.items.contains(complexProperty)) {
            this.items.add(complexProperty);
            if (!loading) {
                this.removedItems.remove(complexProperty);
                this.addedItems.add(complexProperty);
            }
            ((ComplexProperty)complexProperty).addOnChangeEvent(this);
            this.changed();
        }
    }

    @Override
    public void complexPropertyChanged(ComplexProperty complexProperty) {
        this.itemChanged(complexProperty);
    }

    protected void internalClear() {
        while (this.getCount() > 0) {
            this.internalRemoveAt(0);
        }
    }

    protected void internalRemoveAt(int index) {
        EwsUtilities.EwsAssert(index >= 0 && index < this.getCount(), "ComplexPropertyCollection.InternalRemoveAt", "index is out of range.");
        this.internalRemove((ComplexProperty)this.items.get(index));
    }

    protected boolean internalRemove(TComplexProperty complexProperty) {
        EwsUtilities.EwsAssert(complexProperty != null, "ComplexPropertyCollection.InternalRemove", "complexProperty is null");
        if (this.items.remove(complexProperty)) {
            ((ComplexProperty)complexProperty).removeChangeEvent(this);
            if (!this.addedItems.contains(complexProperty)) {
                this.removedItems.add(complexProperty);
            } else {
                this.addedItems.remove(complexProperty);
            }
            this.modifiedItems.remove(complexProperty);
            this.changed();
            return true;
        }
        return false;
    }

    public boolean contains(TComplexProperty complexProperty) {
        return this.items.contains(complexProperty);
    }

    public int indexOf(TComplexProperty complexProperty) {
        return this.items.indexOf(complexProperty);
    }

    public int getCount() {
        return this.items.size();
    }

    public TComplexProperty getPropertyAtIndex(int index) throws IllegalArgumentException {
        if (index < 0 || index >= this.getCount()) {
            throw new IllegalArgumentException("parameter 'index' : " + Strings.IndexIsOutOfRange);
        }
        return (TComplexProperty)((ComplexProperty)this.items.get(index));
    }

    @Override
    public Iterator<TComplexProperty> iterator() {
        return this.items.iterator();
    }

    @Override
    public boolean writeSetUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject, PropertyDefinition propertyDefinition) throws Exception {
        if (this.getCount() == 0) {
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getDeleteFieldXmlElementName());
            propertyDefinition.writeToXml(writer);
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    @Override
    public boolean writeDeleteUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject) throws Exception {
        return false;
    }
}

