/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.ListIterator;
import microsoft.exchange.webservices.data.Attachment;
import microsoft.exchange.webservices.data.CreateAttachmentResponse;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ItemAttachment;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CreateAttachmentRequest
extends MultiResponseServiceRequest<CreateAttachmentResponse> {
    private String parentItemId;
    private ArrayList<Attachment> attachments = new ArrayList();

    public ArrayList<Attachment> getAttachments() {
        return this.attachments;
    }

    protected CreateAttachmentRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.parentItemId, "ParentItemId");
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.attachments.size();
    }

    @Override
    protected String getXmlElementName() {
        return "CreateAttachment";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "CreateAttachmentResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "CreateAttachmentResponseMessage";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected boolean emitTimeZoneHeader() throws ServiceLocalException, Exception {
        ListIterator<Attachment> items = this.getAttachments().listIterator();
        while (items.hasNext()) {
            ItemAttachment itemAttachment = (ItemAttachment)items.next();
            if (itemAttachment.getItem() == null || !itemAttachment.getItem().getIsTimeZoneHeaderRequired(false)) continue;
            return true;
        }
        return false;
    }

    public String getParentItemId() {
        return this.parentItemId;
    }

    public void setParentItemId(String parentItemId) {
        this.parentItemId = parentItemId;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, "ParentItemId");
        writer.writeAttributeValue("Id", this.parentItemId);
        writer.writeEndElement();
        writer.writeStartElement(XmlNamespace.Messages, "Attachments");
        for (Attachment attachment : this.attachments) {
            attachment.writeToXml(writer, attachment.getXmlElementName());
        }
        writer.writeEndElement();
    }

    @Override
    protected CreateAttachmentResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new CreateAttachmentResponse(this.attachments.get(responseIndex));
    }
}

