/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.DeleteRequest;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderIdWrapperList;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeleteFolderRequest
extends DeleteRequest<ServiceResponse> {
    private FolderIdWrapperList folderIds = new FolderIdWrapperList();

    protected DeleteFolderRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getFolderIds(), "FolderIds");
        this.getFolderIds().validate(this.getService().getRequestedServerVersion());
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getFolderIds().getCount();
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    protected String getXmlElementName() {
        return "DeleteFolder";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "DeleteFolderResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "DeleteFolderResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) {
        try {
            this.getFolderIds().writeToXml(writer, XmlNamespace.Messages, "FolderIds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected FolderIdWrapperList getFolderIds() {
        return this.folderIds;
    }
}

