/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.ComplexPropertyCollection;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExtendedProperty;
import microsoft.exchange.webservices.data.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.ICustomXmlUpdateSerializer;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.PropertyDefinition;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorBrowsable(state=EditorBrowsableState.Never)
public final class ExtendedPropertyCollection
extends ComplexPropertyCollection<ExtendedProperty>
implements ICustomXmlUpdateSerializer {
    @Override
    protected ExtendedProperty createComplexProperty(String xmlElementName) {
        return null;
    }

    @Override
    protected String getCollectionItemXmlElementName(ExtendedProperty complexProperty) {
        return null;
    }

    @Override
    protected void loadFromXml(EwsServiceXmlReader reader, String localElementName) throws Exception {
        ExtendedProperty extendedProperty = new ExtendedProperty();
        extendedProperty.loadFromXml(reader, reader.getLocalName());
        this.internalAdd(extendedProperty);
    }

    @Override
    protected void writeToXml(EwsServiceXmlWriter writer, String xmlElementName) throws Exception {
        for (ExtendedProperty extendedProperty : this) {
            extendedProperty.writeToXml(writer, "ExtendedProperty");
        }
    }

    private ExtendedProperty getOrAddExtendedProperty(ExtendedPropertyDefinition propertyDefinition) throws Exception {
        ExtendedProperty extendedProperty = null;
        OutParam<ExtendedProperty> extendedPropertyOut = new OutParam<ExtendedProperty>();
        if (!this.tryGetProperty(propertyDefinition, extendedPropertyOut)) {
            extendedProperty = new ExtendedProperty(propertyDefinition);
            this.internalAdd(extendedProperty);
        } else {
            extendedProperty = (ExtendedProperty)extendedPropertyOut.getParam();
        }
        return extendedProperty;
    }

    protected void setExtendedProperty(ExtendedPropertyDefinition propertyDefinition, Object value) throws Exception {
        ExtendedProperty extendedProperty = this.getOrAddExtendedProperty(propertyDefinition);
        extendedProperty.setValue(value);
    }

    protected boolean removeExtendedProperty(ExtendedPropertyDefinition propertyDefinition) throws Exception {
        EwsUtilities.validateParam(propertyDefinition, "propertyDefinition");
        ExtendedProperty extendedProperty = null;
        OutParam<ExtendedProperty> extendedPropertyOut = new OutParam<ExtendedProperty>();
        if (this.tryGetProperty(propertyDefinition, extendedPropertyOut)) {
            extendedProperty = (ExtendedProperty)extendedPropertyOut.getParam();
            return this.internalRemove(extendedProperty);
        }
        return false;
    }

    private boolean tryGetProperty(ExtendedPropertyDefinition propertyDefinition, OutParam<ExtendedProperty> extendedPropertyOut) {
        boolean found = false;
        extendedPropertyOut.setParam((Object)null);
        for (ExtendedProperty prop : this.getItems()) {
            if (!prop.getPropertyDefinition().equals(propertyDefinition)) continue;
            found = true;
            extendedPropertyOut.setParam((Object)prop);
            break;
        }
        return found;
    }

    protected <T> boolean tryGetValue(Class<T> cls, ExtendedPropertyDefinition propertyDefinition, OutParam<T> propertyValueOut) throws ArgumentException {
        ExtendedProperty extendedProperty = null;
        OutParam<ExtendedProperty> extendedPropertyOut = new OutParam<ExtendedProperty>();
        if (this.tryGetProperty(propertyDefinition, extendedPropertyOut)) {
            extendedProperty = (ExtendedProperty)extendedPropertyOut.getParam();
            if (cls.isAssignableFrom(propertyDefinition.getType())) {
                String errorMessage = String.format(Strings.PropertyDefinitionTypeMismatch, EwsUtilities.getPrintableTypeName(propertyDefinition.getType()), EwsUtilities.getPrintableTypeName(cls));
                throw new ArgumentException(errorMessage, "propertyDefinition");
            }
            propertyValueOut.setParam(extendedProperty.getValue());
            return true;
        }
        propertyValueOut.setParam((Object)null);
        return false;
    }

    @Override
    public boolean writeSetUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject, PropertyDefinition propertyDefinition) throws Exception {
        ArrayList propertiesToSet = new ArrayList();
        propertiesToSet.addAll(this.getAddedItems());
        propertiesToSet.addAll(this.getModifiedItems());
        for (ExtendedProperty extendedProperty : propertiesToSet) {
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getSetFieldXmlElementName());
            extendedProperty.getPropertyDefinition().writeToXml(writer);
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getXmlElementName());
            extendedProperty.writeToXml(writer, "ExtendedProperty");
            writer.writeEndElement();
            writer.writeEndElement();
        }
        for (ExtendedProperty extendedProperty : this.getRemovedItems()) {
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getDeleteFieldXmlElementName());
            extendedProperty.getPropertyDefinition().writeToXml(writer);
            writer.writeEndElement();
        }
        return true;
    }

    @Override
    public boolean writeDeleteUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject) throws XMLStreamException, ServiceXmlSerializationException {
        for (ExtendedProperty extendedProperty : this.getItems()) {
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getDeleteFieldXmlElementName());
            extendedProperty.getPropertyDefinition().writeToXml(writer);
            writer.writeEndElement();
        }
        return true;
    }
}

