/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.Attachment;
import microsoft.exchange.webservices.data.BodyType;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.GetAttachmentResponse;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GetAttachmentRequest
extends MultiResponseServiceRequest<GetAttachmentResponse> {
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private List<PropertyDefinitionBase> additionalProperties = new ArrayList<PropertyDefinitionBase>();
    private BodyType bodyType;

    GetAttachmentRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getAttachments().iterator(), "Attachments");
        for (int i = 0; i < this.getAdditionalProperties().size(); ++i) {
            EwsUtilities.validateParam(this.getAdditionalProperties().get(i), String.format("AdditionalProperties[%d]", i));
        }
    }

    @Override
    protected GetAttachmentResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new GetAttachmentResponse(this.getAttachments().get(responseIndex));
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getAttachments().size();
    }

    @Override
    protected String getXmlElementName() {
        return "GetAttachment";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetAttachmentResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "GetAttachmentResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        if (this.getBodyType() != null || this.getAdditionalProperties().size() > 0) {
            writer.writeStartElement(XmlNamespace.Messages, "AttachmentShape");
            if (this.getBodyType() != null) {
                writer.writeElementValue(XmlNamespace.Types, "BodyType", (Object)this.getBodyType());
            }
            if (this.getAdditionalProperties().size() > 0) {
                PropertySet.writeAdditionalPropertiesToXml(writer, this.getAdditionalProperties().iterator());
            }
            writer.writeEndElement();
        }
        writer.writeStartElement(XmlNamespace.Messages, "AttachmentIds");
        for (Attachment attachment : this.getAttachments()) {
            writer.writeStartElement(XmlNamespace.Types, "AttachmentId");
            writer.writeAttributeValue("Id", attachment.getId());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public List<PropertyDefinitionBase> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(BodyType bodyType) {
        this.bodyType = bodyType;
    }
}

