/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Date;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.Recurrence;
import microsoft.exchange.webservices.data.RecurrenceRange;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

final class NumberedRecurrenceRange
extends RecurrenceRange {
    private Integer numberOfOccurrences;

    public NumberedRecurrenceRange() {
    }

    public NumberedRecurrenceRange(Date startDate, Integer numberOfOccurrences) {
        super(startDate);
        this.numberOfOccurrences = numberOfOccurrences;
    }

    protected String getXmlElementName() {
        return "NumberedRecurrence";
    }

    protected void setupRecurrence(Recurrence recurrence) throws Exception {
        super.setupRecurrence(recurrence);
        recurrence.setNumberOfOccurrences(this.numberOfOccurrences);
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        super.writeElementsToXml(writer);
        if (this.numberOfOccurrences != null) {
            writer.writeElementValue(XmlNamespace.Types, "NumberOfOccurrences", this.numberOfOccurrences);
        }
    }

    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (super.tryReadElementFromXml(reader)) {
            return true;
        }
        if (reader.getLocalName().equals("NumberOfOccurrences")) {
            this.numberOfOccurrences = reader.readElementValue(Integer.class);
            return true;
        }
        return false;
    }

    public Integer getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    public void setNumberOfOccurrences(Integer value) {
        this.canSetFieldValue(this.numberOfOccurrences, value);
    }
}

