/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.AbsoluteMonthTransition;
import microsoft.exchange.webservices.data.DayOfTheWeek;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import microsoft.exchange.webservices.data.TimeZonePeriod;
import microsoft.exchange.webservices.data.XmlNamespace;

class RelativeDayOfMonthTransition
extends AbsoluteMonthTransition {
    private DayOfTheWeek dayOfTheWeek;
    private int weekIndex;

    protected String getXmlElementName() {
        return "RecurringDayTransition";
    }

    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (super.tryReadElementFromXml(reader)) {
            return true;
        }
        if (reader.getLocalName().equals("DayOfWeek")) {
            this.dayOfTheWeek = reader.readElementValue(DayOfTheWeek.class);
            return true;
        }
        if (reader.getLocalName().equals("Occurrence")) {
            this.weekIndex = reader.readElementValue(Integer.class);
            return true;
        }
        return false;
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        super.writeElementsToXml(writer);
        writer.writeElementValue(XmlNamespace.Types, "DayOfWeek", (Object)this.dayOfTheWeek);
        writer.writeElementValue(XmlNamespace.Types, "Occurrence", this.weekIndex);
    }

    protected RelativeDayOfMonthTransition(TimeZoneDefinition timeZoneDefinition) {
        super(timeZoneDefinition);
    }

    protected RelativeDayOfMonthTransition(TimeZoneDefinition timeZoneDefinition, TimeZonePeriod targetPeriod) {
        super(timeZoneDefinition, targetPeriod);
    }

    protected DayOfTheWeek getDayOfTheWeek() {
        return this.dayOfTheWeek;
    }

    protected int getWeekIndex() {
        return this.weekIndex;
    }
}

