/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.Folder;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.UpdateFolderResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UpdateFolderRequest
extends MultiResponseServiceRequest<ServiceResponse> {
    private ArrayList<Folder> folders = new ArrayList();

    protected UpdateFolderRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getFolders().iterator(), "Folders");
        for (int i = 0; i < this.getFolders().size(); ++i) {
            Folder folder = this.getFolders().get(i);
            if (folder == null || folder.isNew()) {
                throw new IllegalArgumentException(String.format(Strings.FolderToUpdateCannotBeNullOrNew, i));
            }
            folder.validate();
        }
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService session, int responseIndex) {
        return new UpdateFolderResponse(this.getFolders().get(responseIndex));
    }

    @Override
    protected String getXmlElementName() {
        return "UpdateFolder";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "UpdateFolderResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "UpdateFolderResponseMessage";
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getFolders().size();
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, "FolderChanges");
        for (Folder folder : this.folders) {
            folder.writeToXmlForUpdate(writer);
        }
        writer.writeEndElement();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public ArrayList<Folder> getFolders() {
        return this.folders;
    }
}

