/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.service.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import microsoft.exchange.webservices.data.Appointment;
import microsoft.exchange.webservices.data.AppointmentSchema;
import microsoft.exchange.webservices.data.AppointmentType;
import microsoft.exchange.webservices.data.AttachmentCollection;
import microsoft.exchange.webservices.data.Attendee;
import microsoft.exchange.webservices.data.AttendeeCollection;
import microsoft.exchange.webservices.data.BasePropertySet;
import microsoft.exchange.webservices.data.BodyType;
import microsoft.exchange.webservices.data.DayOfTheWeek;
import microsoft.exchange.webservices.data.DayOfTheWeekCollection;
import microsoft.exchange.webservices.data.DayOfTheWeekIndex;
import microsoft.exchange.webservices.data.DeletedOccurrenceInfo;
import microsoft.exchange.webservices.data.DeletedOccurrenceInfoCollection;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.FileAttachment;
import microsoft.exchange.webservices.data.Importance;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.LegacyFreeBusyStatus;
import microsoft.exchange.webservices.data.MessageBody;
import microsoft.exchange.webservices.data.Month;
import microsoft.exchange.webservices.data.OccurrenceInfo;
import microsoft.exchange.webservices.data.OccurrenceInfoCollection;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.Recurrence;
import microsoft.exchange.webservices.data.Sensitivity;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObjectPropertyException;
import microsoft.exchange.webservices.data.StringList;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.extension.exchange.service.CorrespondenceService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;

public class CalendarConverterService {
    private static final Log LOG = ExoLogger.getLogger(CalendarConverterService.class);
    public static final String EXCHANGE_CALENDAR_NAME_PREFIX = "EXCH";
    public static final String EXCHANGE_CALENDAR_ID_PREFIX = "EXCH";
    public static final String EXCHANGE_EVENT_ID_PREFIX = "ExcangeEvent";
    private static final SimpleDateFormat UTC_DATE_FORMAT = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
    public static final SimpleDateFormat RECURRENCE_ID_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static final ThreadLocal<Query> queryThreadLocal = new ThreadLocal();

    public static void convertExchangeToExoEvent(CalendarEvent event, Appointment appointment, String username, JCRDataStorage storage, UserHandler userHandler, TimeZone timeZone) throws Exception {
        if (event.getId() == null || event.getId().isEmpty()) {
            event.setId(CalendarConverterService.getEventId(appointment.getId().getUniqueId()));
        }
        if (event.getEventType() == null) {
            event.setEventType(CalendarEvent.TYPE_EVENT);
            event.setCalType("0");
        }
        event.setLocation(appointment.getLocation());
        event.setSummary(appointment.getSubject());
        CalendarConverterService.setEventStatus(event, appointment);
        CalendarConverterService.setEventDates(event, appointment, timeZone);
        CalendarConverterService.setEventPriority(event, appointment);
        CalendarConverterService.setEventCategory(event, appointment, username, storage);
        CalendarConverterService.setEventParticipants(event, appointment, userHandler);
        CalendarConverterService.setEventReminder(event, appointment, username);
        if (appointment.getSensitivity() != null && !appointment.getSensitivity().equals((Object)Sensitivity.Normal)) {
            event.setPrivate(true);
        } else {
            event.setPrivate(false);
        }
        CalendarConverterService.setEventAttachements(event, appointment);
        CalendarConverterService.setEventDescription(event, appointment);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void convertExchangeToExoMasterRecurringCalendarEvent(CalendarEvent event, Appointment appointment, String username, JCRDataStorage storage, UserHandler userHandler, TimeZone timeZone) throws Exception {
        Recurrence recurrence;
        block34: {
            Iterator iterator;
            String[] days;
            block36: {
                block38: {
                    block37: {
                        block35: {
                            block33: {
                                CalendarConverterService.convertExchangeToExoEvent(event, appointment, username, storage, userHandler, timeZone);
                                appointment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.Recurrence}));
                                recurrence = appointment.getRecurrence();
                                if (!(recurrence instanceof Recurrence.DailyPattern)) break block33;
                                event.setRepeatType(CalendarEvent.RP_DAILY);
                                break block34;
                            }
                            if (!(recurrence instanceof Recurrence.WeeklyPattern)) break block35;
                            event.setRepeatType(CalendarEvent.RP_WEEKLY);
                            DayOfTheWeekCollection dayOfTheWeekCollection = ((Recurrence.WeeklyPattern)recurrence).getDaysOfTheWeek();
                            if (dayOfTheWeekCollection == null || dayOfTheWeekCollection.getCount() <= 0) break block34;
                            days = new String[7];
                            iterator = dayOfTheWeekCollection.iterator();
                            break block36;
                        }
                        if (!(recurrence instanceof Recurrence.RelativeMonthlyPattern)) break block37;
                        event.setRepeatType(CalendarEvent.RP_MONTHLY);
                        DayOfTheWeekIndex dayOfTheWeekIndex = ((Recurrence.RelativeMonthlyPattern)recurrence).getDayOfTheWeekIndex();
                        int exoIndex = (dayOfTheWeekIndex.ordinal() + 2) % 6 - 1;
                        String dayPrefix = null;
                        switch (((Recurrence.RelativeMonthlyPattern)recurrence).getDayOfTheWeek()) {
                            case Monday: {
                                dayPrefix = CalendarEvent.RP_WEEKLY_BYDAY[0];
                                break;
                            }
                            case Tuesday: {
                                dayPrefix = CalendarEvent.RP_WEEKLY_BYDAY[1];
                                break;
                            }
                            case Wednesday: {
                                dayPrefix = CalendarEvent.RP_WEEKLY_BYDAY[2];
                                break;
                            }
                            case Thursday: {
                                dayPrefix = CalendarEvent.RP_WEEKLY_BYDAY[3];
                                break;
                            }
                            case Friday: {
                                dayPrefix = CalendarEvent.RP_WEEKLY_BYDAY[4];
                                break;
                            }
                            case Saturday: {
                                dayPrefix = CalendarEvent.RP_WEEKLY_BYDAY[5];
                                break;
                            }
                            case Sunday: {
                                dayPrefix = CalendarEvent.RP_WEEKLY_BYDAY[6];
                                break;
                            }
                            default: {
                                LOG.error((Object)("Uknown day of the week '" + ((Recurrence.RelativeMonthlyPattern)recurrence).getDayOfTheWeek() + "', for recurrence '" + appointment.getSubject() + "', Monday will be set."));
                                dayPrefix = CalendarEvent.RP_WEEKLY_BYDAY[0];
                            }
                        }
                        event.setRepeatByDay(new String[]{exoIndex + dayPrefix});
                        event.setRepeatByMonthDay(null);
                        break block34;
                    }
                    if (!(recurrence instanceof Recurrence.MonthlyPattern)) break block38;
                    event.setRepeatType(CalendarEvent.RP_MONTHLY);
                    event.setRepeatByDay(null);
                    int dayOfMonth = 0;
                    try {
                        dayOfMonth = ((Recurrence.MonthlyPattern)recurrence).getDayOfMonth();
                    }
                    catch (Exception e) {
                        dayOfMonth = recurrence.getStartDate().getDate();
                    }
                    event.setRepeatByMonthDay(new long[]{dayOfMonth});
                    break block34;
                }
                if (recurrence instanceof Recurrence.YearlyPattern) {
                    event.setRepeatType(CalendarEvent.RP_YEARLY);
                    event.setRepeatInterval(1L);
                    Calendar tempCalendar = Calendar.getInstance();
                    tempCalendar.set(2, ((Recurrence.YearlyPattern)recurrence).getMonth().ordinal());
                    int dayOfMonth = 0;
                    try {
                        dayOfMonth = ((Recurrence.MonthlyPattern)recurrence).getDayOfMonth();
                    }
                    catch (Exception e) {
                        dayOfMonth = recurrence.getStartDate().getDate();
                    }
                    tempCalendar.set(5, dayOfMonth);
                    int dayOfYear = tempCalendar.get(6);
                    event.setRepeatByYearDay(new long[]{dayOfYear});
                    break block34;
                } else if (recurrence instanceof Recurrence.RelativeYearlyPattern) {
                    LOG.error((Object)"Cannot manage events of type RelativeYearlyPattern.");
                    event.setRepeatType(CalendarEvent.RP_YEARLY);
                }
                break block34;
            }
            block25: while (iterator.hasNext()) {
                DayOfTheWeek dayOfTheWeek = (DayOfTheWeek)iterator.next();
                switch (dayOfTheWeek) {
                    case Monday: {
                        days[0] = CalendarEvent.RP_WEEKLY_BYDAY[0];
                        break;
                    }
                    case Tuesday: {
                        days[1] = CalendarEvent.RP_WEEKLY_BYDAY[1];
                        break;
                    }
                    case Wednesday: {
                        days[2] = CalendarEvent.RP_WEEKLY_BYDAY[2];
                        break;
                    }
                    case Thursday: {
                        days[3] = CalendarEvent.RP_WEEKLY_BYDAY[3];
                        break;
                    }
                    case Friday: {
                        days[4] = CalendarEvent.RP_WEEKLY_BYDAY[4];
                        break;
                    }
                    case Saturday: {
                        days[5] = CalendarEvent.RP_WEEKLY_BYDAY[5];
                        break;
                    }
                    case Sunday: {
                        days[6] = CalendarEvent.RP_WEEKLY_BYDAY[6];
                        break;
                    }
                    case Weekday: {
                        days = Arrays.copyOfRange(CalendarEvent.RP_WEEKLY_BYDAY, 0, 4);
                        event.setRepeatType(CalendarEvent.RP_WORKINGDAYS);
                        break block25;
                    }
                    case WeekendDay: {
                        days = Arrays.copyOfRange(CalendarEvent.RP_WEEKLY_BYDAY, 5, 6);
                        event.setRepeatType(CalendarEvent.RP_WEEKEND);
                        break block25;
                    }
                    case Day: {
                        days = Arrays.copyOfRange(CalendarEvent.RP_WEEKLY_BYDAY, 0, 6);
                        break block25;
                    }
                }
            }
            ArrayList<String> daysList = new ArrayList<String>();
            for (String day : days) {
                if (day == null) continue;
                daysList.add(day);
            }
            event.setRepeatByDay(daysList.toArray(new String[0]));
        }
        if (recurrence instanceof Recurrence.IntervalPattern && ((Recurrence.IntervalPattern)recurrence).getInterval() > 0) {
            event.setRepeatInterval((long)((Recurrence.IntervalPattern)recurrence).getInterval());
        }
        if (recurrence.getEndDate() != null) {
            event.setRepeatUntilDate(CalendarConverterService.getExoDateFromExchangeFormat(recurrence.getEndDate()));
        }
        if (recurrence.getNumberOfOccurrences() != null) {
            event.setRepeatCount((long)recurrence.getNumberOfOccurrences().intValue());
        }
    }

    public static List<CalendarEvent> convertExchangeToExoOccurenceEvent(CalendarEvent masterEvent, List<CalendarEvent> updatedEvents, List<String> appointmentIds, Appointment masterAppointment, String username, JCRDataStorage storage, UserHandler userHandler, CorrespondenceService correspondenceService, TimeZone timeZone) throws Exception {
        OccurrenceInfoCollection occurrenceInfoCollection = (masterAppointment = Appointment.bind((ExchangeService)masterAppointment.getService(), (ItemId)masterAppointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.ModifiedOccurrences}))).getModifiedOccurrences();
        if (occurrenceInfoCollection != null && occurrenceInfoCollection.getCount() > 0) {
            for (OccurrenceInfo occurrenceInfo : occurrenceInfoCollection) {
                Appointment occurenceAppointment = Appointment.bind((ExchangeService)masterAppointment.getService(), (ItemId)occurrenceInfo.getItemId(), (PropertySet)new PropertySet(BasePropertySet.FirstClassProperties));
                String exoId = correspondenceService.getCorrespondingId(username, occurenceAppointment.getId().getUniqueId());
                CalendarEvent tmpEvent = null;
                if (!StringUtils.isEmpty((String)exoId)) {
                    tmpEvent = storage.getEvent(username, exoId);
                }
                if (tmpEvent == null) {
                    tmpEvent = CalendarConverterService.getOccurenceOfDate(username, storage, masterEvent, CalendarConverterService.getExoDateFromExchangeFormat(occurrenceInfo.getOriginalStart()), timeZone);
                }
                if (tmpEvent != null && CalendarConverterService.verifyModifiedDatesConflict(tmpEvent, occurenceAppointment)) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)"Attempting to update eXo Occurent Event with Exchange Event, but modification date of eXo is after, ignore updating.");
                    continue;
                }
                if (tmpEvent == null || tmpEvent.getIsExceptionOccurrence() == null || !tmpEvent.getIsExceptionOccurrence().booleanValue()) {
                    tmpEvent = new CalendarEvent();
                    CalendarConverterService.convertExchangeToExoEvent(tmpEvent, occurenceAppointment, username, storage, userHandler, timeZone);
                    tmpEvent.setRecurrenceId(RECURRENCE_ID_FORMAT.format(tmpEvent.getFromDateTime()));
                    tmpEvent.setRepeatType(CalendarEvent.RP_NOREPEAT);
                    tmpEvent.setId(masterEvent.getId());
                    tmpEvent.setCalendarId(masterEvent.getCalendarId());
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Create exo calendar Occurence event: " + tmpEvent.getSummary() + ", with recurence id: " + tmpEvent.getRecurrenceId()));
                    }
                } else {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Update exo calendar Occurence event: " + tmpEvent.getSummary() + ", with recurence id: " + tmpEvent.getRecurrenceId()));
                    }
                    CalendarConverterService.convertExchangeToExoEvent(tmpEvent, occurenceAppointment, username, storage, userHandler, timeZone);
                }
                updatedEvents.add(tmpEvent);
                appointmentIds.add(occurenceAppointment.getId().getUniqueId());
            }
        }
        masterAppointment = Appointment.bind((ExchangeService)masterAppointment.getService(), (ItemId)masterAppointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.DeletedOccurrences}));
        ArrayList<CalendarEvent> calendarEvents = new ArrayList<CalendarEvent>();
        DeletedOccurrenceInfoCollection deletedOccurrenceInfoCollection = masterAppointment.getDeletedOccurrences();
        if (deletedOccurrenceInfoCollection != null && deletedOccurrenceInfoCollection.getCount() > 0) {
            for (DeletedOccurrenceInfo occurrenceInfo : deletedOccurrenceInfoCollection) {
                CalendarEvent toDeleteEvent = CalendarConverterService.getOccurenceOfDate(username, storage, masterEvent, CalendarConverterService.getExoDateFromExchangeFormat(occurrenceInfo.getOriginalStart()), timeZone);
                if (toDeleteEvent == null) continue;
                String appId = correspondenceService.getCorrespondingId(username, toDeleteEvent.getId());
                Appointment appointment = null;
                try {
                    appointment = Appointment.bind((ExchangeService)masterAppointment.getService(), (ItemId)ItemId.getItemIdFromString((String)appId));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (appointment != null && toDeleteEvent.getIsExceptionOccurrence() != null && toDeleteEvent.getIsExceptionOccurrence().booleanValue()) continue;
                calendarEvents.add(toDeleteEvent);
            }
        }
        return calendarEvents;
    }

    public static boolean verifyModifiedDatesConflict(CalendarEvent event, Appointment item) throws Exception {
        if (event.getLastUpdatedTime() == null) {
            return false;
        }
        if (item.getLastModifiedTime() == null) {
            return true;
        }
        Date eventModifDate = CalendarConverterService.convertDateToUTC(event.getLastUpdatedTime());
        Date itemModifDate = item.getLastModifiedTime();
        return eventModifDate.getTime() >= itemModifDate.getTime();
    }

    public static void convertExoToExchangeEvent(Appointment appointment, CalendarEvent calendarEvent, String username, UserHandler userHandler, TimeZoneDefinition serverTimeZoneDefinition, TimeZone userCalendarTimeZone) throws Exception {
        CalendarConverterService.setAppointmentStatus(appointment, calendarEvent);
        CalendarConverterService.setAppointmentDates(appointment, calendarEvent, serverTimeZoneDefinition, userCalendarTimeZone);
        CalendarConverterService.setAppointmentPriority(appointment, calendarEvent);
        CalendarConverterService.setAppointmentCategory(appointment, calendarEvent);
        CalendarConverterService.setAppointmentAttendees(appointment, calendarEvent, userHandler, username);
        CalendarConverterService.setAppointmentReminder(appointment, calendarEvent);
        appointment.setLocation(calendarEvent.getLocation());
        appointment.setSubject((Object)calendarEvent.getSummary());
        if (calendarEvent.isPrivate()) {
            appointment.setSensitivity(Sensitivity.Private);
        } else {
            appointment.setSensitivity(Sensitivity.Normal);
        }
        CalendarConverterService.setAppointmentAttachements(appointment, calendarEvent);
        CalendarConverterService.setApoinementSummary(appointment, calendarEvent);
    }

    public static List<Appointment> convertExoToExchangeMasterRecurringCalendarEvent(Appointment appointment, CalendarEvent event, String username, UserHandler userHandler, TimeZoneDefinition serverTimeZoneDefinition, TimeZone userCalendarTimeZone) throws Exception {
        List<Appointment> toDeleteOccurences = null;
        CalendarConverterService.convertExoToExchangeEvent(appointment, event, username, userHandler, serverTimeZoneDefinition, userCalendarTimeZone);
        String repeatType = event.getRepeatType();
        assert (repeatType != null && !repeatType.equals(CalendarEvent.RP_NOREPEAT));
        Recurrence.DailyPattern recurrence = null;
        if (repeatType.equals(CalendarEvent.RP_DAILY)) {
            recurrence = new Recurrence.DailyPattern();
        } else if (repeatType.equals(CalendarEvent.RP_WEEKLY)) {
            String[] repeatDays;
            ArrayList<DayOfTheWeek> daysOfTheWeek = new ArrayList<DayOfTheWeek>();
            for (String repeatDay : repeatDays = event.getRepeatByDay()) {
                if (StringUtils.isEmpty((String)repeatDay)) continue;
                if (repeatDay.equals(CalendarEvent.RP_WEEKLY_BYDAY[0])) {
                    daysOfTheWeek.add(DayOfTheWeek.Monday);
                    continue;
                }
                if (repeatDay.equals(CalendarEvent.RP_WEEKLY_BYDAY[1])) {
                    daysOfTheWeek.add(DayOfTheWeek.Tuesday);
                    continue;
                }
                if (repeatDay.equals(CalendarEvent.RP_WEEKLY_BYDAY[2])) {
                    daysOfTheWeek.add(DayOfTheWeek.Wednesday);
                    continue;
                }
                if (repeatDay.equals(CalendarEvent.RP_WEEKLY_BYDAY[3])) {
                    daysOfTheWeek.add(DayOfTheWeek.Thursday);
                    continue;
                }
                if (repeatDay.equals(CalendarEvent.RP_WEEKLY_BYDAY[4])) {
                    daysOfTheWeek.add(DayOfTheWeek.Friday);
                    continue;
                }
                if (repeatDay.equals(CalendarEvent.RP_WEEKLY_BYDAY[5])) {
                    daysOfTheWeek.add(DayOfTheWeek.Saturday);
                    continue;
                }
                if (!repeatDay.equals(CalendarEvent.RP_WEEKLY_BYDAY[6])) continue;
                daysOfTheWeek.add(DayOfTheWeek.Sunday);
            }
            recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), daysOfTheWeek.toArray(new DayOfTheWeek[0]));
        } else if (repeatType.equals(CalendarEvent.RP_MONTHLY)) {
            if (!(event.getRepeatByMonthDay() != null && event.getRepeatByMonthDay().length != 0 || event.getRepeatByDay() != null && event.getRepeatByDay().length != 0)) {
                throw new IllegalStateException("event '" + event.getSummary() + "' is repeated monthly but value of dayOfMonth is null.");
            }
            if (event.getRepeatByMonthDay() != null || event.getRepeatByMonthDay().length > 0) {
                recurrence = new Recurrence.MonthlyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), (int)event.getRepeatByMonthDay()[0]);
            } else if (event.getRepeatByDay() != null || event.getRepeatByDay().length > 0) {
                String repeatByDay = event.getRepeatByDay()[0];
                int weekIndex = Integer.parseInt(repeatByDay.substring(0, 1));
                String dayPrefix = repeatByDay.substring(1);
                DayOfTheWeek dayOfTheWeek = null;
                DayOfTheWeekIndex dayOfTheWeekIndex = null;
                if (dayPrefix.equals(CalendarEvent.RP_WEEKLY_BYDAY[0])) {
                    dayOfTheWeek = DayOfTheWeek.Monday;
                } else if (dayPrefix.equals(CalendarEvent.RP_WEEKLY_BYDAY[1])) {
                    dayOfTheWeek = DayOfTheWeek.Tuesday;
                } else if (dayPrefix.equals(CalendarEvent.RP_WEEKLY_BYDAY[2])) {
                    dayOfTheWeek = DayOfTheWeek.Wednesday;
                } else if (dayPrefix.equals(CalendarEvent.RP_WEEKLY_BYDAY[3])) {
                    dayOfTheWeek = DayOfTheWeek.Thursday;
                } else if (dayPrefix.equals(CalendarEvent.RP_WEEKLY_BYDAY[4])) {
                    dayOfTheWeek = DayOfTheWeek.Friday;
                } else if (dayPrefix.equals(CalendarEvent.RP_WEEKLY_BYDAY[5])) {
                    dayOfTheWeek = DayOfTheWeek.Saturday;
                } else if (dayPrefix.equals(CalendarEvent.RP_WEEKLY_BYDAY[6])) {
                    dayOfTheWeek = DayOfTheWeek.Sunday;
                } else {
                    LOG.error((Object)("Can't get day of the week name from this prefix: '" + dayPrefix + "'. Monday will be used"));
                    dayOfTheWeek = DayOfTheWeek.Monday;
                }
                switch (weekIndex) {
                    case -1: {
                        dayOfTheWeekIndex = DayOfTheWeekIndex.Last;
                        break;
                    }
                    case 1: {
                        dayOfTheWeekIndex = DayOfTheWeekIndex.First;
                        break;
                    }
                    case 2: {
                        dayOfTheWeekIndex = DayOfTheWeekIndex.Second;
                        break;
                    }
                    case 3: {
                        dayOfTheWeekIndex = DayOfTheWeekIndex.Third;
                        break;
                    }
                    case 4: {
                        dayOfTheWeekIndex = DayOfTheWeekIndex.Fourth;
                        break;
                    }
                    default: {
                        LOG.error((Object)("Can't get week index from this number: '" + weekIndex + "'. First week will be used as default value"));
                        dayOfTheWeekIndex = DayOfTheWeekIndex.First;
                    }
                }
                recurrence = new Recurrence.RelativeMonthlyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), dayOfTheWeek, dayOfTheWeekIndex);
            }
        } else if (repeatType.equals(CalendarEvent.RP_YEARLY)) {
            Calendar tempCalendar = Calendar.getInstance();
            if (event.getRepeatByYearDay() != null && event.getRepeatByYearDay().length > 0) {
                tempCalendar.set(6, (int)event.getRepeatByYearDay()[0]);
            } else {
                tempCalendar.setTime(event.getFromDateTime());
            }
            int monthNumber = tempCalendar.get(2);
            int dayOfMonth = tempCalendar.get(5);
            Month month = Month.values()[monthNumber];
            recurrence = new Recurrence.YearlyPattern(event.getFromDateTime(), month, dayOfMonth);
        } else if (repeatType.equals(CalendarEvent.RP_WORKINGDAYS)) {
            recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), new DayOfTheWeek[]{DayOfTheWeek.Weekday});
        } else if (repeatType.equals(CalendarEvent.RP_WEEKEND)) {
            recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), new DayOfTheWeek[]{DayOfTheWeek.WeekendDay});
        }
        recurrence.setStartDate(event.getFromDateTime());
        if (event.getRepeatUntilDate() == null && event.getRepeatCount() < 1L) {
            recurrence.neverEnds();
        } else if (event.getRepeatUntilDate() != null) {
            recurrence.setEndDate(event.getRepeatUntilDate());
        } else {
            recurrence.setNumberOfOccurrences(Integer.valueOf((int)event.getRepeatCount()));
        }
        appointment.setRecurrence((Recurrence)recurrence);
        if (event.getExceptionIds() != null && event.getExceptionIds().size() > 0) {
            toDeleteOccurences = CalendarConverterService.calculateOccurences(username, appointment, event, userCalendarTimeZone);
            int nbOccurences = recurrence.getNumberOfOccurrences() == null ? 0 : recurrence.getNumberOfOccurrences();
            int deletedAppointmentOccurences = 0;
            try {
                deletedAppointmentOccurences = appointment.getDeletedOccurrences().getCount();
            }
            catch (Exception e) {
                try {
                    appointment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(BasePropertySet.FirstClassProperties));
                    deletedAppointmentOccurences = appointment.getDeletedOccurrences().getCount();
                }
                catch (Exception e2) {
                    deletedAppointmentOccurences = 0;
                }
            }
            if (nbOccurences != 0 && nbOccurences - deletedAppointmentOccurences - toDeleteOccurences.size() == 0) {
                toDeleteOccurences.clear();
                toDeleteOccurences.add(appointment);
            }
        }
        return toDeleteOccurences;
    }

    public static void convertExoToExchangeOccurenceEvent(Appointment occAppointment, CalendarEvent occEvent, String username, UserHandler userHandler, TimeZoneDefinition serverTimeZoneDefinition, TimeZone userCalendarTimeZone) throws Exception {
        CalendarConverterService.convertExoToExchangeEvent(occAppointment, occEvent, username, userHandler, serverTimeZoneDefinition, userCalendarTimeZone);
    }

    public static String getCalendarName(String calendarName) {
        return "EXCH-" + calendarName;
    }

    public static String getCalendarId(String folderId) {
        return "EXCH-" + folderId.hashCode();
    }

    public static boolean isExchangeCalendarId(String calendarId) {
        return calendarId != null && calendarId.startsWith("EXCH");
    }

    public static boolean isExchangeEventId(String eventId) {
        return eventId != null && eventId.startsWith(EXCHANGE_EVENT_ID_PREFIX);
    }

    public static String getEventId(String appointmentId) throws Exception {
        return EXCHANGE_EVENT_ID_PREFIX + appointmentId.hashCode();
    }

    public static boolean isSameDate(Date value1, Date value2) {
        Calendar date1 = Calendar.getInstance();
        date1.setTime(value1);
        Calendar date2 = Calendar.getInstance();
        date2.setTime(value2);
        return CalendarConverterService.isSameDate(date1, date2);
    }

    public static boolean isAllDayEvent(CalendarEvent eventCalendar, TimeZone userCalendarTimeZone) {
        Calendar cal1 = Calendar.getInstance(userCalendarTimeZone);
        cal1.setLenient(false);
        Calendar cal2 = Calendar.getInstance(userCalendarTimeZone);
        cal2.setLenient(false);
        cal1.setTime(eventCalendar.getFromDateTime());
        cal2.setTime(eventCalendar.getToDateTime());
        return cal1.get(11) == 0 && cal1.get(12) == 0 && cal2.get(11) == cal2.getActualMaximum(11) && cal2.get(12) == cal2.getActualMaximum(12);
    }

    public static Date convertDateToUTC(Date date) throws ParseException {
        UTC_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        String time = UTC_DATE_FORMAT.format(date);
        UTC_DATE_FORMAT.setTimeZone(TimeZone.getDefault());
        return UTC_DATE_FORMAT.parse(time);
    }

    public static Date getExoDateFromExchangeFormat(Date date) {
        int exchangeOffset = TimeZone.getDefault().getOffset(date.getTime()) / 60000;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, exchangeOffset);
        return calendar.getTime();
    }

    public static Appointment getAppointmentOccurence(Appointment masterAppointment, String recurrenceId) throws Exception {
        Appointment appointment = null;
        Date occDate = RECURRENCE_ID_FORMAT.parse(recurrenceId);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(occDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        occDate = calendar.getTime();
        Date endDate = masterAppointment.getRecurrence().getEndDate();
        if (endDate != null && occDate.getTime() > endDate.getTime()) {
            return null;
        }
        Integer nbOccurences = masterAppointment.getRecurrence().getNumberOfOccurrences();
        Calendar indexCalendar = Calendar.getInstance();
        indexCalendar.setTime(masterAppointment.getRecurrence().getStartDate());
        boolean continueSearch = true;
        for (int i = 1; continueSearch && (nbOccurences == null || i <= nbOccurences); ++i) {
            Appointment tmpAppointment = null;
            try {
                tmpAppointment = Appointment.bindToOccurrence((ExchangeService)masterAppointment.getService(), (ItemId)masterAppointment.getId(), (int)i, (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.Start}));
                Date date = CalendarConverterService.getExoDateFromExchangeFormat(tmpAppointment.getStart());
                if (CalendarConverterService.isSameDate(occDate, date)) {
                    appointment = Appointment.bindToOccurrence((ExchangeService)masterAppointment.getService(), (ItemId)masterAppointment.getId(), (int)i, (PropertySet)new PropertySet(BasePropertySet.FirstClassProperties));
                    continueSearch = false;
                }
                indexCalendar.setTime(date);
                continue;
            }
            catch (Exception e) {
                indexCalendar.add(5, 1);
            }
            if (!continueSearch || !occDate.before(indexCalendar.getTime()) && (endDate == null || !indexCalendar.getTime().after(endDate))) continue;
            continueSearch = false;
        }
        return appointment;
    }

    public static CalendarEvent getOccurenceOfDate(String username, JCRDataStorage storage, CalendarEvent masterEvent, Date originalStart, TimeZone timeZone) throws Exception {
        Date date = originalStart;
        String recurenceId = RECURRENCE_ID_FORMAT.format(date);
        List exceptionEvents = storage.getExceptionEvents(username, masterEvent);
        if (exceptionEvents != null && !exceptionEvents.isEmpty()) {
            for (CalendarEvent calendarEvent : exceptionEvents) {
                if (!calendarEvent.getRecurrenceId().equals(recurenceId)) continue;
                return calendarEvent;
            }
        }
        Calendar from = Calendar.getInstance(timeZone);
        from.setTime(date);
        from.set(11, 0);
        from.set(12, 0);
        from.set(13, 0);
        from.set(14, 0);
        Calendar to = Calendar.getInstance(timeZone);
        to.setTime(date);
        to.set(11, to.getActualMaximum(11));
        to.set(12, to.getActualMaximum(12));
        to.set(13, to.getActualMaximum(13));
        to.set(14, to.getActualMaximum(14));
        Map map = storage.getOccurrenceEvents(masterEvent, from, to, timeZone.getID());
        CalendarEvent occEvent = null;
        if (map != null && !map.isEmpty()) {
            if (map.size() == 1) {
                occEvent = (CalendarEvent)map.values().iterator().next();
            } else {
                LOG.error((Object)("Error while deleting from eXo an occurence already deleted from Exchange '" + masterEvent.getSummary() + "' in date: '" + date + "'"));
            }
        }
        return occEvent;
    }

    private static void setAppointmentReminder(Appointment appointment, CalendarEvent calendarEvent) throws Exception {
        appointment.setIsReminderSet(Boolean.valueOf(false));
        List reminders = calendarEvent.getReminders();
        if (reminders != null) {
            for (Reminder reminder : reminders) {
                appointment.setIsReminderSet(Boolean.valueOf(true));
                appointment.setReminderMinutesBeforeStart((int)reminder.getAlarmBefore());
                appointment.setReminderDueBy(CalendarConverterService.convertToDefaultTimeZoneFormat(reminder.getFromDateTime()));
            }
        }
    }

    private static List<Appointment> calculateOccurences(String username, Appointment masterAppointment, CalendarEvent event, TimeZone userCalendarTimeZone) throws Exception {
        ArrayList<Appointment> toDeleteOccurence = new ArrayList<Appointment>();
        Collection excludedRecurenceIds = event.getExceptionIds();
        if (excludedRecurenceIds != null) {
            for (String excludedRecurenceId : excludedRecurenceIds) {
                Appointment occAppointment;
                if (excludedRecurenceId.isEmpty() || (occAppointment = CalendarConverterService.getAppointmentOccurence(masterAppointment, excludedRecurenceId)) == null) continue;
                toDeleteOccurence.add(occAppointment);
            }
        }
        return toDeleteOccurence;
    }

    private static String getCategoryName(String categoryName) {
        return categoryName;
    }

    private static boolean isSameDate(Calendar date1, Calendar date2) {
        return date1.get(5) == date2.get(5) && date1.get(2) == date2.get(2) && date1.get(1) == date2.get(1);
    }

    private static void setAppointmentAttendees(Appointment appointment, CalendarEvent calendarEvent, UserHandler userHandler, String username) throws ServiceLocalException {
        AttendeeCollection attendees = appointment.getRequiredAttendees();
        assert (attendees != null);
        CalendarConverterService.computeAttendies(userHandler, username, attendees, calendarEvent.getParticipant());
        attendees = appointment.getOptionalAttendees();
        assert (attendees != null);
        CalendarConverterService.computeAttendies(userHandler, username, attendees, calendarEvent.getInvitation());
    }

    private static void computeAttendies(UserHandler userHandler, String username, AttendeeCollection attendees, String[] participants) {
        if (participants != null && participants.length > 0) {
            for (String partacipant : participants) {
                Attendee attendee;
                if (partacipant == null || partacipant.isEmpty() || partacipant.equals(username)) continue;
                try {
                    User user = userHandler.findUserByName(partacipant);
                    if (CalendarConverterService.containsAttendee(attendees, user.getEmail())) continue;
                    attendee = new Attendee(user.getDisplayName(), user.getEmail());
                    attendees.add(attendee);
                }
                catch (Exception e) {
                    attendee = null;
                    attendee = partacipant.contains("@") ? new Attendee(partacipant.split("@")[0], partacipant) : new Attendee(partacipant, null);
                    attendees.add(attendee);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.warn((Object)("Partacipant '" + partacipant + "' wasn't found in eXo Organization."));
                }
            }
        }
    }

    private static boolean containsAttendee(AttendeeCollection attendees, String email) {
        for (Attendee attendee : attendees) {
            if (!attendee.getAddress().equals(email)) continue;
            return true;
        }
        return false;
    }

    private static void setEventParticipants(CalendarEvent calendarEvent, Appointment appointment, UserHandler userHandler) throws ServiceLocalException {
        Query query = queryThreadLocal.get();
        if (query == null) {
            query = new Query();
            queryThreadLocal.set(query);
        }
        ArrayList<String> participants = new ArrayList<String>();
        CalendarConverterService.addEventPartacipants(appointment.getRequiredAttendees(), userHandler, query, participants);
        CalendarConverterService.addEventPartacipants(appointment.getOptionalAttendees(), userHandler, query, participants);
        CalendarConverterService.addEventPartacipants(appointment.getResources(), userHandler, query, participants);
        if (participants.size() > 0) {
            calendarEvent.setParticipant(participants.toArray(new String[0]));
        }
    }

    private static void addEventPartacipants(AttendeeCollection attendeeCollection, UserHandler userHandler, Query query, List<String> participants) throws ServiceLocalException {
        if (attendeeCollection != null) {
            for (Attendee attendee : attendeeCollection) {
                if (attendee.getAddress() == null || attendee.getAddress().isEmpty()) continue;
                String username = CalendarConverterService.getPartacipantUserName(userHandler, query, attendee);
                if (username == null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Event partacipant was not found, email = " + attendee.getAddress()));
                    }
                    String string = username = attendee.getAddress() == null ? attendee.getName() : attendee.getAddress();
                    if (username == null) {
                        LOG.warn((Object)("No user found for attendee: " + attendee));
                        continue;
                    }
                }
                participants.add(username);
            }
        }
    }

    private static String getPartacipantUserName(UserHandler userHandler, Query query, Attendee attendee) {
        String username;
        block8: {
            username = null;
            query.setEmail(attendee.getAddress());
            try {
                ListAccess listAccess = userHandler.findUsersByQuery(query);
                if (listAccess == null || listAccess.getSize() == 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("User with email '" + attendee.getAddress() + "' was not found in eXo."));
                    }
                } else if (listAccess.getSize() > 1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.warn((Object)("Multiple users have the same email adress: '" + attendee.getAddress() + "'."));
                    }
                } else {
                    username = ((User[])listAccess.load(0, 1))[0].getUserName();
                }
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) break block8;
                LOG.trace((Object)("exception occured while trying to get user with email " + attendee.getAddress()), (Throwable)e);
            }
        }
        return username;
    }

    private static void setAppointmentPriority(Appointment appointment, CalendarEvent calendarEvent) throws Exception {
        if (calendarEvent.getPriority() == null || calendarEvent.getPriority().equals(CalendarEvent.PRIORITY_NONE) || calendarEvent.getPriority().equals(CalendarEvent.PRIORITY_NORMAL)) {
            appointment.setImportance(Importance.Normal);
        } else if (calendarEvent.getPriority().equals(CalendarEvent.PRIORITY_LOW)) {
            appointment.setImportance(Importance.Low);
        } else if (calendarEvent.getPriority().equals(CalendarEvent.PRIORITY_HIGH)) {
            appointment.setImportance(Importance.High);
        }
    }

    private static void setEventPriority(CalendarEvent calendarEvent, Appointment appointment) throws ServiceLocalException {
        if (appointment.getImportance() != null) {
            switch (appointment.getImportance()) {
                case High: {
                    calendarEvent.setPriority(CalendarEvent.PRIORITY_HIGH);
                    break;
                }
                case Low: {
                    calendarEvent.setPriority(CalendarEvent.PRIORITY_LOW);
                    break;
                }
                case Normal: {
                    calendarEvent.setPriority(CalendarEvent.PRIORITY_NORMAL);
                }
            }
        } else {
            calendarEvent.setPriority(CalendarEvent.PRIORITY_NORMAL);
        }
    }

    private static void setAppointmentDates(Appointment appointment, CalendarEvent calendarEvent, TimeZoneDefinition serverTimeZoneDefinition, TimeZone userCalendarTimeZone) throws Exception {
        boolean isAllDay = CalendarConverterService.isAllDayEvent(calendarEvent, userCalendarTimeZone);
        Calendar calendar = Calendar.getInstance();
        if (isAllDay) {
            calendar.setTime(calendarEvent.getFromDateTime());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else {
            calendar.setTime(CalendarConverterService.convertToDefaultTimeZoneFormat(calendarEvent.getFromDateTime()));
        }
        appointment.setStart(calendar.getTime());
        if (isAllDay) {
            calendar.setTime(calendarEvent.getToDateTime());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else {
            calendar.setTime(CalendarConverterService.convertToDefaultTimeZoneFormat(calendarEvent.getToDateTime()));
        }
        appointment.setEnd(calendar.getTime());
        appointment.setIsAllDayEvent(Boolean.valueOf(isAllDay));
    }

    private static void setEventDates(CalendarEvent calendarEvent, Appointment appointment, TimeZone timeZone) throws ServiceLocalException {
        Calendar cal1 = CalendarConverterService.getInstanceOfCurrentCalendar(timeZone);
        Calendar cal2 = CalendarConverterService.getInstanceOfCurrentCalendar(timeZone);
        if (appointment.getAppointmentType().equals((Object)AppointmentType.RecurringMaster)) {
            cal1.setTimeInMillis(CalendarConverterService.getExoDateFromExchangeFormat(appointment.getRecurrence().getStartDate()).getTime());
        } else {
            cal1.setTimeInMillis(CalendarConverterService.getExoDateFromExchangeFormat(appointment.getStart()).getTime());
        }
        cal2.setTimeInMillis(CalendarConverterService.getExoDateFromExchangeFormat(appointment.getEnd()).getTime());
        if (appointment.getIsAllDayEvent().booleanValue()) {
            cal1.set(11, 0);
            cal1.set(12, 0);
            cal2.add(14, -1);
            cal2.set(11, cal2.getActualMaximum(11));
            cal2.set(12, cal2.getActualMaximum(12));
            calendarEvent.setFromDateTime(cal1.getTime());
            calendarEvent.setToDateTime(cal2.getTime());
        } else {
            calendarEvent.setFromDateTime(cal1.getTime());
            calendarEvent.setToDateTime(cal2.getTime());
        }
    }

    public static Calendar getInstanceOfCurrentCalendar(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    private static Date convertToDefaultTimeZoneFormat(Date date) {
        int originalOffset = TimeZone.getDefault().getOffset(date.getTime()) / 60000;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, -originalOffset);
        return calendar.getTime();
    }

    private static void setAppointmentCategory(Appointment appointment, CalendarEvent calendarEvent) throws Exception {
        if (appointment.getCategories() != null) {
            appointment.getCategories().clearList();
        }
        if (calendarEvent.getEventCategoryName() != null && !calendarEvent.getEventCategoryName().isEmpty() && !calendarEvent.getEventCategoryId().equals("defaultEventCategoryIdAll")) {
            if (appointment.getCategories() == null) {
                StringList stringList = new StringList();
                appointment.setCategories(stringList);
            }
            if (!appointment.getCategories().contains(calendarEvent.getEventCategoryName())) {
                appointment.getCategories().add(calendarEvent.getEventCategoryName());
            }
        }
    }

    private static void setEventCategory(CalendarEvent calendarEvent, Appointment appointment, String username, JCRDataStorage storage) throws Exception {
        if (appointment.getCategories() != null && appointment.getCategories().getSize() > 0) {
            String categoryName = appointment.getCategories().getString(0);
            if (categoryName != null && !categoryName.isEmpty()) {
                EventCategory category = CalendarConverterService.getEventCategoryByName(storage, username, CalendarConverterService.getCategoryName(categoryName));
                if (category == null) {
                    category = new EventCategory();
                    category.setDataInit(false);
                    category.setName(CalendarConverterService.getCategoryName(categoryName));
                    category.setId(CalendarConverterService.getCategoryName(categoryName));
                    storage.saveEventCategory(username, category, true);
                }
                calendarEvent.setEventCategoryId(category.getId());
                calendarEvent.setEventCategoryName(category.getName());
            }
        } else {
            EventCategory category = CalendarConverterService.getEventCategoryByName(storage, username, "defaultEventCategoryNameAll");
            if (category == null) {
                LOG.warn((Object)("Default category (defaultEventCategoryNameAll)of eXo Calendar is null for user: " + username + "."));
            } else {
                calendarEvent.setEventCategoryId(category.getId());
                calendarEvent.setEventCategoryName(category.getName());
            }
        }
    }

    private static void setAppointmentAttachements(Appointment appointment, CalendarEvent calendarEvent) throws Exception {
        List attachments = calendarEvent.getAttachment();
        if (attachments != null && !attachments.isEmpty()) {
            AttachmentCollection attachmentCollection = appointment.getAttachments();
            assert (attachmentCollection != null);
            for (Attachment attachment : attachments) {
                FileAttachment fileAttachment = attachmentCollection.addFileAttachment(attachment.getName(), attachment.getInputStream());
                fileAttachment.setContentType(attachment.getMimeType());
            }
        }
    }

    private static void setEventAttachements(CalendarEvent calendarEvent, Appointment appointment) throws Exception {
        if (appointment.getHasAttachments()) {
            Appointment appointmentWithAttachment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.Attachments}));
            Iterator attachmentIterator = appointmentWithAttachment.getAttachments().iterator();
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            while (attachmentIterator.hasNext()) {
                microsoft.exchange.webservices.data.Attachment attachment = (microsoft.exchange.webservices.data.Attachment)attachmentIterator.next();
                if (!(attachment instanceof FileAttachment)) continue;
                FileAttachment fileAttachment = (FileAttachment)attachment;
                Attachment eXoAttachment = new Attachment();
                if (fileAttachment.getSize() == 0) {
                    LOG.warn((Object)("Attachment '" + fileAttachment.getName() + "' of Appoitment " + appointment.getSubject() + ", start date : " + appointment.getStart() + " is empty, ignore it."));
                    continue;
                }
                String contentType = fileAttachment.getContentType();
                if (contentType == null) {
                    contentType = "application/octet-stream";
                    if (LOG.isTraceEnabled()) {
                        LOG.warn((Object)("No mimetype was found for attachement  '" + fileAttachment.getName() + "' of Appoitment " + appointment.getSubject() + ", start date : " + appointment.getStart() + ". Use default: " + contentType));
                    }
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                fileAttachment.load((OutputStream)outputStream);
                eXoAttachment.setInputStream((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                eXoAttachment.setMimeType(contentType);
                eXoAttachment.setName(fileAttachment.getName());
                eXoAttachment.setSize((long)fileAttachment.getSize());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(fileAttachment.getLastModifiedTime());
                eXoAttachment.setLastModified(calendar.getTimeInMillis());
                attachments.add(eXoAttachment);
            }
            if (attachments.isEmpty()) {
                LOG.warn((Object)"Appointment has attachments, but it wasn't retrieved to eXo Calendar Event");
            }
            calendarEvent.setAttachment(attachments);
        }
    }

    private static void setAppointmentStatus(Appointment appointment, CalendarEvent calendarEvent) throws Exception {
        String status;
        String string = status = calendarEvent.getStatus() == null || calendarEvent.getStatus().isEmpty() ? calendarEvent.getEventState() : calendarEvent.getStatus();
        if (status == null) {
            status = "";
        }
        if (status.equals(CalendarEvent.ST_AVAILABLE)) {
            appointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.Free);
        } else if (status.equals(CalendarEvent.ST_BUSY)) {
            appointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.Busy);
        } else if (status.equals(CalendarEvent.ST_OUTSIDE)) {
            appointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.OOF);
        } else {
            appointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.NoData);
        }
    }

    private static void setEventStatus(CalendarEvent calendarEvent, Appointment appointment) throws ServiceLocalException {
        if (appointment.getLegacyFreeBusyStatus() != null) {
            switch (appointment.getLegacyFreeBusyStatus()) {
                case Free: {
                    calendarEvent.setStatus(CalendarEvent.ST_AVAILABLE);
                    calendarEvent.setEventState(CalendarEvent.ST_AVAILABLE);
                    break;
                }
                case Busy: {
                    calendarEvent.setStatus(CalendarEvent.ST_BUSY);
                    calendarEvent.setEventState(CalendarEvent.ST_BUSY);
                    break;
                }
                case OOF: {
                    calendarEvent.setStatus(CalendarEvent.ST_OUTSIDE);
                    calendarEvent.setEventState(CalendarEvent.ST_OUTSIDE);
                    break;
                }
                default: {
                    calendarEvent.setStatus(CalendarEvent.ST_BUSY);
                    calendarEvent.setEventState(CalendarEvent.ST_BUSY);
                }
            }
        }
    }

    private static void setEventReminder(CalendarEvent event, Appointment appointment, String username) throws Exception {
        ArrayList<Reminder> reminders = event.getReminders();
        if (reminders != null) {
            reminders.clear();
        }
        try {
            if (appointment.getIsReminderSet()) {
                if (reminders == null) {
                    reminders = new ArrayList<Reminder>();
                    event.setReminders(reminders);
                }
                Reminder reminder = new Reminder();
                reminder.setFromDateTime(appointment.getReminderDueBy());
                reminder.setAlarmBefore((long)appointment.getReminderMinutesBeforeStart());
                reminder.setDescription("");
                reminder.setEventId(event.getId());
                reminder.setReminderType(Reminder.TYPE_POPUP);
                reminder.setReminderOwner(username);
                reminder.setRepeate(false);
                reminder.setRepeatInterval((long)appointment.getReminderMinutesBeforeStart());
                reminders.add(reminder);
            }
        }
        catch (ServiceObjectPropertyException se) {
            // empty catch block
        }
    }

    private static EventCategory getEventCategoryByName(JCRDataStorage storage, String username, String eventCategoryName) throws Exception {
        for (EventCategory ev : storage.getEventCategories(username)) {
            if (!ev.getName().equalsIgnoreCase(eventCategoryName)) continue;
            return ev;
        }
        return null;
    }

    private static void setApoinementSummary(Appointment appointment, CalendarEvent event) throws Exception, ServiceLocalException {
        if (event.getDescription() != null && !event.getDescription().isEmpty()) {
            appointment.setBody(MessageBody.getMessageBodyFromText((String)event.getDescription()));
        }
    }

    private static void setEventDescription(CalendarEvent event, Appointment appointment) throws Exception, ServiceLocalException {
        PropertySet bodyPropSet = new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.Body});
        bodyPropSet.setRequestedBodyType(BodyType.Text);
        appointment.load(bodyPropSet);
        event.setDescription(appointment.getBody().toString());
    }
}

