/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.TimeSpan;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import microsoft.exchange.webservices.data.TimeZonePeriod;
import microsoft.exchange.webservices.data.TimeZoneTransition;
import microsoft.exchange.webservices.data.XmlNamespace;

abstract class AbsoluteMonthTransition
extends TimeZoneTransition {
    private TimeSpan timeOffset;
    private int month;

    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (super.tryReadElementFromXml(reader)) {
            return true;
        }
        if (reader.getLocalName().equals("TimeOffset")) {
            this.timeOffset = EwsUtilities.getXSDurationToTimeSpan(reader.readElementValue());
            return true;
        }
        if (reader.getLocalName().equals("Month")) {
            this.month = reader.readElementValue(Integer.class);
            EwsUtilities.EwsAssert(this.month > 0 && this.month <= 12, "AbsoluteMonthTransition.TryReadElementFromXml", "month is not in the valid 1 - 12 range.");
            return true;
        }
        return false;
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        super.writeElementsToXml(writer);
        writer.writeElementValue(XmlNamespace.Types, "TimeOffset", EwsUtilities.getTimeSpanToXSDuration(this.timeOffset));
        writer.writeElementValue(XmlNamespace.Types, "Month", this.month);
    }

    protected AbsoluteMonthTransition(TimeZoneDefinition timeZoneDefinition) {
        super(timeZoneDefinition);
    }

    protected AbsoluteMonthTransition(TimeZoneDefinition timeZoneDefinition, TimeZonePeriod targetPeriod) {
        super(timeZoneDefinition, targetPeriod);
    }

    protected TimeSpan getTimeOffset() {
        return this.timeOffset;
    }

    protected int getMonth() {
        return this.month;
    }
}

