/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.ArgumentNullException;
import microsoft.exchange.webservices.data.EWSHttpException;
import microsoft.exchange.webservices.data.EventType;
import microsoft.exchange.webservices.data.EwsEnum;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FileAsMapping;
import microsoft.exchange.webservices.data.FormatException;
import microsoft.exchange.webservices.data.HttpWebRequest;
import microsoft.exchange.webservices.data.IAction;
import microsoft.exchange.webservices.data.ICreateServiceObjectWithAttachmentParam;
import microsoft.exchange.webservices.data.ICreateServiceObjectWithServiceParam;
import microsoft.exchange.webservices.data.ILazyMember;
import microsoft.exchange.webservices.data.IPredicate;
import microsoft.exchange.webservices.data.ISelfValidate;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemAttachment;
import microsoft.exchange.webservices.data.ItemTraversal;
import microsoft.exchange.webservices.data.LazyMember;
import microsoft.exchange.webservices.data.MailboxType;
import microsoft.exchange.webservices.data.MeetingRequestsDeliveryScope;
import microsoft.exchange.webservices.data.RequiredServerVersion;
import microsoft.exchange.webservices.data.RuleProperty;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceObjectInfo;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.TimeSpan;
import microsoft.exchange.webservices.data.WellKnownFolderName;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EwsUtilities {
    protected static final String XSFalse = "false";
    protected static final String XSTrue = "true";
    protected static final String EwsTypesNamespacePrefix = "t";
    protected static final String EwsMessagesNamespacePrefix = "m";
    protected static final String EwsErrorsNamespacePrefix = "e";
    protected static final String EwsSoapNamespacePrefix = "soap";
    protected static final String EwsXmlSchemaInstanceNamespacePrefix = "xsi";
    protected static final String PassportSoapFaultNamespacePrefix = "psf";
    protected static final String WSTrustFebruary2005NamespacePrefix = "wst";
    protected static final String WSAddressingNamespacePrefix = "wsa";
    protected static final String AutodiscoverSoapNamespacePrefix = "a";
    protected static final String WSSecurityUtilityNamespacePrefix = "wsu";
    protected static final String WSSecuritySecExtNamespacePrefix = "wsse";
    protected static final String EwsTypesNamespace = "http://schemas.microsoft.com/exchange/services/2006/types";
    protected static final String EwsMessagesNamespace = "http://schemas.microsoft.com/exchange/services/2006/messages";
    protected static final String EwsErrorsNamespace = "http://schemas.microsoft.com/exchange/services/2006/errors";
    protected static final String EwsSoapNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
    protected static final String EwsSoap12Namespace = "http://www.w3.org/2003/05/soap-envelope";
    protected static final String EwsXmlSchemaInstanceNamespace = "http://www.w3.org/2001/XMLSchema-instance";
    protected static final String PassportSoapFaultNamespace = "http://schemas.microsoft.com/Passport/SoapServices/SOAPFault";
    protected static final String WSTrustFebruary2005Namespace = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    protected static final String WSAddressingNamespace = "http://www.w3.org/2005/08/addressing";
    protected static final String AutodiscoverSoapNamespace = "http://schemas.microsoft.com/exchange/2010/Autodiscover";
    protected static final String WSSecurityUtilityNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    protected static final String WSSecuritySecExtNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static LazyMember<ServiceObjectInfo> serviceObjectInfo = new LazyMember<ServiceObjectInfo>(new ILazyMember<ServiceObjectInfo>(){

        @Override
        public ServiceObjectInfo createInstance() {
            return new ServiceObjectInfo();
        }
    });
    private static LazyMember<Map<Class<?>, Map<String, ExchangeVersion>>> enumVersionDictionaries = new LazyMember(new ILazyMember<Map<Class<?>, Map<String, ExchangeVersion>>>(){

        @Override
        public Map<Class<?>, Map<String, ExchangeVersion>> createInstance() {
            HashMap enumDicts = new HashMap();
            enumDicts.put(WellKnownFolderName.class, EwsUtilities.buildEnumDict(WellKnownFolderName.class));
            enumDicts.put(ItemTraversal.class, EwsUtilities.buildEnumDict(ItemTraversal.class));
            enumDicts.put(FileAsMapping.class, EwsUtilities.buildEnumDict(FileAsMapping.class));
            enumDicts.put(EventType.class, EwsUtilities.buildEnumDict(EventType.class));
            enumDicts.put(MeetingRequestsDeliveryScope.class, EwsUtilities.buildEnumDict(MeetingRequestsDeliveryScope.class));
            return enumDicts;
        }
    });
    private static LazyMember<Map<Class<?>, Map<String, String>>> schemaToEnumDictionaries = new LazyMember(new ILazyMember<Map<Class<?>, Map<String, String>>>(){

        @Override
        public Map<Class<?>, Map<String, String>> createInstance() {
            HashMap enumDicts = new HashMap();
            enumDicts.put(EventType.class, EwsUtilities.buildSchemaToEnumDict(EventType.class));
            enumDicts.put(MailboxType.class, EwsUtilities.buildSchemaToEnumDict(MailboxType.class));
            enumDicts.put(FileAsMapping.class, EwsUtilities.buildSchemaToEnumDict(FileAsMapping.class));
            enumDicts.put(RuleProperty.class, EwsUtilities.buildSchemaToEnumDict(RuleProperty.class));
            return enumDicts;
        }
    });
    protected static LazyMember<Map<Class<?>, Map<String, String>>> enumToSchemaDictionaries = new LazyMember(new ILazyMember<Map<Class<?>, Map<String, String>>>(){

        @Override
        public Map<Class<?>, Map<String, String>> createInstance() {
            HashMap enumDicts = new HashMap();
            enumDicts.put(EventType.class, EwsUtilities.buildEnumToSchemaDict(EventType.class));
            enumDicts.put(MailboxType.class, EwsUtilities.buildEnumToSchemaDict(MailboxType.class));
            enumDicts.put(FileAsMapping.class, EwsUtilities.buildEnumToSchemaDict(FileAsMapping.class));
            enumDicts.put(RuleProperty.class, EwsUtilities.buildEnumToSchemaDict(RuleProperty.class));
            return enumDicts;
        }
    });
    private static LazyMember<Map<String, String>> typeNameToShortNameMap = new LazyMember<Map<String, String>>(new ILazyMember<Map<String, String>>(){

        @Override
        public Map<String, String> createInstance() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("Boolean", "bool");
            result.put("Int16", "short");
            result.put("Int32", "int");
            result.put("String", "string");
            return result;
        }
    });
    protected static final String DomainRegex = "^[-a-zA-Z0-9_.]+$";

    EwsUtilities() {
    }

    protected static void copyStream(ByteArrayOutputStream source, ByteArrayOutputStream target) throws Exception {
        ByteArrayOutputStream memContentStream = source;
        if (memContentStream != null) {
            memContentStream.writeTo(target);
            memContentStream.flush();
        } else {
            int c;
            ByteArrayInputStream inStream = new ByteArrayInputStream(source.toByteArray());
            while ((c = inStream.read()) != -1) {
                target.write((char)c);
            }
        }
    }

    public static String getBuildVersion() {
        return "0.0.0.0";
    }

    protected static void EwsAssert(boolean condition, String caller, String message) {
        assert (condition) : String.format("[%s] %s", caller, message);
    }

    protected static String getNamespacePrefix(XmlNamespace xmlNamespace) {
        return xmlNamespace.getNameSpacePrefix();
    }

    protected static String getNamespaceUri(XmlNamespace xmlNamespace) {
        return xmlNamespace.getNameSpaceUri();
    }

    protected static XmlNamespace getNamespaceFromUri(String namespaceUri) {
        if (namespaceUri.equals(EwsErrorsNamespace)) {
            return XmlNamespace.Errors;
        }
        if (namespaceUri.equals(EwsTypesNamespace)) {
            return XmlNamespace.Types;
        }
        if (namespaceUri.equals(EwsMessagesNamespace)) {
            return XmlNamespace.Messages;
        }
        if (namespaceUri.equals(EwsSoapNamespace)) {
            return XmlNamespace.Soap;
        }
        if (namespaceUri.equals(EwsSoap12Namespace)) {
            return XmlNamespace.Soap12;
        }
        if (namespaceUri.equals(EwsXmlSchemaInstanceNamespace)) {
            return XmlNamespace.XmlSchemaInstance;
        }
        if (namespaceUri.equals(PassportSoapFaultNamespace)) {
            return XmlNamespace.PassportSoapFault;
        }
        if (namespaceUri.equals(WSTrustFebruary2005Namespace)) {
            return XmlNamespace.WSTrustFebruary2005;
        }
        if (namespaceUri.equals(WSAddressingNamespace)) {
            return XmlNamespace.WSAddressing;
        }
        return XmlNamespace.NotSpecified;
    }

    protected static <TServiceObject extends ServiceObject> TServiceObject createEwsObjectFromXmlElementName(Class<?> itemClass, ExchangeService service, String xmlElementName) throws Exception {
        if (serviceObjectInfo.getMember().getXmlElementNameToServiceObjectClassMap().containsKey(xmlElementName)) {
            itemClass = serviceObjectInfo.getMember().getXmlElementNameToServiceObjectClassMap().get(xmlElementName);
            if (serviceObjectInfo.getMember().getServiceObjectConstructorsWithServiceParam().containsKey(itemClass)) {
                ICreateServiceObjectWithServiceParam creationDelegate = serviceObjectInfo.getMember().getServiceObjectConstructorsWithServiceParam().get(itemClass);
                return (TServiceObject)((ServiceObject)creationDelegate.createServiceObjectWithServiceParam(service));
            }
            throw new IllegalArgumentException(Strings.NoAppropriateConstructorForItemClass);
        }
        return (TServiceObject)((ServiceObject)itemClass.newInstance());
    }

    protected static Item createItemFromItemClass(ItemAttachment itemAttachment, Class itemClass, boolean isNew) throws Exception {
        if (serviceObjectInfo.getMember().getServiceObjectConstructorsWithAttachmentParam().containsKey(itemClass)) {
            ICreateServiceObjectWithAttachmentParam creationDelegate = serviceObjectInfo.getMember().getServiceObjectConstructorsWithAttachmentParam().get(itemClass);
            return (Item)creationDelegate.createServiceObjectWithAttachmentParam(itemAttachment, isNew);
        }
        throw new IllegalArgumentException(Strings.NoAppropriateConstructorForItemClass);
    }

    protected static Item createItemFromXmlElementName(ItemAttachment itemAttachment, String xmlElementName) throws Exception {
        if (serviceObjectInfo.getMember().getXmlElementNameToServiceObjectClassMap().containsKey(xmlElementName)) {
            Class<?> itemClass = serviceObjectInfo.getMember().getXmlElementNameToServiceObjectClassMap().get(xmlElementName);
            return EwsUtilities.createItemFromItemClass(itemAttachment, itemClass, false);
        }
        return null;
    }

    protected static Class getItemTypeFromXmlElementName(String xmlElementName) {
        return serviceObjectInfo.getMember().getXmlElementNameToServiceObjectClassMap().get(xmlElementName).getClass();
    }

    static <TItem extends Item> TItem findFirstItemOfType(Class<TItem> cls, Iterable<Item> items) {
        for (Item item : items) {
            if (!item.getClass().equals(cls)) continue;
            return (TItem)item;
        }
        return null;
    }

    private static void writeTraceStartElement(XMLStreamWriter writer, String traceTag, boolean includeVersion) throws XMLStreamException {
        writer.writeStartElement("Trace");
        writer.writeAttribute("Tag", traceTag);
        writer.writeAttribute("Tid", Thread.currentThread().getId() + "");
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String formattedString = df.format(d);
        writer.writeAttribute("Time", formattedString);
        if (includeVersion) {
            writer.writeAttribute("Version", EwsUtilities.getBuildVersion());
        }
    }

    protected static String formatLogMessage(String entryKind, String logEntry) throws XMLStreamException, IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(outStream);
        EwsUtilities.writeTraceStartElement(writer, entryKind, false);
        writer.writeCharacters(System.getProperty("line.separator"));
        writer.writeCharacters(logEntry);
        writer.writeCharacters(System.getProperty("line.separator"));
        writer.writeEndElement();
        writer.writeCharacters(System.getProperty("line.separator"));
        writer.flush();
        writer.close();
        outStream.flush();
        String formattedLogMessage = outStream.toString();
        formattedLogMessage = formattedLogMessage.replaceAll("&apos;", "'");
        formattedLogMessage = formattedLogMessage.replaceAll("&quot;", "\"");
        formattedLogMessage = formattedLogMessage.replaceAll("&gt;", ">");
        formattedLogMessage = formattedLogMessage.replaceAll("&lt;", "<");
        formattedLogMessage = formattedLogMessage.replaceAll("&amp;", "&");
        outStream.close();
        return formattedLogMessage;
    }

    protected static String formatHttpResponseHeaders(HttpWebRequest response) throws EWSHttpException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%d %s\n", response.getResponseCode(), response.getResponseContentType()));
        sb.append(EwsUtilities.formatHttpHeaders(response.getResponseHeaders()));
        sb.append("\n");
        return sb.toString();
    }

    protected static String formatHttpRequestHeaders(HttpWebRequest request) throws URISyntaxException, EWSHttpException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s %s HTTP/%s\n", request.getRequestMethod().toUpperCase(), request.getUrl().toURI().getPath(), "1.1"));
        sb.append(EwsUtilities.formatHttpHeaders(request.getRequestProperty()));
        sb.append("\n");
        return sb.toString();
    }

    private static String formatHttpHeaders(Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            sb.append(String.format("%s : %s\n", header.getKey(), header.getValue()));
        }
        return sb.toString();
    }

    protected static String formatLogMessageWithXmlContent(String traceTypeStr, ByteArrayOutputStream stream) {
        try {
            return EwsUtilities.formatLogMessage(traceTypeStr, stream.toString());
        }
        catch (Exception e) {
            return stream.toString();
        }
    }

    protected static String boolToXSBool(Boolean value) {
        return value != false ? XSTrue : XSFalse;
    }

    protected static <T extends Enum> void parseEnumValueList(Class<T> c, List<T> list, String value, char ... separators) {
        String[] enumValues;
        EwsUtilities.EwsAssert(c.isEnum(), "EwsUtilities.ParseEnumValueList", "T is not an enum type.");
        StringBuffer regexp = new StringBuffer("");
        regexp.append("[");
        for (char s : separators) {
            regexp.append("[");
            regexp.append(Pattern.quote(s + ""));
            regexp.append("]");
        }
        regexp.append("]");
        for (String enumValue : enumValues = value.split(regexp.toString())) {
            for (Enum o : (Enum[])c.getEnumConstants()) {
                if (!o.toString().equals(enumValue)) continue;
                list.add(o);
            }
        }
    }

    protected static String serializeEnum(Object value) {
        Enum e;
        Map<String, String> enumToStringDict;
        String strValue = value.toString();
        if (enumToSchemaDictionaries.getMember().containsKey(value.getClass()) && (enumToStringDict = enumToSchemaDictionaries.getMember().get(value.getClass())).containsKey((e = (Enum)value).name())) {
            strValue = enumToStringDict.get(e.name());
        }
        return strValue;
    }

    protected static <T> T parse(Class<T> cls, String value) throws InstantiationException, IllegalAccessException, ParseException {
        if (cls.isEnum()) {
            if (schemaToEnumDictionaries.getMember().containsKey(cls)) {
                Map<String, String> stringToEnumDict = schemaToEnumDictionaries.getMember().get(cls);
                if (stringToEnumDict.containsKey(value)) {
                    String strEnumName = stringToEnumDict.get(value);
                    for (T o : cls.getEnumConstants()) {
                        if (!o.toString().equals(strEnumName)) continue;
                        return o;
                    }
                    return null;
                }
                for (T o : cls.getEnumConstants()) {
                    if (!o.toString().equals(value)) continue;
                    return o;
                }
                return null;
            }
            for (T o : cls.getEnumConstants()) {
                if (!o.toString().equals(value)) continue;
                return o;
            }
            return null;
        }
        if (cls.isInstance(0)) {
            Integer o = null;
            o = Integer.parseInt(value);
            return (T)o;
        }
        if (cls.isInstance(new Date())) {
            Object o = null;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            return (T)df.parse(value);
        }
        if (cls.isInstance(false)) {
            Boolean o = null;
            o = Boolean.parseBoolean(value);
            return (T)o;
        }
        if (cls.isInstance(new String())) {
            return (T)value;
        }
        if (cls.isInstance(0.0)) {
            Double o = null;
            o = Double.parseDouble(value);
            return (T)o;
        }
        return null;
    }

    private static <E extends Enum<E>> Map<String, String> buildSchemaToEnumDict(Class<E> c) {
        Field[] fields;
        HashMap<String, String> dict = new HashMap<String, String>();
        for (Field f : fields = c.getDeclaredFields()) {
            if (!f.isEnumConstant() || !f.isAnnotationPresent(EwsEnum.class)) continue;
            EwsEnum ewsEnum = f.getAnnotation(EwsEnum.class);
            String fieldName = f.getName();
            String schemaName = ewsEnum.schemaName();
            if (schemaName.isEmpty()) continue;
            dict.put(schemaName, fieldName);
        }
        return dict;
    }

    protected static void validateParamCollection(EventType[] eventTypes, String paramName) throws Exception {
        EwsUtilities.validateParam(eventTypes, paramName);
        int count = 0;
        for (EventType event : eventTypes) {
            try {
                EwsUtilities.validateParam((Object)event, String.format("collection[%d] , ", count));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("The element at position %d is invalid", count), e);
            }
            ++count;
        }
        if (count == 0) {
            throw new IllegalArgumentException(String.format(Strings.CollectionIsEmpty, paramName));
        }
    }

    static String dateTimeToXSDate(Date date) {
        String format = "yyyy-MM-dd'Z'";
        SimpleDateFormat utcFormatter = new SimpleDateFormat(format);
        return utcFormatter.format(date);
    }

    protected static String dateTimeToXSDateTime(Date date) {
        String format = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        SimpleDateFormat utcFormatter = new SimpleDateFormat(format);
        return utcFormatter.format(date);
    }

    protected static String getTimeSpanToXSDuration(TimeSpan timeOffset) {
        String offsetStr = timeOffset.getTotalSeconds() < 0.0 ? "-" : "";
        return String.format("%sP%sDT%sH%sM%sS", offsetStr, Math.abs(timeOffset.getDays()), Math.abs(timeOffset.getHours()), Math.abs(timeOffset.getMinutes()), Math.abs(timeOffset.getSeconds()) + "." + Math.abs(timeOffset.getMilliseconds()));
    }

    protected static TimeSpan getXSDurationToTimeSpan(String xsDuration) {
        Pattern timeSpanParser = Pattern.compile("-P");
        Matcher m = timeSpanParser.matcher(xsDuration);
        boolean negative = false;
        System.out.println(m.find());
        if (m.find()) {
            negative = true;
        }
        System.out.println(m.group());
        m = Pattern.compile("(\\d+)Y").matcher(xsDuration);
        System.out.println(m.find());
        int year = 0;
        if (m.find()) {
            year = Integer.parseInt(m.group().substring(0, m.group().indexOf("Y")));
        }
        m = Pattern.compile("(\\d+)M").matcher(xsDuration);
        System.out.println(m.find());
        int month = 0;
        if (m.find()) {
            month = Integer.parseInt(m.group().substring(0, m.group().indexOf("M")));
        }
        m = Pattern.compile("(\\d+)D").matcher(xsDuration);
        System.out.println(m.find());
        int day = 0;
        if (m.find()) {
            day = Integer.parseInt(m.group().substring(0, m.group().indexOf("D")));
        }
        m = Pattern.compile("(\\d+)H").matcher(xsDuration);
        System.out.println(m.find());
        int hour = 0;
        if (m.find()) {
            hour = Integer.parseInt(m.group().substring(0, m.group().indexOf("H")));
        }
        m = Pattern.compile("(\\d+)M").matcher(xsDuration);
        System.out.println(m.find());
        int minute = 0;
        if (m.find()) {
            minute = Integer.parseInt(m.group().substring(0, m.group().indexOf("M")));
        }
        m = Pattern.compile("(\\d+).").matcher(xsDuration);
        System.out.println(m.find());
        int seconds = 0;
        if (m.find()) {
            seconds = Integer.parseInt(m.group().substring(0, m.group().indexOf(".")));
        }
        int milliseconds = 0;
        m = Pattern.compile("(\\d+)S").matcher(xsDuration);
        System.out.println(m.find());
        if (m.find()) {
            if (m.group().length() > 5) {
                milliseconds = Integer.parseInt(m.group().substring(0, 4));
            } else {
                seconds = Integer.parseInt(m.group().substring(0, m.group().indexOf("S")));
            }
        }
        day = day + year * 365 + month * 30;
        long retval = (((day * 24 + hour) * 60 + minute) * 60 + seconds) * 1000 + milliseconds;
        if (negative) {
            retval = -retval;
        }
        return new TimeSpan(retval);
    }

    protected static TimeSpan getXSDurationToTimeSpanValue(String xsDuration) {
        Pattern timeSpanParser = Pattern.compile("-P");
        Matcher m = timeSpanParser.matcher(xsDuration);
        boolean negative = false;
        if (m.find()) {
            negative = true;
        }
        m = Pattern.compile("(\\d+)Y").matcher(xsDuration);
        int year = 0;
        if (m.find()) {
            year = Integer.parseInt(m.group().substring(0, m.group().indexOf("Y")));
        }
        m = Pattern.compile("(\\d+)M").matcher(xsDuration);
        int month = 0;
        if (m.find()) {
            month = Integer.parseInt(m.group().substring(0, m.group().indexOf("M")));
        }
        m = Pattern.compile("(\\d+)D").matcher(xsDuration);
        long day = 0L;
        if (m.find()) {
            day = Integer.parseInt(m.group().substring(0, m.group().indexOf("D")));
        }
        m = Pattern.compile("(\\d+)H").matcher(xsDuration);
        int hour = 0;
        if (m.find()) {
            hour = Integer.parseInt(m.group().substring(0, m.group().indexOf("H")));
        }
        m = Pattern.compile("(\\d+)M").matcher(xsDuration);
        int minute = 0;
        if (m.find()) {
            minute = Integer.parseInt(m.group().substring(0, m.group().indexOf("M")));
        }
        m = Pattern.compile("(\\d+).").matcher(xsDuration);
        int seconds = 0;
        int milliseconds = 0;
        m = Pattern.compile("(\\d+)S").matcher(xsDuration);
        if (m.find()) {
            if (m.group().length() > 5) {
                milliseconds = Integer.parseInt(m.group().substring(0, 4));
            } else {
                seconds = Integer.parseInt(m.group().substring(0, m.group().indexOf("S")));
            }
        }
        long retval = (((day * 24L + (long)hour) * 60L + (long)minute) * 60L + (long)seconds) * 1000L + (long)milliseconds;
        if (negative) {
            retval = -retval;
        }
        return new TimeSpan(retval);
    }

    public static String timeSpanToXSTime(TimeSpan timeSpan) {
        DecimalFormat myFormatter = new DecimalFormat("00");
        return String.format("%s:%s:%s", myFormatter.format(timeSpan.getHours()), myFormatter.format(timeSpan.getMinutes()), myFormatter.format(timeSpan.getSeconds()));
    }

    public static String getPrintableTypeName(Class type) {
        Type[] genericArgs = type.getGenericInterfaces();
        if (genericArgs.length > 0) {
            String genericPrefix = type.getName().substring(0, type.getName().indexOf(96));
            StringBuilder nameBuilder = new StringBuilder(genericPrefix);
            StringBuffer genericArgsStr = new StringBuffer();
            for (int i = 0; i < genericArgs.length; ++i) {
                if (!"".equals(genericArgsStr.toString())) {
                    genericArgsStr.append(",");
                }
                genericArgsStr.append(EwsUtilities.getPrintableTypeName(genericArgs[i].getClass()));
            }
            nameBuilder.append("<");
            nameBuilder.append(genericArgsStr.toString());
            nameBuilder.append(">");
            return nameBuilder.toString();
        }
        if (type.isArray()) {
            String arrayPrefix = type.getName().substring(0, type.getName().indexOf(91));
            StringBuilder nameBuilder = new StringBuilder(EwsUtilities.getSimplifiedTypeName(arrayPrefix));
            for (int rank = 0; rank < EwsUtilities.getDim(type); ++rank) {
                nameBuilder.append("[]");
            }
            return nameBuilder.toString();
        }
        return EwsUtilities.getSimplifiedTypeName(type.getName());
    }

    private static String getSimplifiedTypeName(String typeName) {
        return typeNameToShortNameMap.getMember().containsKey(typeName) ? typeNameToShortNameMap.getMember().get(typeName) : typeName;
    }

    protected static String domainFromEmailAddress(String emailAddress) throws FormatException {
        String[] emailAddressParts = emailAddress.split("@");
        if (emailAddressParts.length != 2 || emailAddressParts[1] == null || emailAddressParts[1].isEmpty()) {
            throw new FormatException(Strings.InvalidEmailAddress);
        }
        return emailAddressParts[1];
    }

    public static int getDim(Object array) {
        int dim = 0;
        Class<?> c = array.getClass();
        while (c.isArray()) {
            c = c.getComponentType();
            ++dim;
        }
        return dim;
    }

    protected static void validateParamAllowNull(Object param, String paramName) throws Exception {
        ServiceObject ewsObject;
        if (param instanceof ISelfValidate) {
            ISelfValidate selfValidate = (ISelfValidate)param;
            try {
                selfValidate.validate();
            }
            catch (ServiceValidationException e) {
                throw new Exception(String.format("%s %s", Strings.ValidationFailed, paramName), e);
            }
        }
        if (param instanceof ServiceObject && (ewsObject = (ServiceObject)param).isNew()) {
            throw new Exception(String.format("%s %s", Strings.ObjectDoesNotHaveId, paramName));
        }
    }

    protected static void validateParam(Object param, String paramName) throws Exception {
        boolean isValid = false;
        if (param != null && param instanceof String) {
            String strParam = (String)param;
            isValid = !strParam.isEmpty();
        } else {
            boolean bl = isValid = param != null;
        }
        if (!isValid) {
            throw new Exception(String.format("Argument %s not valid", paramName));
        }
        EwsUtilities.validateParamAllowNull(param, paramName);
    }

    protected static <T> void validateParamCollection(Iterator<T> collection, String paramName) throws Exception {
        EwsUtilities.validateParam(collection, paramName);
        int count = 0;
        while (collection.hasNext()) {
            T obj = collection.next();
            try {
                EwsUtilities.validateParam(obj, String.format("collection[%d],", count));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("The element at position %d is invalid", count), e);
            }
            ++count;
        }
        if (count == 0) {
            throw new IllegalArgumentException(String.format(Strings.CollectionIsEmpty, paramName));
        }
    }

    protected static void validateNonBlankStringParamAllowNull(String param, String paramName) throws ArgumentException, ServiceLocalException {
        if (param != null && param.length() == EwsUtilities.countMatchingChars(param, new IPredicate<Character>(){

            @Override
            public boolean predicate(Character obj) {
                return Character.isWhitespace(obj.charValue());
            }
        })) {
            throw new ArgumentException(Strings.ArgumentIsBlankString, paramName);
        }
    }

    protected static void validateNonBlankStringParam(String param, String paramName) throws ArgumentNullException, ArgumentException, ServiceLocalException {
        if (param == null) {
            throw new ArgumentNullException(paramName);
        }
        EwsUtilities.validateNonBlankStringParamAllowNull(param, paramName);
    }

    protected static void validateEnumVersionValue(Enum<?> enumValue, ExchangeVersion requestVersion) throws ServiceVersionException {
        ExchangeVersion enumVersion;
        int i;
        Map<String, ExchangeVersion> enumVersionDict = enumVersionDictionaries.getMember().get(enumValue.getClass());
        if (enumVersionDict.containsKey(enumValue.toString()) && (i = requestVersion.compareTo(enumVersion = enumVersionDict.get(enumValue.toString()))) < 0) {
            throw new ServiceVersionException(String.format("%S,%S,%S,%S", new Object[]{Strings.EnumValueIncompatibleWithRequestVersion, enumValue.toString(), enumValue.getClass().getName(), enumVersion}));
        }
    }

    protected static void validateServiceObjectVersion(ServiceObject serviceObject, ExchangeVersion requestVersion) throws ServiceVersionException {
        ExchangeVersion minimumRequiredServerVersion = serviceObject.getMinimumRequiredServerVersion();
        if (requestVersion.ordinal() < minimumRequiredServerVersion.ordinal()) {
            String msg = String.format(Strings.ObjectTypeIncompatibleWithRequestVersion, serviceObject.getClass().getName(), minimumRequiredServerVersion.toString());
            throw new ServiceVersionException(msg);
        }
    }

    protected static void validatePropertyVersion(ExchangeService service, ExchangeVersion minimumServerVersion, String propertyName) throws ServiceVersionException {
        if (service.getRequestedServerVersion().ordinal() < minimumServerVersion.ordinal()) {
            throw new ServiceVersionException(String.format(Strings.PropertyIncompatibleWithRequestVersion, new Object[]{propertyName, minimumServerVersion}));
        }
    }

    protected static void validateMethodVersion(ExchangeService service, ExchangeVersion minimumServerVersion, String methodName) throws ServiceVersionException {
        if (service.getRequestedServerVersion().ordinal() < minimumServerVersion.ordinal()) {
            throw new ServiceVersionException(String.format(Strings.MethodIncompatibleWithRequestVersion, new Object[]{methodName, minimumServerVersion}));
        }
    }

    protected static void validateClassVersion(ExchangeService service, ExchangeVersion minimumServerVersion, String className) throws ServiceVersionException {
        if (service.getRequestedServerVersion().ordinal() < minimumServerVersion.ordinal()) {
            throw new ServiceVersionException(String.format(Strings.ClassIncompatibleWithRequestVersion, new Object[]{className, minimumServerVersion}));
        }
    }

    protected static void validateDomainNameAllowNull(String domainName, String paramName) throws ArgumentException {
        Pattern domainNamePattern;
        Matcher domainNameMatcher;
        if (domainName != null && !(domainNameMatcher = (domainNamePattern = Pattern.compile(DomainRegex)).matcher(domainName)).find()) {
            throw new ArgumentException(String.format(Strings.InvalidDomainName, domainName), paramName);
        }
    }

    private static <E extends Enum<E>> Map<String, ExchangeVersion> buildEnumDict(Class<E> c) {
        Field[] fields;
        HashMap<String, ExchangeVersion> dict = new HashMap<String, ExchangeVersion>();
        for (Field f : fields = c.getDeclaredFields()) {
            if (!f.isEnumConstant() || !f.isAnnotationPresent(RequiredServerVersion.class)) continue;
            RequiredServerVersion ewsEnum = f.getAnnotation(RequiredServerVersion.class);
            String fieldName = f.getName();
            ExchangeVersion exchangeVersion = ewsEnum.version();
            dict.put(fieldName, exchangeVersion);
        }
        return dict;
    }

    private static Map<String, String> buildEnumToSchemaDict(Class<?> c) {
        Field[] fields;
        HashMap<String, String> dict = new HashMap<String, String>();
        for (Field f : fields = c.getFields()) {
            if (!f.isEnumConstant() || !f.isAnnotationPresent(EwsEnum.class)) continue;
            EwsEnum ewsEnum = f.getAnnotation(EwsEnum.class);
            String fieldName = f.getName();
            String schemaName = ewsEnum.schemaName();
            if (schemaName.isEmpty()) continue;
            dict.put(fieldName, schemaName);
        }
        return dict;
    }

    protected static <T> int getEnumeratedObjectCount(Iterator<T> objects) {
        int count = 0;
        while (objects != null && objects.hasNext()) {
            T obj = objects.next();
            ++count;
        }
        return count;
    }

    protected static <T> Object getEnumeratedObjectAt(Iterable<T> objects, int index) {
        int count = 0;
        for (T obj : objects) {
            if (count == index) {
                return obj;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException(Strings.IEnumerableDoesNotContainThatManyObject);
    }

    protected static int countMatchingChars(String str, IPredicate<Character> charPredicate) throws ServiceLocalException {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (!charPredicate.predicate(Character.valueOf(str.charAt(i)))) continue;
            ++count;
        }
        return count;
    }

    protected static <T> boolean trueForAll(Iterable<T> collection, IPredicate<T> predicate) throws ServiceLocalException {
        for (T entry : collection) {
            if (predicate.predicate(entry)) continue;
            return false;
        }
        return true;
    }

    protected static <T> void forEach(Iterable<T> collection, IAction<T> action) {
        for (T entry : collection) {
            action.action(entry);
        }
    }
}

