/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.DelegateManagementRequestBase;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.GetDelegateResponse;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.UserId;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetDelegateRequest
extends DelegateManagementRequestBase<GetDelegateResponse> {
    private List<UserId> userIds = new ArrayList<UserId>();
    private boolean includePermissions;

    protected GetDelegateRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected GetDelegateResponse createResponse() {
        return new GetDelegateResponse(true);
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        writer.writeAttributeValue("IncludePermissions", this.getIncludePermissions());
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeElementsToXml(writer);
        if (this.getUserIds().size() > 0) {
            writer.writeStartElement(XmlNamespace.Messages, "UserIds");
            for (UserId userId : this.getUserIds()) {
                userId.writeToXml(writer, "UserId");
            }
            writer.writeEndElement();
        }
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetDelegateResponse";
    }

    @Override
    protected String getXmlElementName() {
        return "GetDelegate";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public List<UserId> getUserIds() {
        return this.userIds;
    }

    public boolean getIncludePermissions() {
        return this.includePermissions;
    }

    public void setIncludePermissions(boolean includePermissions) {
        this.includePermissions = includePermissions;
    }
}

