/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.GetRequest;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemIdWrapperList;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObjectType;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GetItemRequestBase<TResponse extends ServiceResponse>
extends GetRequest<Item, TResponse> {
    private ItemIdWrapperList itemIds = new ItemIdWrapperList();

    protected GetItemRequestBase(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getItemIds().iterator(), "ItemIds");
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.itemIds.getCount();
    }

    @Override
    protected ServiceObjectType getServiceObjectType() {
        return ServiceObjectType.Item;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeElementsToXml(writer);
        this.itemIds.writeToXml(writer, XmlNamespace.Messages, "ItemIds");
    }

    @Override
    protected String getXmlElementName() {
        return "GetItem";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetItemResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "GetItemResponseMessage";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public ItemIdWrapperList getItemIds() {
        return this.itemIds;
    }
}

