/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import microsoft.exchange.webservices.data.Base64EncoderStream;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.FormatException;
import microsoft.exchange.webservices.data.IFunction;
import microsoft.exchange.webservices.data.ILazyMember;
import microsoft.exchange.webservices.data.LazyMember;
import microsoft.exchange.webservices.data.MapiPropertyType;
import microsoft.exchange.webservices.data.MapiTypeConverterMap;
import microsoft.exchange.webservices.data.MapiTypeConverterMapEntry;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapiTypeConverter {
    private static LazyMember<MapiTypeConverterMap> mapiTypeConverterMap = new LazyMember<MapiTypeConverterMap>(new ILazyMember<MapiTypeConverterMap>(){

        @Override
        public MapiTypeConverterMap createInstance() {
            MapiTypeConverterMap map = new MapiTypeConverterMap();
            map.put(MapiPropertyType.ApplicationTime, new MapiTypeConverterMapEntry(Double.class));
            MapiTypeConverterMapEntry mapitype = new MapiTypeConverterMapEntry(Double.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.ApplicationTimeArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Byte[].class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    return Base64EncoderStream.decode(s);
                }
            });
            mapitype.setConvertToString(new IFunction<Object, String>(){

                @Override
                public String func(Object o) {
                    return Base64EncoderStream.encode((byte[])o);
                }
            });
            map.put(MapiPropertyType.Binary, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Byte[].class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    return Base64EncoderStream.decode(s);
                }
            });
            mapitype.setConvertToString(new IFunction<Object, String>(){

                @Override
                public String func(Object o) {
                    return Base64EncoderStream.encode((byte[])o);
                }
            });
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.BinaryArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Boolean.class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    return Boolean.parseBoolean(s);
                }
            });
            mapitype.setConvertToString(new IFunction<Object, String>(){

                @Override
                public String func(Object o) {
                    return ((Boolean)o).toString().toLowerCase();
                }
            });
            map.put(MapiPropertyType.Boolean, mapitype);
            mapitype = new MapiTypeConverterMapEntry(UUID.class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    return UUID.fromString(s);
                }
            });
            mapitype.setConvertToString(new IFunction<Object, String>(){

                @Override
                public String func(Object o) {
                    return ((UUID)o).toString();
                }
            });
            map.put(MapiPropertyType.CLSID, mapitype);
            mapitype = new MapiTypeConverterMapEntry(UUID.class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    return UUID.fromString(s);
                }
            });
            mapitype.setConvertToString(new IFunction<Object, String>(){

                @Override
                public String func(Object o) {
                    return ((UUID)o).toString();
                }
            });
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.CLSIDArray, mapitype);
            map.put(MapiPropertyType.Currency, new MapiTypeConverterMapEntry(Long.class));
            mapitype = new MapiTypeConverterMapEntry(Long.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.CurrencyArray, mapitype);
            map.put(MapiPropertyType.Double, new MapiTypeConverterMapEntry(Double.class));
            mapitype = new MapiTypeConverterMapEntry(Double.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.DoubleArray, mapitype);
            map.put(MapiPropertyType.Error, new MapiTypeConverterMapEntry(Integer.class));
            map.put(MapiPropertyType.Float, new MapiTypeConverterMapEntry(Float.class));
            mapitype = new MapiTypeConverterMapEntry(Float.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.FloatArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Integer.class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    return MapiTypeConverter.parseMapiIntegerValue(s);
                }
            });
            map.put(MapiPropertyType.Integer, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Integer.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.IntegerArray, mapitype);
            map.put(MapiPropertyType.Long, new MapiTypeConverterMapEntry(Long.class));
            mapitype = new MapiTypeConverterMapEntry(Long.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.LongArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(String.class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    return s;
                }
            });
            map.put(MapiPropertyType.Object, mapitype);
            mapitype = new MapiTypeConverterMapEntry(String.class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    return s;
                }
            });
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.ObjectArray, mapitype);
            map.put(MapiPropertyType.Short, new MapiTypeConverterMapEntry(Short.class));
            mapitype = new MapiTypeConverterMapEntry(Short.class);
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.ShortArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(String.class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    return s;
                }
            });
            map.put(MapiPropertyType.String, mapitype);
            mapitype = new MapiTypeConverterMapEntry(String.class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    return s;
                }
            });
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.StringArray, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Date.class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    String utcPattern = "yyyy-MM-dd'T'HH:mm:ss'Z'";
                    Date dt = null;
                    String errMsg = String.format("Date String %s not in valid UTC/local format", s);
                    SimpleDateFormat utcFormatter = new SimpleDateFormat(utcPattern);
                    if (s.endsWith("Z")) {
                        try {
                            dt = utcFormatter.parse(s);
                        }
                        catch (ParseException e) {
                            s = s.substring(0, 10) + "T12:00:00Z";
                            try {
                                dt = utcFormatter.parse(s);
                            }
                            catch (ParseException e1) {
                                e.printStackTrace();
                                throw new IllegalArgumentException(errMsg, e);
                            }
                        }
                    } else {
                        if (s.endsWith("z")) {
                            utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'z'");
                            try {
                                dt = utcFormatter.parse(s);
                            }
                            catch (ParseException e) {
                                throw new IllegalArgumentException(e);
                            }
                        }
                        utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        try {
                            dt = utcFormatter.parse(s);
                        }
                        catch (ParseException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    return dt;
                }
            });
            mapitype.setConvertToString(new IFunction<Object, String>(){

                @Override
                public String func(Object o) {
                    return EwsUtilities.dateTimeToXSDateTime((Date)o);
                }
            });
            map.put(MapiPropertyType.SystemTime, mapitype);
            mapitype = new MapiTypeConverterMapEntry(Date.class);
            mapitype.setParse(new IFunction<String, Object>(){

                @Override
                public Object func(String s) {
                    String utcPattern = "yyyy-MM-dd'T'HH:mm:ss'Z'";
                    Date dt = null;
                    String errMsg = String.format("Date String %s not in valid UTC/local format", s);
                    SimpleDateFormat utcFormatter = new SimpleDateFormat(utcPattern);
                    if (s.endsWith("Z")) {
                        try {
                            dt = utcFormatter.parse(s);
                        }
                        catch (ParseException e) {
                            s = s.substring(0, 10) + "T12:00:00Z";
                            try {
                                dt = utcFormatter.parse(s);
                            }
                            catch (ParseException e1) {
                                e.printStackTrace();
                                throw new IllegalArgumentException(errMsg, e);
                            }
                        }
                    } else {
                        if (s.endsWith("z")) {
                            utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'z'");
                            try {
                                dt = utcFormatter.parse(s);
                            }
                            catch (ParseException e) {
                                throw new IllegalArgumentException(e);
                            }
                        }
                        utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        try {
                            dt = utcFormatter.parse(s);
                        }
                        catch (ParseException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    return dt;
                }
            });
            mapitype.setConvertToString(new IFunction<Object, String>(){

                @Override
                public String func(Object o) {
                    return EwsUtilities.dateTimeToXSDateTime((Date)o);
                }
            });
            mapitype.setIsArray(true);
            map.put(MapiPropertyType.SystemTimeArray, mapitype);
            return map;
        }
    });

    MapiTypeConverter() {
    }

    protected static List convertToValue(MapiPropertyType mapiPropType, Iterator<String> strings) throws Exception {
        EwsUtilities.validateParam(strings, "strings");
        MapiTypeConverterMapEntry typeConverter = MapiTypeConverter.getMapiTypeConverterMap().get((Object)mapiPropType);
        ArrayList<Object> array = new ArrayList<Object>();
        int index = 0;
        while (strings.hasNext()) {
            Object value = typeConverter.ConvertToValueOrDefault(strings.next());
            array.add(index, value);
        }
        return array;
    }

    protected static Object convertToValue(MapiPropertyType mapiPropType, String stringValue) throws ServiceXmlDeserializationException, FormatException {
        return MapiTypeConverter.getMapiTypeConverterMap().get((Object)mapiPropType).convertToValue(stringValue);
    }

    protected static String convertToString(MapiPropertyType mapiPropType, Object value) {
        return value == null ? "" : MapiTypeConverter.getMapiTypeConverterMap().get((Object)mapiPropType).getConvertToString().func(value);
    }

    protected static Object changeType(MapiPropertyType mapiType, Object value) throws Exception {
        EwsUtilities.validateParam(value, "value");
        return MapiTypeConverter.getMapiTypeConverterMap().get((Object)mapiType).changeType(value);
    }

    protected static Object parseMapiIntegerValue(String s) {
        try {
            int intValue = Integer.parseInt(s.trim());
            return new Integer(intValue);
        }
        catch (NumberFormatException e) {
            return s;
        }
    }

    protected static boolean isArrayType(MapiPropertyType mapiType) {
        return MapiTypeConverter.getMapiTypeConverterMap().get((Object)mapiType).getIsArray();
    }

    protected static Map<MapiPropertyType, MapiTypeConverterMapEntry> getMapiTypeConverterMap() {
        return mapiTypeConverterMap.getMember();
    }
}

