/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.BasePropertySet;
import microsoft.exchange.webservices.data.BodyType;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ILazyMember;
import microsoft.exchange.webservices.data.ISelfValidate;
import microsoft.exchange.webservices.data.LazyMember;
import microsoft.exchange.webservices.data.PropertyDefinition;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.ServiceObjectType;
import microsoft.exchange.webservices.data.ServiceRequestBase;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertySet
implements ISelfValidate,
Iterable<PropertyDefinitionBase> {
    public static final PropertySet IdOnly = PropertySet.createReadonlyPropertySet(BasePropertySet.IdOnly);
    public static final PropertySet FirstClassProperties = PropertySet.createReadonlyPropertySet(BasePropertySet.FirstClassProperties);
    private static LazyMember<Map<BasePropertySet, String>> defaultPropertySetMap = new LazyMember<Map<BasePropertySet, String>>(new ILazyMember<Map<BasePropertySet, String>>(){

        @Override
        public Map<BasePropertySet, String> createInstance() {
            HashMap<BasePropertySet, String> result = new HashMap<BasePropertySet, String>();
            result.put(BasePropertySet.IdOnly, BasePropertySet.IdOnly.getBaseShapeValue());
            result.put(BasePropertySet.FirstClassProperties, BasePropertySet.FirstClassProperties.getBaseShapeValue());
            return result;
        }
    });
    private BasePropertySet basePropertySet;
    private List<PropertyDefinitionBase> additionalProperties = new ArrayList<PropertyDefinitionBase>();
    private BodyType requestedBodyType;
    private Boolean filterHtml;
    private Boolean convertHtmlCodePageToUTF8;
    private boolean isReadOnly;

    private static PropertySet getIdOnly() {
        return IdOnly;
    }

    public static PropertySet getFirstClassProperties() {
        return FirstClassProperties;
    }

    public PropertySet(BasePropertySet basePropertySet, PropertyDefinitionBase ... additionalProperties) {
        this.basePropertySet = basePropertySet;
        if (null != additionalProperties) {
            for (PropertyDefinitionBase property : additionalProperties) {
                this.additionalProperties.add(property);
            }
        }
    }

    public PropertySet(BasePropertySet basePropertySet, Iterator<PropertyDefinitionBase> additionalProperties) {
        this.basePropertySet = basePropertySet;
        if (null != additionalProperties) {
            while (additionalProperties.hasNext()) {
                this.additionalProperties.add(additionalProperties.next());
            }
        }
    }

    public PropertySet() {
        this.basePropertySet = BasePropertySet.IdOnly;
    }

    public PropertySet(BasePropertySet basePropertySet) {
        this.basePropertySet = basePropertySet;
    }

    public PropertySet(PropertyDefinitionBase ... additionalProperties) {
        this(BasePropertySet.IdOnly, additionalProperties);
    }

    public PropertySet(Iterator<PropertyDefinitionBase> additionalProperties) {
        this(BasePropertySet.IdOnly, additionalProperties);
    }

    public static PropertySet getPropertySetFromBasePropertySet(BasePropertySet basePropertySet) {
        return new PropertySet(basePropertySet);
    }

    public void add(PropertyDefinitionBase property) throws Exception {
        this.throwIfReadonly();
        EwsUtilities.validateParam(property, "property");
        if (!this.additionalProperties.contains(property)) {
            this.additionalProperties.add(property);
        }
    }

    public void addRange(Iterable<PropertyDefinitionBase> properties) throws Exception {
        this.throwIfReadonly();
        Iterator<PropertyDefinitionBase> property = properties.iterator();
        EwsUtilities.validateParamCollection(property, "properties");
        Iterator<PropertyDefinitionBase> it = properties.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public void clear() {
        this.throwIfReadonly();
        this.additionalProperties.clear();
    }

    private static PropertySet createReadonlyPropertySet(BasePropertySet basePropertySet) {
        PropertySet propertySet = new PropertySet(basePropertySet);
        propertySet.isReadOnly = true;
        return propertySet;
    }

    private void throwIfReadonly() {
        if (this.isReadOnly) {
            throw new UnsupportedOperationException(Strings.PropertySetCannotBeModified);
        }
    }

    public boolean contains(PropertyDefinitionBase property) {
        return this.additionalProperties.contains(property);
    }

    public boolean remove(PropertyDefinitionBase property) {
        this.throwIfReadonly();
        return this.additionalProperties.remove(property);
    }

    public BasePropertySet getBasePropertySet() {
        return this.basePropertySet;
    }

    public static LazyMember<Map<BasePropertySet, String>> getDefaultPropertySetMap() {
        return defaultPropertySetMap;
    }

    public void setBasePropertySet(BasePropertySet basePropertySet) {
        this.throwIfReadonly();
        this.basePropertySet = basePropertySet;
    }

    public BodyType getRequestedBodyType() {
        return this.requestedBodyType;
    }

    public void setRequestedBodyType(BodyType requestedBodyType) {
        this.throwIfReadonly();
        this.requestedBodyType = requestedBodyType;
    }

    public int getCount() {
        return this.additionalProperties.size();
    }

    public Boolean getFilterHtmlContent() {
        return this.filterHtml;
    }

    public void setFilterHtmlContent(Boolean filterHtml) {
        this.throwIfReadonly();
        this.filterHtml = filterHtml;
    }

    public Boolean getConvertHtmlCodePageToUTF8() {
        return this.convertHtmlCodePageToUTF8;
    }

    public void setConvertHtmlCodePageToUTF8(Boolean value) {
        this.throwIfReadonly();
        this.convertHtmlCodePageToUTF8 = value;
    }

    public PropertyDefinitionBase getPropertyDefinitionBaseAt(int index) {
        return this.additionalProperties.get(index);
    }

    @Override
    public void validate() throws ServiceValidationException {
        this.internalValidate();
    }

    protected static void writeAdditionalPropertiesToXml(EwsServiceXmlWriter writer, Iterator<PropertyDefinitionBase> propertyDefinitions) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, "AdditionalProperties");
        while (propertyDefinitions.hasNext()) {
            PropertyDefinitionBase propertyDefinition = propertyDefinitions.next();
            propertyDefinition.writeToXml(writer);
        }
        writer.writeEndElement();
    }

    protected void internalValidate() throws ServiceValidationException {
        for (int i = 0; i < this.additionalProperties.size(); ++i) {
            if (this.additionalProperties.get(i) != null) continue;
            throw new ServiceValidationException(String.format(Strings.AdditionalPropertyIsNull, i));
        }
    }

    protected void validateForRequest(ServiceRequestBase request, boolean summaryPropertiesOnly) throws ServiceVersionException, ServiceValidationException {
        for (PropertyDefinitionBase propDefBase : this.additionalProperties) {
            if (!(propDefBase instanceof PropertyDefinition)) continue;
            PropertyDefinition propertyDefinition = (PropertyDefinition)propDefBase;
            if (propertyDefinition.getVersion().ordinal() > request.getService().getRequestedServerVersion().ordinal()) {
                throw new ServiceVersionException(String.format(Strings.PropertyIncompatibleWithRequestVersion, new Object[]{propertyDefinition.getName(), propertyDefinition.getVersion()}));
            }
            if (!summaryPropertiesOnly || propertyDefinition.hasFlag(PropertyDefinitionFlags.CanFind, request.getService().getRequestedServerVersion())) continue;
            throw new ServiceValidationException(String.format("ServiceValidationException :%s,%s,%s", Strings.NonSummaryPropertyCannotBeUsed, propertyDefinition.getName(), request.getXmlElementName()));
        }
        if (this.getFilterHtmlContent() != null && request.getService().getRequestedServerVersion().compareTo(ExchangeVersion.Exchange2010) < 0) {
            throw new ServiceVersionException(String.format(Strings.PropertyIncompatibleWithRequestVersion, new Object[]{"FilterHtmlContent", ExchangeVersion.Exchange2010}));
        }
        if (this.getConvertHtmlCodePageToUTF8() != null && request.getService().getRequestedServerVersion().compareTo(ExchangeVersion.Exchange2010_SP1) < 0) {
            throw new ServiceVersionException(String.format(Strings.PropertyIncompatibleWithRequestVersion, new Object[]{"ConvertHtmlCodePageToUTF8", ExchangeVersion.Exchange2010_SP1}));
        }
    }

    protected void writeToXml(EwsServiceXmlWriter writer, ServiceObjectType serviceObjectType) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Messages, serviceObjectType == ServiceObjectType.Item ? "ItemShape" : "FolderShape");
        writer.writeElementValue(XmlNamespace.Types, "BaseShape", this.getBasePropertySet().getBaseShapeValue());
        if (serviceObjectType == ServiceObjectType.Item) {
            if (this.getRequestedBodyType() != null) {
                writer.writeElementValue(XmlNamespace.Types, "BodyType", (Object)this.getRequestedBodyType());
            }
            if (this.getFilterHtmlContent() != null) {
                writer.writeElementValue(XmlNamespace.Types, "FilterHtmlContent", this.getFilterHtmlContent());
            }
            if (this.getConvertHtmlCodePageToUTF8() != null && writer.getService().getRequestedServerVersion().compareTo(ExchangeVersion.Exchange2010_SP1) >= 0) {
                writer.writeElementValue(XmlNamespace.Types, "ConvertHtmlCodePageToUTF8", this.getConvertHtmlCodePageToUTF8());
            }
        }
        if (this.additionalProperties.size() > 0) {
            PropertySet.writeAdditionalPropertiesToXml(writer, this.additionalProperties.iterator());
        }
        writer.writeEndElement();
    }

    @Override
    public Iterator<PropertyDefinitionBase> iterator() {
        return this.additionalProperties.iterator();
    }
}

