/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceObjectType;
import microsoft.exchange.webservices.data.SyncFolderHierarchyResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SyncFolderHierarchyRequest
extends MultiResponseServiceRequest<SyncFolderHierarchyResponse> {
    private PropertySet propertySet;
    private FolderId syncFolderId;
    private String syncState;

    protected SyncFolderHierarchyRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected SyncFolderHierarchyResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new SyncFolderHierarchyResponse(this.getPropertySet());
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected String getXmlElementName() {
        return "SyncFolderHierarchy";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "SyncFolderHierarchyResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "SyncFolderHierarchyResponseMessage";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getPropertySet(), "PropertySet");
        if (this.getSyncFolderId() != null) {
            this.getSyncFolderId().validate(this.getService().getRequestedServerVersion());
        }
        this.getPropertySet().validateForRequest(this, false);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getPropertySet().writeToXml(writer, ServiceObjectType.Folder);
        if (this.getSyncFolderId() != null) {
            writer.writeStartElement(XmlNamespace.Messages, "SyncFolderId");
            this.getSyncFolderId().writeToXml(writer);
            writer.writeEndElement();
        }
        writer.writeElementValue(XmlNamespace.Messages, "SyncState", this.getSyncState());
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public void setPropertySet(PropertySet value) {
        this.propertySet = value;
    }

    public FolderId getSyncFolderId() {
        return this.syncFolderId;
    }

    public void setSyncFolderId(FolderId value) {
        this.syncFolderId = value;
    }

    public String getSyncState() {
        return this.syncState;
    }

    public void setSyncState(String value) {
        this.syncState = value;
    }
}

