/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.AutodiscoverErrorCode;
import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class UserSettingError {
    private AutodiscoverErrorCode errorCode;
    private String errorMessage;
    private String settingName;

    protected UserSettingError() {
    }

    protected UserSettingError(AutodiscoverErrorCode errorCode, String errorMessage, String settingName) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.settingName = settingName;
    }

    protected void loadFromXml(EwsXmlReader reader) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("ErrorCode")) {
                this.setErrorCode(reader.readElementValue(AutodiscoverErrorCode.class));
                continue;
            }
            if (reader.getLocalName().equals("ErrorMessage")) {
                this.setErrorMessage(reader.readElementValue());
                continue;
            }
            if (!reader.getLocalName().equals("SettingName")) continue;
            this.setSettingName(reader.readElementValue());
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, "UserSettingError"));
    }

    public AutodiscoverErrorCode getErrorCode() {
        return this.errorCode;
    }

    protected void setErrorCode(AutodiscoverErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getSettingName() {
        return this.settingName;
    }

    protected void setSettingName(String settingName) {
        this.settingName = settingName;
    }
}

