/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.service;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.BasePropertySet;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceObjectPropertyException;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.Appointment;
import microsoft.exchange.webservices.data.core.service.schema.AppointmentSchema;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.calendar.util.Constants;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.extension.exchange.listener.CalendarCreateUpdateAction;
import org.exoplatform.extension.exchange.service.CorrespondenceService;
import org.exoplatform.extension.exchange.service.util.CalendarConverterUtils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;

public class ExoStorageService
implements Serializable {
    private static final String EXO_DATETIME_PROPERTY = "exo:datetime";
    private static final long serialVersionUID = 6614108102985034995L;
    private static final Log LOG = ExoLogger.getLogger(ExoStorageService.class);
    private static final DateFormat EXCLUDE_ID_FORMAT_FIRST_CHARS = new SimpleDateFormat("yyyyMMdd");
    private transient JCRDataStorage storage;
    private transient OrganizationService organizationService;
    private CorrespondenceService correspondenceService;

    public ExoStorageService(OrganizationService organizationService, CalendarService calendarService, CorrespondenceService correspondenceService) {
        this.storage = ((CalendarServiceImpl)calendarService).getDataStorage();
        this.organizationService = organizationService;
        this.correspondenceService = correspondenceService;
    }

    public void deleteEventByAppointmentID(String appointmentId, String username) throws Exception {
        CalendarEvent calendarEvent = this.getEventByAppointmentId(username, appointmentId);
        if (calendarEvent != null) {
            this.deleteEvent(username, calendarEvent);
        }
    }

    public void deleteEvent(String username, CalendarEvent calendarEvent) throws Exception {
        if (calendarEvent == null) {
            LOG.warn((Object)("Event is null, can't delete it for username: " + username));
            return;
        }
        if (!(calendarEvent.getRepeatType() != null && !calendarEvent.getRepeatType().equals(CalendarEvent.RP_NOREPEAT) || calendarEvent.getIsExceptionOccurrence() != null && calendarEvent.getIsExceptionOccurrence().booleanValue())) {
            if (LOG.isTraceEnabled()) {
                LOG.debug((Object)("DELETE user calendar event: " + calendarEvent.getSummary()));
            }
            this.storage.removeUserEvent(username, calendarEvent.getCalendarId(), calendarEvent.getId());
            this.correspondenceService.deleteCorrespondingId(username, calendarEvent.getId());
        } else if (calendarEvent.getIsExceptionOccurrence() != null && calendarEvent.getIsExceptionOccurrence().booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DELETE user calendar event exceptional occurence: " + calendarEvent.getSummary() + ", id=" + calendarEvent.getRecurrenceId()));
            }
            this.storage.removeUserEvent(username, calendarEvent.getCalendarId(), calendarEvent.getId());
            this.correspondenceService.deleteCorrespondingId(username, calendarEvent.getId());
        } else if (calendarEvent.getRecurrenceId() != null && !calendarEvent.getRecurrenceId().isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DELETE user calendar event occurence from series: " + calendarEvent.getSummary() + " with id : " + calendarEvent.getRecurrenceId()));
            }
            this.storage.removeOccurrenceInstance(username, calendarEvent);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DELETE user calendar event series: " + calendarEvent.getSummary()));
            }
            this.storage.removeRecurrenceSeries(username, calendarEvent);
            this.correspondenceService.deleteCorrespondingId(username, calendarEvent.getId());
        }
    }

    public boolean deleteCalendar(String username, String folderId) throws Exception {
        List<CalendarEvent> events;
        String calendarId = this.correspondenceService.getCorrespondingId(username, folderId);
        if (calendarId == null) {
            calendarId = CalendarConverterUtils.getCalendarId(folderId);
        }
        if ((events = this.getUserCalendarEvents(username, folderId)) == null) {
            return false;
        }
        for (CalendarEvent calendarEvent : events) {
            this.correspondenceService.deleteCorrespondingId(username, calendarEvent.getId());
        }
        this.storage.removeUserCalendar(username, calendarId);
        this.correspondenceService.deleteCorrespondingId(username, folderId, calendarId);
        return true;
    }

    public Calendar getUserCalendar(String username, String folderId) throws Exception {
        return this.getUserCalendar(username, folderId, true);
    }

    public Calendar getUserCalendar(String username, String folderId, boolean deleteIfCorrespondentExists) throws Exception {
        String calendarId = this.correspondenceService.getCorrespondingId(username, folderId);
        Calendar calendar = null;
        if (calendarId != null && (calendar = this.storage.getUserCalendar(username, calendarId)) == null && deleteIfCorrespondentExists) {
            this.correspondenceService.deleteCorrespondingId(username, folderId);
        }
        return calendar;
    }

    public Calendar getOrCreateUserCalendar(String username, Folder folder) throws Exception {
        Calendar tmpCalendar;
        Calendar calendar = this.getUserCalendar(username, folder.getId().getUniqueId(), false);
        String calendarId = CalendarConverterUtils.getCalendarId(folder.getId().getUniqueId());
        if (calendar == null && (tmpCalendar = this.storage.getUserCalendar(username, calendarId)) != null) {
            this.storage.removeUserCalendar(username, calendarId);
        }
        if (calendar == null) {
            if (LOG.isTraceEnabled()) {
                LOG.debug((Object)("CREATE user calendar from Exchange: " + folder.getDisplayName()));
            }
            calendar = new Calendar();
            calendar.setId(calendarId);
            calendar.setName(CalendarConverterUtils.getCalendarName(folder.getDisplayName()));
            calendar.setCalendarOwner(username);
            calendar.setDataInit(false);
            calendar.setEditPermission(new String[]{"any read"});
            calendar.setCalendarColor(Constants.COLORS[(int)(Math.random() * (double)Constants.COLORS.length)]);
            this.storage.saveUserCalendar(username, calendar, true);
            this.correspondenceService.setCorrespondingId(username, calendar.getId(), folder.getId().getUniqueId());
        }
        return calendar;
    }

    public List<CalendarEvent> getUserCalendarEvents(String username, String folderId) throws Exception {
        Calendar calendar;
        List userEvents = null;
        String calendarId = this.correspondenceService.getCorrespondingId(username, folderId);
        if (calendarId == null) {
            calendarId = CalendarConverterUtils.getCalendarId(folderId);
        }
        if ((calendar = this.storage.getUserCalendar(username, calendarId)) != null) {
            ArrayList<String> calendarIds = new ArrayList<String>();
            calendarIds.add(calendarId);
            userEvents = this.storage.getUserEventByCalendar(username, calendarIds);
        }
        return userEvents;
    }

    public List<CalendarEvent> updateEvent(Appointment appointment, String username) throws Exception {
        return this.createOrUpdateEvent(appointment, username, false);
    }

    public List<CalendarEvent> createEvent(Appointment appointment, String username) throws Exception {
        return this.createOrUpdateEvent(appointment, username, true);
    }

    public List<CalendarEvent> createOrUpdateEvent(Appointment appointment, String username) throws Exception {
        CalendarEvent event;
        boolean isNew;
        boolean bl = isNew = this.correspondenceService.getCorrespondingId(username, appointment.getId().getUniqueId()) == null;
        if (!isNew && (event = this.getEventByAppointmentId(username, appointment.getId().getUniqueId())) == null) {
            isNew = true;
            this.correspondenceService.deleteCorrespondingId(username, appointment.getId().getUniqueId());
        }
        return this.createOrUpdateEvent(appointment, username, isNew);
    }

    public CalendarEvent getEventByAppointmentId(String username, String appointmentId) throws Exception {
        String calEventId = this.correspondenceService.getCorrespondingId(username, appointmentId);
        CalendarEvent event = this.storage.getEvent(username, calEventId);
        if (event == null && calEventId != null) {
            this.correspondenceService.deleteCorrespondingId(username, appointmentId);
        }
        return event;
    }

    public CalendarEvent getExoEventByNode(Node eventNode) throws Exception {
        return this.storage.getEvent(eventNode);
    }

    public String getExoEventMasterRecurenceByOriginalUUID(String uuid) throws Exception {
        Node node = this.storage.getSession(SessionProvider.createSystemProvider()).getNodeByUUID(uuid);
        if (node == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("No original recurrent node was found with UUID: " + uuid));
            }
            return null;
        }
        return node.getName();
    }

    public List<CalendarEvent> getAllExoEvents(String username, Calendar calendar) throws Exception {
        List<String> calendarIds = Collections.singletonList(calendar.getId());
        return this.storage.getUserEventByCalendar(username, calendarIds);
    }

    public List<CalendarEvent> findExoEventsModifiedSince(String username, Calendar calendar, Date date) throws Exception {
        Node calendarHome = this.storage.getUserCalendarHome(username);
        if (calendarHome.hasNode(calendar.getId())) {
            calendarHome = calendarHome.getNode(calendar.getId());
        }
        java.util.Calendar dateCalendar = java.util.Calendar.getInstance();
        dateCalendar.setTime(date);
        return this.getEventsByType(calendarHome, 0, dateCalendar);
    }

    public void updateModifiedDateOfEvent(String username, CalendarEvent event, Date lastModifiedTime) throws Exception {
        Node node = this.storage.getCalendarEventNode(username, event.getCalType(), event.getCalendarId(), event.getId());
        this.modifyUpdateDate(node, lastModifiedTime);
        if (event.getOriginalReference() != null && !event.getOriginalReference().isEmpty()) {
            Node masterNode = this.storage.getSession(SessionProvider.createSystemProvider()).getNodeByUUID(event.getOriginalReference());
            this.modifyUpdateDate(masterNode, lastModifiedTime);
        }
    }

    public CalendarEvent getEvent(String eventId, String username) throws Exception {
        return this.storage.getEvent(username, eventId);
    }

    private List<CalendarEvent> getEventsByType(Node calendarHome, int type, java.util.Calendar date) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery("select * from exo:calendarEvent where (jcr:path like '" + calendarHome.getPath() + "/%') and (exo:lastModifiedDate > TIMESTAMP '" + ISO8601.format((java.util.Calendar)date) + "')", "sql");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            CalendarEvent calEvent = this.storage.getEvent(it.nextNode());
            calEvent.setCalType(String.valueOf(type));
            events.add(calEvent);
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyUpdateDate(Node node, Date lastModifiedTime) throws Exception {
        CalendarCreateUpdateAction.MODIFIED_DATE.set(lastModifiedTime.getTime());
        try {
            GregorianCalendar modifiedCalendar = new GregorianCalendar();
            modifiedCalendar.setTime(lastModifiedTime);
            if (!node.isNodeType(EXO_DATETIME_PROPERTY)) {
                if (node.canAddMixin(EXO_DATETIME_PROPERTY)) {
                    node.addMixin(EXO_DATETIME_PROPERTY);
                }
                node.setProperty("exo:dateCreated", (java.util.Calendar)modifiedCalendar);
            }
            node.setProperty("exo:dateModified", (java.util.Calendar)modifiedCalendar);
            node.save();
        }
        finally {
            CalendarCreateUpdateAction.MODIFIED_DATE.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<CalendarEvent> createOrUpdateEvent(Appointment appointment, String username, boolean isNew) throws Exception {
        block43: {
            calendar = this.getUserCalendar(username, appointment.getParentFolderId().getUniqueId());
            if (calendar == null) {
                ExoStorageService.LOG.warn((Object)"Attempting to synchronize an event without existing associated eXo Calendar.");
                return null;
            }
            updatedEvents = new ArrayList<CalendarEvent>();
            if (appointment.getAppointmentType() == null) break block43;
            switch (1.$SwitchMap$microsoft$exchange$webservices$data$core$enumeration$service$calendar$AppointmentType[appointment.getAppointmentType().ordinal()]) {
                case 1: {
                    event = null;
                    if (isNew) {
                        event = new CalendarEvent();
                        event.setId(null);
                        event.setCalendarId(calendar.getId());
                        updatedEvents.add(event);
                    } else {
                        event = this.getEventByAppointmentId(username, appointment.getId().getUniqueId());
                        if (event.getLastModified() == this.getLastModifiedDate(appointment).getTime()) {
                            ExoStorageService.LOG.trace("IGNORE update eXo event '{}', modified dates are the same", new Object[]{appointment.getSubject()});
                            return updatedEvents;
                        }
                        updatedEvents.add(event);
                        if (CalendarConverterUtils.verifyModifiedDatesConflict(event, appointment)) {
                            if (ExoStorageService.LOG.isTraceEnabled()) {
                                ExoStorageService.LOG.trace((Object)"Attempting to update eXo Event with Exchange Event, but modification date of eXo is after, ignore updating.");
                            }
                            return updatedEvents;
                        }
                    }
                    if (ExoStorageService.LOG.isDebugEnabled()) {
                        if (isNew) {
                            ExoStorageService.LOG.debug((Object)("CREATE user calendar event: " + appointment.getSubject()));
                        } else {
                            ExoStorageService.LOG.debug((Object)("UPDATE user calendar event: " + appointment.getSubject()));
                        }
                    }
                    CalendarConverterUtils.convertExchangeToExoEvent(event, appointment, username, this.storage, this.organizationService.getUserHandler());
                    event.setRepeatType(CalendarEvent.RP_NOREPEAT);
                    CalendarCreateUpdateAction.MODIFIED_DATE.set(this.getLastModifiedDate(appointment).getTime());
                    try {
                        this.storage.saveUserEvent(username, calendar.getId(), event, isNew);
                    }
                    finally {
                        CalendarCreateUpdateAction.MODIFIED_DATE.set(null);
                    }
                    this.correspondenceService.setCorrespondingId(username, event.getId(), appointment.getId().getUniqueId());
                    break;
                }
                case 2: {
                    throw new IllegalStateException("The appointment is an exception occurence of this event >> '" + appointment.getSubject() + "'. start:" + appointment.getStart() + ", end : " + appointment.getEnd() + ", occurence: " + appointment.getAppointmentSequenceNumber());
                }
                case 3: {
                    masterEvent = null;
                    orginialStartDate = null;
                    if (isNew) {
                        masterEvent = new CalendarEvent();
                        masterEvent.setId(null);
                        updatedEvents.add(masterEvent);
                    } else {
                        masterEvent = this.getEventByAppointmentId(username, appointment.getId().getUniqueId());
                        updatedEvents.add(masterEvent);
                        orginialStartDate = masterEvent.getFromDateTime();
                    }
                    isLastOccurenceDeleted = false;
                    appointment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.Recurrence}));
                    if (appointment.getRecurrence().hasEnd()) {
                        recEndDate = appointment.getRecurrence().getEndDate();
                        appointment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(BasePropertySet.FirstClassProperties));
                        if (recEndDate == null) {
                            ExoStorageService.LOG.warn((Object)("Inconsistent data delivered by MS Exchange. The recurrent Event has end but end date is null: '" + appointment.getSubject() + "', start:" + appointment.getStart() + ", end : " + appointment.getEnd()));
                        } else {
                            tmpAppointment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.LastOccurrence}));
                            if (tmpAppointment.getLastOccurrence() == null) {
                                ExoStorageService.LOG.warn((Object)("Can't find last occurence of recurrent Event : '" + appointment.getSubject() + "', start:" + appointment.getStart() + ", end : " + appointment.getEnd()));
                            } else {
                                v0 = isLastOccurenceDeleted = tmpAppointment.getLastOccurrence().getEnd().getTime() < recEndDate.getTime();
                                if (isLastOccurenceDeleted && masterEvent.getExceptionIds() != null) {
                                    pattern = ExoStorageService.EXCLUDE_ID_FORMAT_FIRST_CHARS.format(recEndDate);
                                    for (i = 0; isLastOccurenceDeleted && i < masterEvent.getExceptionIds().size(); ++i) {
                                        isLastOccurenceDeleted = ((String)masterEvent.getExceptionIds().toArray()[i]).startsWith(pattern) == false;
                                    }
                                }
                            }
                        }
                    }
                    appointment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(BasePropertySet.FirstClassProperties));
                    if (!isLastOccurenceDeleted && !isNew && CalendarConverterUtils.verifyModifiedDatesConflict(masterEvent, appointment)) {
                        if (ExoStorageService.LOG.isTraceEnabled()) {
                            ExoStorageService.LOG.trace((Object)"Attempting to update eXo Event with Exchange Event, but modification date of eXo is after, ignore updating.");
                        }
                        return updatedEvents;
                    }
                    if (ExoStorageService.LOG.isTraceEnabled()) {
                        if (isNew) {
                            ExoStorageService.LOG.debug((Object)("CREATE recurrent user calendar event: " + appointment.getSubject()));
                        } else {
                            ExoStorageService.LOG.debug((Object)("UPDATE recurrent user calendar event: " + appointment.getSubject()));
                        }
                    }
                    masterEvent.setCalendarId(calendar.getId());
                    CalendarConverterUtils.convertExchangeToExoMasterRecurringCalendarEvent(masterEvent, appointment, username, this.storage, this.organizationService.getUserHandler());
                    if (isNew) {
                        this.correspondenceService.setCorrespondingId(username, masterEvent.getId(), appointment.getId().getUniqueId());
                    } else if (!CalendarConverterUtils.isSameDate(orginialStartDate, masterEvent.getFromDateTime()) && masterEvent.getExceptionIds() == null) {
                        masterEvent.setExceptionIds(new ArrayList<E>());
                    }
                    CalendarCreateUpdateAction.MODIFIED_DATE.set(this.getLastModifiedDate(appointment).getTime());
                    try {
                        this.storage.saveUserEvent(username, calendar.getId(), masterEvent, isNew);
                    }
                    finally {
                        CalendarCreateUpdateAction.MODIFIED_DATE.set(null);
                    }
                    exceptionalEventsToUpdate = new ArrayList<CalendarEvent>();
                    occAppointments = new ArrayList<Appointment>();
                    toDeleteEvents = CalendarConverterUtils.convertExchangeToExoOccurenceEvent(masterEvent, exceptionalEventsToUpdate, occAppointments, appointment, username, this.storage, this.organizationService.getUserHandler(), this.correspondenceService);
                    if (exceptionalEventsToUpdate == null || exceptionalEventsToUpdate.isEmpty()) ** GOTO lbl121
                    CalendarCreateUpdateAction.MODIFIED_DATE.set(this.getLastModifiedDate(appointment).getTime());
                    try {
                        this.storage.updateOccurrenceEvent(calendar.getId(), calendar.getId(), masterEvent.getCalType(), masterEvent.getCalType(), exceptionalEventsToUpdate, username);
                    }
                    finally {
                        CalendarCreateUpdateAction.MODIFIED_DATE.set(null);
                    }
                    eventsIterator = exceptionalEventsToUpdate.iterator();
                    occAppointmentIdIterator = occAppointments.iterator();
                    while (eventsIterator.hasNext()) {
                        calendarEvent = (CalendarEvent)eventsIterator.next();
                        occAppointment = (Appointment)occAppointmentIdIterator.next();
                        this.correspondenceService.setCorrespondingId(username, calendarEvent.getId(), occAppointment.getId().getUniqueId());
                        this.updateModifiedDateOfEvent(username, calendarEvent, this.getLastModifiedDate(occAppointment));
                    }
                    updatedEvents.addAll(exceptionalEventsToUpdate);
lbl121:
                    // 2 sources

                    if (toDeleteEvents == null || toDeleteEvents.isEmpty()) break;
                    for (CalendarEvent calendarEvent : toDeleteEvents) {
                        this.deleteEvent(username, calendarEvent);
                    }
                    break;
                }
                case 4: {
                    ExoStorageService.LOG.warn((Object)("The appointment is an occurence of this event >> '" + appointment.getSubject() + "'. start:" + appointment.getStart() + ", end : " + appointment.getEnd() + ", occurence: " + appointment.getAppointmentSequenceNumber()));
                }
            }
        }
        return updatedEvents;
    }

    private Date getLastModifiedDate(Appointment appointment) throws Exception {
        try {
            return appointment.getLastModifiedTime();
        }
        catch (ServiceObjectPropertyException e) {
            Appointment appointmentWithModifiedDate = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.LastModifiedTime}));
            return appointmentWithModifiedDate.getLastModifiedTime();
        }
    }
}

