/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.response;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.misc.id.AlternateId;
import microsoft.exchange.webservices.data.misc.id.AlternateIdBase;
import microsoft.exchange.webservices.data.misc.id.AlternatePublicFolderId;
import microsoft.exchange.webservices.data.misc.id.AlternatePublicFolderItemId;

public final class ConvertIdResponse
extends ServiceResponse {
    private AlternateIdBase convertedId;

    protected void readElementsFromXml(EwsServiceXmlReader reader) throws InstantiationException, IllegalAccessException, ServiceLocalException, Exception {
        super.readElementsFromXml(reader);
        reader.readStartElement(XmlNamespace.Messages, "AlternateId");
        String alternateIdClass = reader.readAttributeValue(XmlNamespace.XmlSchemaInstance, "type");
        int aliasSeparatorIndex = alternateIdClass.indexOf(58);
        if (aliasSeparatorIndex > -1) {
            alternateIdClass = alternateIdClass.substring(aliasSeparatorIndex + 1);
        }
        if (alternateIdClass.equals("AlternateIdType")) {
            this.convertedId = new AlternateId();
        } else if (alternateIdClass.equals("AlternatePublicFolderIdType")) {
            this.convertedId = new AlternatePublicFolderId();
        } else if (alternateIdClass.equals("AlternatePublicFolderItemIdType")) {
            this.convertedId = new AlternatePublicFolderItemId();
        } else {
            EwsUtilities.ewsAssert(false, "ConvertIdResponse.ReadElementsFromXml", String.format("Unknown alternate Id class: %s", alternateIdClass));
        }
        this.convertedId.loadAttributesFromXml(reader);
        reader.readEndElement(XmlNamespace.Messages, "AlternateId");
    }

    public AlternateIdBase getConvertedId() {
        return this.convertedId;
    }
}

