/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.service.ICreateServiceObjectWithAttachmentParam;
import microsoft.exchange.webservices.data.core.service.ICreateServiceObjectWithServiceParam;
import microsoft.exchange.webservices.data.core.service.folder.CalendarFolder;
import microsoft.exchange.webservices.data.core.service.folder.ContactsFolder;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.folder.SearchFolder;
import microsoft.exchange.webservices.data.core.service.folder.TasksFolder;
import microsoft.exchange.webservices.data.core.service.item.Appointment;
import microsoft.exchange.webservices.data.core.service.item.Contact;
import microsoft.exchange.webservices.data.core.service.item.ContactGroup;
import microsoft.exchange.webservices.data.core.service.item.Conversation;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.item.MeetingCancellation;
import microsoft.exchange.webservices.data.core.service.item.MeetingMessage;
import microsoft.exchange.webservices.data.core.service.item.MeetingRequest;
import microsoft.exchange.webservices.data.core.service.item.MeetingResponse;
import microsoft.exchange.webservices.data.core.service.item.PostItem;
import microsoft.exchange.webservices.data.core.service.item.Task;
import microsoft.exchange.webservices.data.property.complex.ItemAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceObjectInfo {
    private Map<Class<?>, ICreateServiceObjectWithAttachmentParam> serviceObjectConstructorsWithAttachmentParam;
    private Map<Class<?>, ICreateServiceObjectWithServiceParam> serviceObjectConstructorsWithServiceParam;
    private Map<String, Class<?>> xmlElementNameToServiceObjectClassMap;
    private List<ICreateServiceObjectWithAttachmentParam> onChangeList = new ArrayList<ICreateServiceObjectWithAttachmentParam>();
    private List<ICreateServiceObjectWithServiceParam> onChangeList1 = new ArrayList<ICreateServiceObjectWithServiceParam>();

    public ServiceObjectInfo() {
        this.xmlElementNameToServiceObjectClassMap = new HashMap();
        this.serviceObjectConstructorsWithServiceParam = new HashMap();
        this.serviceObjectConstructorsWithAttachmentParam = new HashMap();
        this.initializeServiceObjectClassMap();
    }

    private void initializeServiceObjectClassMap() {
        this.addServiceObjectType("CalendarItem", Appointment.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new Appointment(srv);
            }
        }, new ICreateServiceObjectWithAttachmentParam(){

            public Object createServiceObjectWithAttachmentParam(ItemAttachment itemAttachment, boolean isNew) throws Exception {
                return new Appointment(itemAttachment, isNew);
            }
        });
        this.addServiceObjectType("CalendarFolder", CalendarFolder.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new CalendarFolder(srv);
            }
        }, null);
        this.addServiceObjectType("Contact", Contact.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new Contact(srv);
            }
        }, new ICreateServiceObjectWithAttachmentParam(){

            public Object createServiceObjectWithAttachmentParam(ItemAttachment itemAttachment, boolean isNew) throws Exception {
                return new Contact(itemAttachment);
            }
        });
        this.addServiceObjectType("ContactsFolder", ContactsFolder.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new ContactsFolder(srv);
            }
        }, null);
        this.addServiceObjectType("DistributionList", ContactGroup.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new ContactGroup(srv);
            }
        }, new ICreateServiceObjectWithAttachmentParam(){

            public Object createServiceObjectWithAttachmentParam(ItemAttachment itemAttachment, boolean isNew) throws Exception {
                return new ContactGroup(itemAttachment);
            }
        });
        this.addServiceObjectType("Conversation", Conversation.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new Conversation(srv);
            }
        }, null);
        this.addServiceObjectType("Message", EmailMessage.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new EmailMessage(srv);
            }
        }, new ICreateServiceObjectWithAttachmentParam(){

            public Object createServiceObjectWithAttachmentParam(ItemAttachment itemAttachment, boolean isNew) throws Exception {
                return new EmailMessage(itemAttachment);
            }
        });
        this.addServiceObjectType("Folder", Folder.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new Folder(srv);
            }
        }, null);
        this.addServiceObjectType("Item", Item.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new Item(srv);
            }
        }, new ICreateServiceObjectWithAttachmentParam(){

            public Object createServiceObjectWithAttachmentParam(ItemAttachment itemAttachment, boolean isNew) throws Exception {
                return new Item(itemAttachment);
            }
        });
        this.addServiceObjectType("MeetingCancellation", MeetingCancellation.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new MeetingCancellation(srv);
            }
        }, new ICreateServiceObjectWithAttachmentParam(){

            public Object createServiceObjectWithAttachmentParam(ItemAttachment itemAttachment, boolean isNew) throws Exception {
                return new MeetingCancellation(itemAttachment);
            }
        });
        this.addServiceObjectType("MeetingMessage", MeetingMessage.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new MeetingMessage(srv);
            }
        }, new ICreateServiceObjectWithAttachmentParam(){

            public Object createServiceObjectWithAttachmentParam(ItemAttachment itemAttachment, boolean isNew) throws Exception {
                return new MeetingMessage(itemAttachment);
            }
        });
        this.addServiceObjectType("MeetingRequest", MeetingRequest.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new MeetingRequest(srv);
            }
        }, new ICreateServiceObjectWithAttachmentParam(){

            public Object createServiceObjectWithAttachmentParam(ItemAttachment itemAttachment, boolean isNew) throws Exception {
                return new MeetingRequest(itemAttachment);
            }
        });
        this.addServiceObjectType("MeetingResponse", MeetingResponse.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new MeetingResponse(srv);
            }
        }, new ICreateServiceObjectWithAttachmentParam(){

            public Object createServiceObjectWithAttachmentParam(ItemAttachment itemAttachment, boolean isNew) throws Exception {
                return new MeetingResponse(itemAttachment);
            }
        });
        this.addServiceObjectType("PostItem", PostItem.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new PostItem(srv);
            }
        }, new ICreateServiceObjectWithAttachmentParam(){

            public Object createServiceObjectWithAttachmentParam(ItemAttachment itemAttachment, boolean isNew) throws Exception {
                return new PostItem(itemAttachment);
            }
        });
        this.addServiceObjectType("SearchFolder", SearchFolder.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new SearchFolder(srv);
            }
        }, null);
        this.addServiceObjectType("Task", Task.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new Task(srv);
            }
        }, new ICreateServiceObjectWithAttachmentParam(){

            public Object createServiceObjectWithAttachmentParam(ItemAttachment itemAttachment, boolean isNew) throws Exception {
                return new Task(itemAttachment);
            }
        });
        this.addServiceObjectType("TasksFolder", TasksFolder.class, new ICreateServiceObjectWithServiceParam(){

            public Object createServiceObjectWithServiceParam(ExchangeService srv) throws Exception {
                return new TasksFolder(srv);
            }
        }, null);
    }

    private void addServiceObjectType(String xmlElementName, Class<?> cls, ICreateServiceObjectWithServiceParam createServiceObjectWithServiceParam, ICreateServiceObjectWithAttachmentParam createServiceObjectWithAttachmentParam) {
        this.xmlElementNameToServiceObjectClassMap.put(xmlElementName, cls);
        this.serviceObjectConstructorsWithServiceParam.put(cls, createServiceObjectWithServiceParam);
        if (createServiceObjectWithAttachmentParam != null) {
            this.serviceObjectConstructorsWithAttachmentParam.put(cls, createServiceObjectWithAttachmentParam);
        }
    }

    public Map<String, Class<?>> getXmlElementNameToServiceObjectClassMap() {
        return this.xmlElementNameToServiceObjectClassMap;
    }

    public Map<Class<?>, ICreateServiceObjectWithServiceParam> getServiceObjectConstructorsWithServiceParam() {
        return this.serviceObjectConstructorsWithServiceParam;
    }

    public Map<Class<?>, ICreateServiceObjectWithAttachmentParam> getServiceObjectConstructorsWithAttachmentParam() {
        return this.serviceObjectConstructorsWithAttachmentParam;
    }

    protected void addOnChangeEvent(ICreateServiceObjectWithAttachmentParam change) {
        this.onChangeList.add(change);
    }

    protected void removeChangeEvent(ICreateServiceObjectWithAttachmentParam change) {
        this.onChangeList.remove(change);
    }

    protected void addOnChangeEvent(ICreateServiceObjectWithServiceParam change) {
        this.onChangeList1.add(change);
    }

    protected void removeChangeEvent(ICreateServiceObjectWithServiceParam change) {
        this.onChangeList1.remove(change);
    }
}

