/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.item;

import java.util.Date;
import microsoft.exchange.webservices.data.attribute.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.LegacyFreeBusyStatus;
import microsoft.exchange.webservices.data.core.enumeration.property.MeetingResponseType;
import microsoft.exchange.webservices.data.core.enumeration.service.MeetingRequestType;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AppointmentType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.item.Appointment;
import microsoft.exchange.webservices.data.core.service.item.ICalendarActionProvider;
import microsoft.exchange.webservices.data.core.service.item.MeetingMessage;
import microsoft.exchange.webservices.data.core.service.response.AcceptMeetingInvitationMessage;
import microsoft.exchange.webservices.data.core.service.response.DeclineMeetingInvitationMessage;
import microsoft.exchange.webservices.data.core.service.schema.AppointmentSchema;
import microsoft.exchange.webservices.data.core.service.schema.MeetingRequestSchema;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.misc.CalendarActionResults;
import microsoft.exchange.webservices.data.misc.TimeSpan;
import microsoft.exchange.webservices.data.property.complex.AttendeeCollection;
import microsoft.exchange.webservices.data.property.complex.DeletedOccurrenceInfoCollection;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.ItemAttachment;
import microsoft.exchange.webservices.data.property.complex.ItemCollection;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.OccurrenceInfo;
import microsoft.exchange.webservices.data.property.complex.OccurrenceInfoCollection;
import microsoft.exchange.webservices.data.property.complex.recurrence.pattern.Recurrence;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceObjectDefinition(xmlElementName="MeetingRequest")
public class MeetingRequest
extends MeetingMessage
implements ICalendarActionProvider {
    private static final Log LOG = LogFactory.getLog(MeetingRequest.class);

    public MeetingRequest(ItemAttachment parentAttachment) throws Exception {
        super(parentAttachment);
    }

    public MeetingRequest(ExchangeService service) throws Exception {
        super(service);
    }

    public static MeetingRequest bind(ExchangeService service, ItemId id, PropertySet propertySet) {
        try {
            return service.bindToItem(MeetingRequest.class, id, propertySet);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static MeetingRequest bind(ExchangeService service, ItemId id) {
        return MeetingRequest.bind(service, id, PropertySet.getFirstClassProperties());
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return MeetingRequestSchema.Instance;
    }

    @Override
    public ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    @Override
    public AcceptMeetingInvitationMessage createAcceptMessage(boolean tentative) {
        try {
            return new AcceptMeetingInvitationMessage(this, tentative);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Override
    public DeclineMeetingInvitationMessage createDeclineMessage() {
        try {
            return new DeclineMeetingInvitationMessage(this);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Override
    public CalendarActionResults accept(boolean sendResponse) throws Exception {
        return this.internalAccept(false, sendResponse);
    }

    @Override
    public CalendarActionResults acceptTentatively(boolean sendResponse) throws Exception {
        return this.internalAccept(true, sendResponse);
    }

    protected CalendarActionResults internalAccept(boolean tentative, boolean sendResponse) throws Exception {
        AcceptMeetingInvitationMessage accept = this.createAcceptMessage(tentative);
        if (sendResponse) {
            return accept.calendarSendAndSaveCopy();
        }
        return accept.calendarSave();
    }

    @Override
    public CalendarActionResults decline(boolean sendResponse) throws Exception {
        DeclineMeetingInvitationMessage decline = this.createDeclineMessage();
        if (sendResponse) {
            return decline.calendarSendAndSaveCopy();
        }
        return decline.calendarSave();
    }

    public MeetingRequestType getMeetingRequestType() throws ServiceLocalException {
        return (MeetingRequestType)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(MeetingRequestSchema.MeetingRequestType));
    }

    public LegacyFreeBusyStatus getIntendedFreeBusyStatus() throws ServiceLocalException {
        return (LegacyFreeBusyStatus)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(MeetingRequestSchema.IntendedFreeBusyStatus));
    }

    public Date getStart() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Start);
    }

    public Date getEnd() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.End);
    }

    public Date getOriginalStart() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.OriginalStart);
    }

    public boolean getIsAllDayEvent() throws ServiceLocalException {
        return this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.IsAllDayEvent) != null;
    }

    public LegacyFreeBusyStatus legacyFreeBusyStatus() throws ServiceLocalException {
        return (LegacyFreeBusyStatus)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.LegacyFreeBusyStatus));
    }

    public String getLocation() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Location);
    }

    public String getWhen() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.When);
    }

    public boolean getIsMeeting() throws ServiceLocalException {
        return this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.IsMeeting) != null;
    }

    public boolean getIsCancelled() throws ServiceLocalException {
        return this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.IsCancelled) != null;
    }

    public boolean getIsRecurring() throws ServiceLocalException {
        return this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.IsRecurring) != null;
    }

    public boolean getMeetingRequestWasSent() throws ServiceLocalException {
        return this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.MeetingRequestWasSent) != null;
    }

    public AppointmentType getAppointmentType() throws ServiceLocalException {
        return (AppointmentType)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AppointmentType));
    }

    public MeetingResponseType getMyResponseType() throws ServiceLocalException {
        return (MeetingResponseType)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.MyResponseType));
    }

    public EmailAddress getOrganizer() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Organizer);
    }

    public AttendeeCollection getRequiredAttendees() throws ServiceLocalException {
        return (AttendeeCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.RequiredAttendees);
    }

    public AttendeeCollection getOptionalAttendees() throws ServiceLocalException {
        return (AttendeeCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.OptionalAttendees);
    }

    public AttendeeCollection getResources() throws ServiceLocalException {
        return (AttendeeCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Resources);
    }

    public int getConflictingMeetingCount() throws NumberFormatException, ServiceLocalException {
        return Integer.parseInt(this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.ConflictingMeetingCount).toString());
    }

    public int getAdjacentMeetingCount() throws NumberFormatException, ServiceLocalException {
        return Integer.parseInt(this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AdjacentMeetingCount).toString());
    }

    public ItemCollection<Appointment> getConflictingMeetings() throws ServiceLocalException {
        return (ItemCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.ConflictingMeetings);
    }

    public ItemCollection<Appointment> getAdjacentMeetings() throws ServiceLocalException {
        return (ItemCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AdjacentMeetings);
    }

    public TimeSpan getDuration() throws ServiceLocalException {
        return (TimeSpan)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Duration);
    }

    public String getTimeZone() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.TimeZone);
    }

    public Date getAppointmentReplyTime() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AppointmentReplyTime);
    }

    public int getAppointmentSequenceNumber() throws NumberFormatException, ServiceLocalException {
        return Integer.parseInt(this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AppointmentSequenceNumber).toString());
    }

    public int getAppointmentState() throws NumberFormatException, ServiceLocalException {
        return Integer.parseInt(this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AppointmentState).toString());
    }

    public Recurrence getRecurrence() throws ServiceLocalException {
        return (Recurrence)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.Recurrence);
    }

    public OccurrenceInfo getFirstOccurrence() throws ServiceLocalException {
        return (OccurrenceInfo)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.FirstOccurrence);
    }

    public OccurrenceInfo getLastOccurrence() throws ServiceLocalException {
        return (OccurrenceInfo)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.FirstOccurrence);
    }

    public OccurrenceInfoCollection getModifiedOccurrences() throws ServiceLocalException {
        return (OccurrenceInfoCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.ModifiedOccurrences);
    }

    public DeletedOccurrenceInfoCollection getDeletedOccurrences() throws ServiceLocalException {
        return (DeletedOccurrenceInfoCollection)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.DeletedOccurrences);
    }

    public TimeZoneDefinition getStartTimeZone() throws ServiceLocalException {
        return (TimeZoneDefinition)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.StartTimeZone);
    }

    public TimeZoneDefinition getEndTimeZone() throws ServiceLocalException {
        return (TimeZoneDefinition)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.EndTimeZone);
    }

    public int getConferenceType() throws NumberFormatException, ServiceLocalException {
        return Integer.parseInt(this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.ConferenceType).toString());
    }

    public boolean getAllowNewTimeProposal() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.AllowNewTimeProposal);
    }

    public boolean getIsOnlineMeeting() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.IsOnlineMeeting);
    }

    public String getMeetingWorkspaceUrl() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.MeetingWorkspaceUrl);
    }

    public String getNetShowUrl() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(AppointmentSchema.NetShowUrl);
    }
}

