/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.property.complex.ServiceId;

public final class FolderId
extends ServiceId {
    private WellKnownFolderName folderName;
    private Mailbox mailbox;

    public FolderId() {
    }

    public FolderId(String uniqueId) throws Exception {
        super(uniqueId);
    }

    public FolderId(WellKnownFolderName folderName) {
        this.folderName = folderName;
    }

    public FolderId(WellKnownFolderName folderName, Mailbox mailbox) {
        this(folderName);
        this.mailbox = mailbox;
    }

    public String getXmlElementName() {
        if (this.getFolderName() != null) {
            return "DistinguishedFolderId";
        }
        return "FolderId";
    }

    public void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        if (this.getFolderName() != null) {
            writer.writeAttributeValue("Id", this.getFolderName().toString().toLowerCase());
            if (this.mailbox != null) {
                try {
                    this.mailbox.writeToXml(writer, "Mailbox");
                }
                catch (Exception e) {
                    throw new ServiceXmlSerializationException(e.getMessage());
                }
            }
        } else {
            super.writeAttributesToXml(writer);
        }
    }

    public void validate(ExchangeVersion version) throws ServiceVersionException {
        if (this.getFolderName() != null) {
            EwsUtilities.validateEnumVersionValue(this.getFolderName(), version);
        }
    }

    public WellKnownFolderName getFolderName() {
        return this.folderName;
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public static FolderId getFolderIdFromString(String uniqueId) throws Exception {
        return new FolderId(uniqueId);
    }

    public static FolderId getFolderIdFromWellKnownFolderName(WellKnownFolderName folderName) {
        return new FolderId(folderName);
    }

    protected boolean getIsValid() {
        if (this.folderName != null) {
            return this.mailbox == null || this.mailbox.isValid();
        }
        return super.isValid();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FolderId) {
            FolderId other = (FolderId)obj;
            if (this.folderName != null) {
                if (other.folderName != null && this.folderName.equals((Object)other.folderName)) {
                    if (this.mailbox != null) {
                        return this.mailbox.equals(other.mailbox);
                    }
                    if (other.mailbox == null) {
                        return true;
                    }
                }
            } else if (super.equals(other)) {
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int hashCode;
        if (this.folderName != null) {
            hashCode = this.folderName.hashCode();
            if (this.mailbox != null && this.mailbox.isValid()) {
                hashCode ^= this.mailbox.hashCode();
            }
        } else {
            hashCode = super.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        if (this.isValid()) {
            if (this.folderName != null) {
                if (this.mailbox != null && this.mailbox.isValid()) {
                    return String.format("%s,(%s)", new Object[]{this.folderName, this.mailbox.toString()});
                }
                return this.folderName.toString();
            }
            return super.toString();
        }
        return "";
    }
}

