/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.PropertyBag;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.ResponseActions;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseObjectsPropertyDefinition
extends PropertyDefinition {
    public ResponseObjectsPropertyDefinition(String xmlElementName, String uri, ExchangeVersion version) {
        super(xmlElementName, uri, version);
    }

    @Override
    public final void loadPropertyValueFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        EnumSet<ResponseActions> value = EnumSet.noneOf(ResponseActions.class);
        value.add(ResponseActions.None);
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, this.getXmlElement());
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (!reader.isStartElement()) continue;
                if (reader.getLocalName().equals("AcceptItem")) {
                    value.add(ResponseActions.Accept);
                    continue;
                }
                if (reader.getLocalName().equals("TentativelyAcceptItem")) {
                    value.add(ResponseActions.TentativelyAccept);
                    continue;
                }
                if (reader.getLocalName().equals("DeclineItem")) {
                    value.add(ResponseActions.Decline);
                    continue;
                }
                if (reader.getLocalName().equals("ReplyToItem")) {
                    value.add(ResponseActions.Reply);
                    continue;
                }
                if (reader.getLocalName().equals("ForwardItem")) {
                    value.add(ResponseActions.Forward);
                    continue;
                }
                if (reader.getLocalName().equals("ReplyAllToItem")) {
                    value.add(ResponseActions.ReplyAll);
                    continue;
                }
                if (reader.getLocalName().equals("CancelCalendarItem")) {
                    value.add(ResponseActions.Cancel);
                    continue;
                }
                if (reader.getLocalName().equals("RemoveItem")) {
                    value.add(ResponseActions.RemoveFromCalendar);
                    continue;
                }
                if (reader.getLocalName().equals("SuppressReadReceipt")) {
                    value.add(ResponseActions.SuppressReadReceipt);
                    continue;
                }
                if (!reader.getLocalName().equals("PostReplyItem")) continue;
                value.add(ResponseActions.PostReply);
            } while (!reader.isEndElement(XmlNamespace.Types, this.getXmlElement()));
        } else {
            reader.read();
        }
        propertyBag.setObjectFromPropertyDefinition(this, value);
    }

    @Override
    public void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) {
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    public Class<ResponseActions> getType() {
        return ResponseActions.class;
    }
}

