/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.search;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.search.OffsetBasePoint;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.ServiceRequestBase;
import microsoft.exchange.webservices.data.search.Grouping;
import microsoft.exchange.webservices.data.search.ViewBase;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class PagedView
extends ViewBase {
    private int pageSize;
    private OffsetBasePoint offsetBasePoint = OffsetBasePoint.Beginning;
    private int offset;

    protected void internalWriteViewToXml(EwsServiceXmlWriter writer) throws Exception {
        super.internalWriteViewToXml(writer);
        writer.writeAttributeValue("Offset", this.getOffset());
        writer.writeAttributeValue("BasePoint", (Object)this.getOffsetBasePoint());
    }

    protected Integer getMaxEntriesReturned() {
        return this.getPageSize();
    }

    protected void internalWriteSearchSettingsToXml(EwsServiceXmlWriter writer, Grouping groupBy) throws XMLStreamException, ServiceXmlSerializationException {
        if (groupBy != null) {
            groupBy.writeToXml(writer);
        }
    }

    public void writeOrderByToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
    }

    public void internalValidate(ServiceRequestBase request) throws ServiceVersionException, ServiceValidationException {
        super.internalValidate(request);
    }

    protected PagedView(int pageSize) {
        this.setPageSize(pageSize);
    }

    protected PagedView(int pageSize, int offset) {
        this(pageSize);
        this.setOffset(offset);
    }

    protected PagedView(int pageSize, int offset, OffsetBasePoint offsetBasePoint) {
        this(pageSize, offset);
        this.setOffsetBasePoint(offsetBasePoint);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("The value must be greater than 0.");
        }
        this.pageSize = pageSize;
    }

    public OffsetBasePoint getOffsetBasePoint() {
        return this.offsetBasePoint;
    }

    public void setOffsetBasePoint(OffsetBasePoint offsetBasePoint) {
        this.offsetBasePoint = offsetBasePoint;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("The offset must be greater than 0.");
        }
        this.offset = offset;
    }
}

