/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.util;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateTimeUtils {
    private static final DateTimeFormatter[] DATE_TIME_FORMATS = DateTimeUtils.createDateTimeFormats();
    private static final DateTimeFormatter[] DATE_FORMATS = DateTimeUtils.createDateFormats();

    private DateTimeUtils() {
        throw new UnsupportedOperationException();
    }

    public static Date convertDateTimeStringToDate(String value) {
        return DateTimeUtils.parseInternal(value, false);
    }

    public static Date convertDateStringToDate(String value) {
        return DateTimeUtils.parseInternal(value, true);
    }

    private static Date parseInternal(String value, boolean dateOnly) {
        DateTimeFormatter[] formats;
        String originalValue = value;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        if (value.endsWith("z")) {
            value = value.substring(0, value.length() - 1) + "Z";
        }
        for (DateTimeFormatter format : formats = dateOnly ? DATE_FORMATS : DATE_TIME_FORMATS) {
            try {
                return format.parseDateTime(value).toDate();
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        try {
            return new DateTime((Object)value).toDate();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(String.format("Date String %s not in valid UTC/local format", originalValue));
        }
    }

    private static DateTimeFormatter[] createDateTimeFormats() {
        return new DateTimeFormatter[]{DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ").withZone(DateTimeZone.UTC), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZone(DateTimeZone.UTC), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSSSSSZ").withZone(DateTimeZone.UTC), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss").withZone(DateTimeZone.UTC), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS").withZone(DateTimeZone.UTC), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSSSSS").withZone(DateTimeZone.UTC), DateTimeFormat.forPattern((String)"yyyy-MM-ddZ").withZone(DateTimeZone.UTC), DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZone(DateTimeZone.UTC)};
    }

    private static DateTimeFormatter[] createDateFormats() {
        return new DateTimeFormatter[]{DateTimeFormat.forPattern((String)"yyyy-MM-ddZ").withZone(DateTimeZone.UTC), DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZone(DateTimeZone.UTC)};
    }
}

