/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.task;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.notification.EventType;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.service.folder.CalendarFolder;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import microsoft.exchange.webservices.data.notification.FolderEvent;
import microsoft.exchange.webservices.data.notification.GetEventsResults;
import microsoft.exchange.webservices.data.notification.ItemEvent;
import microsoft.exchange.webservices.data.notification.PullSubscription;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.extension.exchange.service.CorrespondenceService;
import org.exoplatform.extension.exchange.service.ExchangeDataStorageService;
import org.exoplatform.extension.exchange.service.ExoDataStorageService;
import org.exoplatform.extension.exchange.task.UserIntegrationFacade;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class ExchangeIntegrationTask
extends Thread {
    private static final Log LOG = ExoLogger.getLogger(ExchangeIntegrationTask.class);
    private ExchangeService service;
    private PullSubscription subscription = null;
    private UserIntegrationFacade integrationService;
    private List<FolderId> calendarFolderIds = new ArrayList<FolderId>();
    private String username;
    private ConversationState state;
    private boolean firstSynchronization;
    private boolean firstSynchronizationRunning;
    private Date firstSynchronizationStartDate;
    private boolean synchronizeAllExchangeFolders;
    private boolean deleteExoCalendarOnUnsync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeIntegrationTask(CalendarService calendarService, ExoDataStorageService exoStorageService, ExchangeDataStorageService exchangeStorageService, CorrespondenceService correspondenceService, Identity identity, String exchangeUsername, String exchangePassword, String exchangeDomain, String exchangeServerURL, boolean synchronizeAllExchangeFolders, boolean deleteExoCalendarOnUnsync, int maxFirstSynchronizationDays) throws Exception {
        this.username = identity.getUserId();
        this.firstSynchronization = true;
        this.synchronizeAllExchangeFolders = synchronizeAllExchangeFolders;
        this.deleteExoCalendarOnUnsync = deleteExoCalendarOnUnsync;
        this.service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
        this.service.setTimeout(300000);
        WebCredentials credentials = null;
        credentials = exchangeDomain != null ? new WebCredentials(exchangeUsername, exchangePassword, exchangeDomain) : new WebCredentials(exchangeUsername, exchangePassword);
        this.service.setCredentials((ExchangeCredentials)credentials);
        this.service.setUrl(new URI(exchangeServerURL));
        try {
            this.service.getInboxRules();
        }
        catch (Exception e) {
            boolean authenticated;
            block16: {
                authenticated = false;
                if (exchangeDomain != null) {
                    credentials = new WebCredentials(exchangeUsername, exchangePassword);
                    try {
                        this.service.setCredentials((ExchangeCredentials)credentials);
                        this.service.setUrl(new URI(exchangeServerURL));
                        this.service.getInboxRules();
                        authenticated = true;
                    }
                    catch (Exception exp) {
                        if (exchangeUsername.contains("@")) break block16;
                        credentials = new WebCredentials(exchangeUsername + "@" + exchangeDomain, exchangePassword);
                        try {
                            this.service.setCredentials((ExchangeCredentials)credentials);
                            this.service.setUrl(new URI(exchangeServerURL));
                            this.service.getInboxRules();
                            authenticated = true;
                        }
                        catch (Exception exp2) {
                            authenticated = false;
                        }
                    }
                }
            }
            if (!authenticated && (exchangeDomain == null || exchangeDomain.isEmpty()) && exchangeUsername.contains("@")) {
                String[] parts = exchangeUsername.split("@");
                exchangeUsername = parts[0];
                exchangeDomain = parts[1];
                credentials = new WebCredentials(exchangeUsername, exchangePassword, exchangeDomain);
                this.service.setCredentials((ExchangeCredentials)credentials);
                this.service.setUrl(new URI(exchangeServerURL));
                this.service.getInboxRules();
            }
            throw e;
        }
        this.integrationService = new UserIntegrationFacade(calendarService, exoStorageService, exchangeStorageService, correspondenceService, this.service, this.username, maxFirstSynchronizationDays);
        this.state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)this.state);
        if (synchronizeAllExchangeFolders) {
            this.calendarFolderIds = exchangeStorageService.getAllExchangeCalendars(this.service);
        } else {
            CalendarFolder folder = this.integrationService.getExchangeCalendar(FolderId.getFolderIdFromWellKnownFolderName((WellKnownFolderName)WellKnownFolderName.Calendar));
            if (folder != null) {
                if (!this.waitOtherTasks()) {
                    return;
                }
                try {
                    this.calendarFolderIds = this.integrationService.getSynchronizedExchangeCalendars();
                }
                finally {
                    this.integrationService.setSynchronizationStopped();
                }
            } else {
                throw new IllegalStateException("Error while authenticating user '" + this.username + "' to exchange, please make sure you are connected to the correct URL with correct credentials.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.waitOtherTasks()) {
            return;
        }
        boolean firstSynchronizationIteration = false;
        try {
            ConversationState.setCurrent((ConversationState)this.state);
            long newLastTimeCheck = System.currentTimeMillis();
            List<String> updatedExoEventIDs = this.integrationService.synchronizeExchangeFolderState(this.calendarFolderIds, this.synchronizeAllExchangeFolders, this.deleteExoCalendarOnUnsync);
            if (this.calendarFolderIds.isEmpty()) {
                return;
            }
            if (updatedExoEventIDs == null) {
                updatedExoEventIDs = new ArrayList<String>();
            }
            Date exoLastSyncDate = this.integrationService.getUserExoLastCheckDate();
            if (this.firstSynchronization) {
                this.firstSynchronization = false;
                firstSynchronizationIteration = true;
                this.firstSynchronizationRunning = true;
                this.firstSynchronizationStartDate = java.util.Calendar.getInstance().getTime();
                this.integrationService.setSynchronizationStopped();
            } else if (exoLastSyncDate == null && this.firstSynchronizationRunning) {
                exoLastSyncDate = this.firstSynchronizationStartDate;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("run scheduled synchronization for user: " + this.username));
            }
            GetEventsResults events = this.getEvents();
            if (this.synchronizeAllExchangeFolders) {
                this.synchronizeExchangeFolders(events, updatedExoEventIDs);
            }
            this.synchronizeExchangeApointments(events, updatedExoEventIDs);
            this.synchronizeByModificationDate(firstSynchronizationIteration ? null : exoLastSyncDate, updatedExoEventIDs);
            this.integrationService.setUserExoLastCheckDate(newLastTimeCheck);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Synchronization completed.");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while synchronizing calendar entries.", (Throwable)e);
        }
        finally {
            if (firstSynchronizationIteration) {
                this.firstSynchronizationRunning = false;
            }
            this.integrationService.setSynchronizationStopped();
        }
    }

    @Override
    public void interrupt() {
        if (this.subscription != null) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Thread interruption: unsubscribe user service:" + this.username));
                }
                this.subscription.unsubscribe();
            }
            catch (Exception e) {
                LOG.error((Object)("Thread interruption: Error while unsubscribe to thread of user:" + this.username));
            }
        }
        if (this.service != null) {
            try {
                this.service.close();
            }
            catch (Exception e) {
                LOG.error((Object)("Thread interruption: Error while closing ExchangeService for user:" + this.username), (Throwable)e);
            }
        }
        try {
            this.integrationService.removeInstance();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error while inerrupting thread", e);
        }
        super.interrupt();
    }

    private GetEventsResults getEvents() throws Exception {
        GetEventsResults events = null;
        if (this.subscription == null) {
            this.newSubscription();
        }
        try {
            events = this.subscription.getEvents();
        }
        catch (Exception e) {
            LOG.warn((Object)("Subscription seems timed out, retry. Original cause: " + e.getMessage() + ""));
            this.newSubscription();
            events = this.subscription.getEvents();
        }
        return events;
    }

    private boolean waitOtherTasks() {
        int i;
        for (i = 0; !this.integrationService.setSynchronizationStarted() && i < 5; ++i) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Exchange integration is in use, scheduled job will wait until synchronization is finished for user:'" + this.username + "'."));
            }
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage());
            }
        }
        return i < 5;
    }

    private void synchronizeByModificationDate(Date exoLastSyncDate, List<String> updatedExoEventIDs) throws Exception {
        for (FolderId folderId : this.calendarFolderIds) {
            Calendar calendar = this.integrationService.getUserCalendarByExchangeFolderId(folderId);
            if (calendar == null || exoLastSyncDate == null) {
                this.integrationService.synchronizeFullCalendar(folderId);
                continue;
            }
            this.integrationService.synchronizeModificationsOfCalendar(folderId, exoLastSyncDate, updatedExoEventIDs);
        }
    }

    private long synchronizeExchangeApointments(GetEventsResults events, List<String> updatedExoEventIDs) throws Exception {
        Iterable itemEvents = events.getItemEvents();
        long lastTimeCheck = System.currentTimeMillis();
        if (itemEvents.iterator().hasNext()) {
            ArrayList<String> itemIds = new ArrayList<String>();
            for (ItemEvent itemEvent : itemEvents) {
                if (itemIds.contains(itemEvent.getItemId().getUniqueId())) continue;
                itemIds.add(itemEvent.getItemId().getUniqueId());
                List<CalendarEvent> updatedEvents = this.integrationService.createOrUpdateOrDelete(itemEvent);
                if (updatedEvents == null || updatedEvents.isEmpty() || updatedExoEventIDs == null) continue;
                for (CalendarEvent calendarEvent : updatedEvents) {
                    updatedExoEventIDs.add(calendarEvent.getId());
                }
            }
        }
        return lastTimeCheck;
    }

    private void synchronizeExchangeFolders(GetEventsResults events, List<String> updatedExoEventIDs) throws Exception {
        if (events.getFolderEvents() != null && events.getFolderEvents().iterator().hasNext()) {
            for (FolderEvent folderEvent : events.getFolderEvents()) {
                if (folderEvent.getEventType().equals((Object)EventType.Created) || folderEvent.getEventType().equals((Object)EventType.Modified)) {
                    if (this.integrationService.isCalendarPresentInExo(folderEvent.getFolderId())) continue;
                    List<String> updatedEventIDs = this.integrationService.synchronizeFullCalendar(folderEvent.getFolderId());
                    updatedExoEventIDs.addAll(updatedEventIDs);
                    if (updatedEventIDs.isEmpty() || this.calendarFolderIds.contains(folderEvent.getFolderId())) continue;
                    this.calendarFolderIds.add(folderEvent.getFolderId());
                    continue;
                }
                if (folderEvent.getEventType().equals((Object)EventType.Deleted)) {
                    boolean deleted = this.integrationService.deleteExoCalendar(folderEvent.getFolderId());
                    if (!deleted || !this.calendarFolderIds.contains(folderEvent.getFolderId())) continue;
                    this.calendarFolderIds.remove(folderEvent.getFolderId());
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Folder Event wasn't catched: " + folderEvent.getEventType().name() + "on folder: " + folderEvent.getFolderId().getUniqueId()));
            }
        }
    }

    private void newSubscription() throws Exception {
        String waterMark;
        block4: {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("New Subscription for user: " + this.username));
            }
            waterMark = null;
            if (this.subscription != null) {
                try {
                    waterMark = this.subscription.getWaterMark();
                    this.subscription.unsubscribe();
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled() && !LOG.isTraceEnabled()) break block4;
                    LOG.warn((Object)"Error while unsubscribe, will renew it anyway.");
                }
            }
        }
        this.subscription = this.integrationService.getService().subscribeToPullNotifications(this.calendarFolderIds, 5, waterMark, new EventType[]{EventType.Modified, EventType.Created, EventType.Deleted});
    }
}

