/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.autodiscover.AutodiscoverService;
import microsoft.exchange.webservices.data.autodiscover.enumeration.AutodiscoverErrorCode;
import microsoft.exchange.webservices.data.autodiscover.exception.AutodiscoverResponseException;
import microsoft.exchange.webservices.data.autodiscover.response.AutodiscoverResponse;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.ExchangeServerInfo;
import microsoft.exchange.webservices.data.core.enumeration.misc.TraceFlags;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.http.EWSHttpException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRemoteException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRequestException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.misc.SoapFaultDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AutodiscoverRequest {
    private static final Log LOG = LogFactory.getLog(AutodiscoverRequest.class);
    private AutodiscoverService service;
    private URI url;

    protected AutodiscoverRequest(AutodiscoverService service, URI url) {
        this.service = service;
        this.url = url;
    }

    public static boolean isRedirectionResponse(HttpWebRequest request) throws EWSHttpException {
        return request.getResponseCode() == 301 || request.getResponseCode() == 302 || request.getResponseCode() == 307 || request.getResponseCode() == 303;
    }

    protected void validate() throws Exception {
        this.getService().validate();
    }

    /*
     * Unable to fully structure code
     */
    protected AutodiscoverResponse internalExecute() throws Exception {
        block30: {
            block29: {
                this.validate();
                request = null;
                request = this.service.prepareHttpWebRequestForUrl(this.url);
                this.service.traceHttpRequestHeaders(TraceFlags.AutodiscoverRequestHttpHeaders, request);
                needSignature = this.getService().getCredentials() != null && this.getService().getCredentials().isNeedSignature() != false;
                needTrace = this.getService().isTraceEnabledFor(TraceFlags.AutodiscoverRequest);
                urlOutStream = request.getOutputStream();
                memoryStream = new ByteArrayOutputStream();
                writer = new EwsServiceXmlWriter(this.getService(), memoryStream);
                writer.setRequireWSSecurityUtilityNamespace(needSignature);
                this.writeSoapRequest(this.url, writer);
                if (needSignature) {
                    this.service.getCredentials().sign(memoryStream);
                }
                if (needTrace) {
                    memoryStream.flush();
                    this.service.traceXml(TraceFlags.AutodiscoverRequest, memoryStream);
                }
                memoryStream.writeTo(urlOutStream);
                urlOutStream.flush();
                urlOutStream.close();
                memoryStream.close();
                request.executeRequest();
                request.getResponseCode();
                if (!AutodiscoverRequest.isRedirectionResponse(request)) ** GOTO lbl40
                response = this.createRedirectionResponse(request);
                if (response == null) break block29;
                var8_14 = response;
                try {
                    if (request != null) {
                        request.close();
                    }
                }
                catch (Exception var9_17) {
                    // empty catch block
                }
                return var8_14;
            }
            throw new ServiceRemoteException("The service returned an invalid redirection response.");
lbl40:
            // 1 sources

            memoryStream = new ByteArrayOutputStream();
            serviceResponseStream = request.getInputStream();
            while (-1 != (data = serviceResponseStream.read())) {
                memoryStream.write(data);
            }
            memoryStream.flush();
            serviceResponseStream.close();
            if (this.service.isTraceEnabled()) {
                this.service.traceResponse(request, memoryStream);
            }
            memoryStreamIn = new ByteArrayInputStream(memoryStream.toByteArray());
            ewsXmlReader = new EwsXmlReader(memoryStreamIn);
            ewsXmlReader.read();
            if (ewsXmlReader.getNodeType().getNodeType() == 7) {
                ewsXmlReader.readStartElement(XmlNamespace.Soap, "Envelope");
            } else if (ewsXmlReader.getNodeType().getNodeType() != 1 || !ewsXmlReader.getLocalName().equals("Envelope") || !ewsXmlReader.getNamespaceUri().equals(EwsUtilities.getNamespaceUri(XmlNamespace.Soap))) {
                throw new ServiceXmlDeserializationException("The Autodiscover service response was invalid.");
            }
            this.readSoapHeaders(ewsXmlReader);
            response = this.readSoapBody(ewsXmlReader);
            ewsXmlReader.readEndElement(XmlNamespace.Soap, "Envelope");
            if (response.getErrorCode() != AutodiscoverErrorCode.NoError) break block30;
            var11_20 = response;
            try {
                if (request != null) {
                    request.close();
                }
            }
            catch (Exception var12_21) {
                // empty catch block
            }
            return var11_20;
        }
        try {
            try {
                throw new AutodiscoverResponseException(response.getErrorCode(), response.getErrorMessage());
            }
            catch (XMLStreamException ex) {
                this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("XML parsing error: %s", new Object[]{ex.getMessage()}));
                throw new ServiceRequestException(String.format("The request failed. %s", new Object[]{ex.getMessage()}), ex);
            }
            catch (IOException ex) {
                this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("I/O error: %s", new Object[]{ex.getMessage()}));
                throw new ServiceRequestException(String.format("The request failed. %s", new Object[]{ex.getMessage()}), ex);
            }
            catch (Exception ex) {
                block31: {
                    if (null == request || request.getResponseCode() != 7) ** GOTO lbl90
                    if (!AutodiscoverRequest.isRedirectionResponse(request)) ** GOTO lbl89
                    this.service.processHttpResponseHeaders(TraceFlags.AutodiscoverResponseHttpHeaders, request);
                    response = this.createRedirectionResponse(request);
                    if (response != null) {
                        var4_8 = response;
                        return var4_8;
                    }
                    break block31;
lbl89:
                    // 1 sources

                    this.processWebException(ex, request);
                }
                throw new ServiceRequestException(String.format("The request failed. %s", new Object[]{ex.getMessage()}), ex);
            }
        }
        finally {
            try {
                if (request != null) {
                    request.close();
                }
            }
            catch (Exception var5_10) {}
        }
    }

    private void processWebException(Exception exception, HttpWebRequest req) {
        if (null != req) {
            try {
                if (500 == req.getResponseCode()) {
                    if (this.service.isTraceEnabledFor(TraceFlags.AutodiscoverRequest)) {
                        int data;
                        ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
                        InputStream serviceResponseStream = AutodiscoverRequest.getResponseStream(req);
                        while (-1 != (data = serviceResponseStream.read())) {
                            memoryStream.write(data);
                        }
                        memoryStream.flush();
                        serviceResponseStream.close();
                        this.service.traceResponse(req, memoryStream);
                        ByteArrayInputStream memoryStreamIn = new ByteArrayInputStream(memoryStream.toByteArray());
                        EwsXmlReader reader = new EwsXmlReader(memoryStreamIn);
                        this.readSoapFault(reader);
                        memoryStream.close();
                    } else {
                        InputStream serviceResponseStream = AutodiscoverRequest.getResponseStream(req);
                        EwsXmlReader reader = new EwsXmlReader(serviceResponseStream);
                        SoapFaultDetails soapFaultDetails = this.readSoapFault(reader);
                        serviceResponseStream.close();
                        if (soapFaultDetails != null) {
                            throw new ServiceResponseException(new ServiceResponse(soapFaultDetails));
                        }
                    }
                } else {
                    this.service.processHttpErrorResponse(req, exception);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    private AutodiscoverResponse createRedirectionResponse(HttpWebRequest httpWebResponse) throws XMLStreamException, IOException, EWSHttpException {
        String location = httpWebResponse.getResponseHeaderField("Location");
        if (location != null && !location.isEmpty()) {
            try {
                URI redirectionUri = new URI(location);
                String scheme = redirectionUri.getScheme();
                if (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https")) {
                    AutodiscoverResponse response = this.createServiceResponse();
                    response.setErrorCode(AutodiscoverErrorCode.RedirectUrl);
                    response.setRedirectionUrl(redirectionUri);
                    return response;
                }
                this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Invalid redirection URL '%s' returned by Autodiscover service.", redirectionUri.toString()));
            }
            catch (URISyntaxException ex) {
                this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Invalid redirection location '%s' returned by Autodiscover service.", location));
            }
        } else {
            this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, "Redirection response returned by Autodiscover service without redirection location.");
        }
        return null;
    }

    private SoapFaultDetails readSoapFault(EwsXmlReader reader) {
        SoapFaultDetails soapFaultDetails = null;
        try {
            reader.read();
            if (reader.getNodeType().getNodeType() == 7) {
                reader.read();
            }
            if (!reader.isStartElement() || !reader.getLocalName().equals("Envelope")) {
                return null;
            }
            XmlNamespace soapNamespace = EwsUtilities.getNamespaceFromUri(reader.getNamespaceUri());
            if (soapNamespace == XmlNamespace.NotSpecified) {
                return null;
            }
            reader.read();
            if (reader.isStartElement(soapNamespace, "Header")) {
                do {
                    reader.read();
                } while (!reader.isEndElement(soapNamespace, "Header"));
                reader.read();
            }
            if (reader.isStartElement(soapNamespace, "Body")) {
                do {
                    reader.read();
                    if (!reader.isStartElement(soapNamespace, "Fault")) continue;
                    soapFaultDetails = SoapFaultDetails.parse(reader, soapNamespace);
                } while (!reader.isEndElement(soapNamespace, "Body"));
            }
            reader.readEndElement(soapNamespace, "Envelope");
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return soapFaultDetails;
    }

    protected void writeSoapRequest(URI requestUrl, EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        if (writer.isRequireWSSecurityUtilityNamespace()) {
            writer.writeAttributeValue("xmlns", "wsu", (Object)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        }
        writer.writeStartDocument();
        writer.writeStartElement(XmlNamespace.Soap, "Envelope");
        writer.writeAttributeValue("xmlns", EwsUtilities.getNamespacePrefix(XmlNamespace.Soap), (Object)EwsUtilities.getNamespaceUri(XmlNamespace.Soap));
        writer.writeAttributeValue("xmlns", "a", (Object)"http://schemas.microsoft.com/exchange/2010/Autodiscover");
        writer.writeAttributeValue("xmlns", "wsa", (Object)"http://www.w3.org/2005/08/addressing");
        writer.writeAttributeValue("xmlns", "xsi", (Object)"http://www.w3.org/2001/XMLSchema-instance");
        writer.writeStartElement(XmlNamespace.Soap, "Header");
        if (this.service.getCredentials() != null) {
            this.service.getCredentials().emitExtraSoapHeaderNamespaceAliases(writer.getInternalWriter());
        }
        writer.writeElementValue(XmlNamespace.Autodiscover, "RequestedServerVersion", this.service.getRequestedServerVersion().toString());
        writer.writeElementValue(XmlNamespace.WSAddressing, "Action", this.getWsAddressingActionName());
        writer.writeElementValue(XmlNamespace.WSAddressing, "To", requestUrl.toString());
        this.writeExtraCustomSoapHeadersToXml(writer);
        if (this.service.getCredentials() != null) {
            this.service.getCredentials().serializeWSSecurityHeaders(writer.getInternalWriter());
        }
        this.service.doOnSerializeCustomSoapHeaders(writer.getInternalWriter());
        writer.writeEndElement();
        writer.writeStartElement(XmlNamespace.Soap, "Body");
        this.writeBodyToXml(writer);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.flush();
        writer.dispose();
    }

    protected void writeExtraCustomSoapHeadersToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
    }

    protected void writeBodyToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        writer.writeStartElement(XmlNamespace.Autodiscover, this.getRequestXmlElementName());
        this.writeAttributesToXml(writer);
        this.writeElementsToXml(writer);
        writer.writeEndElement();
    }

    protected static InputStream getResponseStream(HttpWebRequest request) throws EWSHttpException, IOException {
        String contentEncoding = "";
        if (null != request.getContentEncoding()) {
            contentEncoding = request.getContentEncoding().toLowerCase();
        }
        InputStream responseStream = contentEncoding.contains("gzip") ? new GZIPInputStream(request.getInputStream()) : (contentEncoding.contains("deflate") ? new InflaterInputStream(request.getInputStream()) : request.getInputStream());
        return responseStream;
    }

    protected void readSoapHeaders(EwsXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Soap, "Header");
        do {
            reader.read();
            this.readSoapHeader(reader);
        } while (!reader.isEndElement(XmlNamespace.Soap, "Header"));
    }

    protected void readSoapHeader(EwsXmlReader reader) throws Exception {
        if (reader.isStartElement(XmlNamespace.Autodiscover, "ServerVersionInfo")) {
            this.service.setServerInfo(this.readServerVersionInfo(reader));
        }
    }

    private ExchangeServerInfo readServerVersionInfo(EwsXmlReader reader) throws Exception {
        ExchangeServerInfo serverInfo = new ExchangeServerInfo();
        do {
            reader.read();
            if (!reader.isStartElement()) continue;
            if (reader.getLocalName().equals("MajorVersion")) {
                serverInfo.setMajorVersion(reader.readElementValue(Integer.class));
                continue;
            }
            if (reader.getLocalName().equals("MinorVersion")) {
                serverInfo.setMinorVersion(reader.readElementValue(Integer.class));
                continue;
            }
            if (reader.getLocalName().equals("MajorBuildNumber")) {
                serverInfo.setMajorBuildNumber(reader.readElementValue(Integer.class));
                continue;
            }
            if (reader.getLocalName().equals("MinorBuildNumber")) {
                serverInfo.setMinorBuildNumber(reader.readElementValue(Integer.class));
                continue;
            }
            if (!reader.getLocalName().equals("Version")) continue;
            serverInfo.setVersionString(reader.readElementValue());
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, "ServerVersionInfo"));
        return serverInfo;
    }

    protected AutodiscoverResponse readSoapBody(EwsXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Soap, "Body");
        AutodiscoverResponse responses = this.loadFromXml(reader);
        reader.readEndElement(XmlNamespace.Soap, "Body");
        return responses;
    }

    protected AutodiscoverResponse loadFromXml(EwsXmlReader reader) throws Exception {
        String elementName = this.getResponseXmlElementName();
        reader.readStartElement(XmlNamespace.Autodiscover, elementName);
        AutodiscoverResponse response = this.createServiceResponse();
        response.loadFromXml(reader, elementName);
        return response;
    }

    protected abstract String getRequestXmlElementName();

    protected abstract String getResponseXmlElementName();

    protected abstract String getWsAddressingActionName();

    protected abstract AutodiscoverResponse createServiceResponse();

    protected abstract void writeAttributesToXml(EwsServiceXmlWriter var1) throws ServiceXmlSerializationException;

    protected abstract void writeElementsToXml(EwsServiceXmlWriter var1) throws XMLStreamException, ServiceXmlSerializationException;

    protected AutodiscoverService getService() {
        return this.service;
    }

    protected URI getUrl() {
        return this.url;
    }
}

