/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import microsoft.exchange.webservices.data.ISelfValidate;
import microsoft.exchange.webservices.data.attribute.EwsEnum;
import microsoft.exchange.webservices.data.attribute.RequiredServerVersion;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.IAction;
import microsoft.exchange.webservices.data.core.ILazyMember;
import microsoft.exchange.webservices.data.core.IPredicate;
import microsoft.exchange.webservices.data.core.LazyMember;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.notification.EventType;
import microsoft.exchange.webservices.data.core.enumeration.property.MailboxType;
import microsoft.exchange.webservices.data.core.enumeration.property.RuleProperty;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.ItemTraversal;
import microsoft.exchange.webservices.data.core.enumeration.service.FileAsMapping;
import microsoft.exchange.webservices.data.core.enumeration.service.MeetingRequestsDeliveryScope;
import microsoft.exchange.webservices.data.core.exception.http.EWSHttpException;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentNullException;
import microsoft.exchange.webservices.data.core.exception.misc.FormatException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.core.service.ICreateServiceObjectWithAttachmentParam;
import microsoft.exchange.webservices.data.core.service.ICreateServiceObjectWithServiceParam;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.core.service.ServiceObjectInfo;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.misc.TimeSpan;
import microsoft.exchange.webservices.data.property.complex.ItemAttachment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Period;
import org.joda.time.format.ISOPeriodFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EwsUtilities {
    private static final Log LOG = LogFactory.getLog(EwsUtilities.class);
    public static final String XSFalse = "false";
    public static final String XSTrue = "true";
    public static final String EwsTypesNamespacePrefix = "t";
    public static final String EwsMessagesNamespacePrefix = "m";
    public static final String EwsErrorsNamespacePrefix = "e";
    public static final String EwsSoapNamespacePrefix = "soap";
    public static final String EwsXmlSchemaInstanceNamespacePrefix = "xsi";
    public static final String PassportSoapFaultNamespacePrefix = "psf";
    public static final String WSTrustFebruary2005NamespacePrefix = "wst";
    public static final String WSAddressingNamespacePrefix = "wsa";
    public static final String AutodiscoverSoapNamespacePrefix = "a";
    public static final String WSSecurityUtilityNamespacePrefix = "wsu";
    public static final String WSSecuritySecExtNamespacePrefix = "wsse";
    public static final String EwsTypesNamespace = "http://schemas.microsoft.com/exchange/services/2006/types";
    public static final String EwsMessagesNamespace = "http://schemas.microsoft.com/exchange/services/2006/messages";
    public static final String EwsErrorsNamespace = "http://schemas.microsoft.com/exchange/services/2006/errors";
    public static final String EwsSoapNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String EwsSoap12Namespace = "http://www.w3.org/2003/05/soap-envelope";
    public static final String EwsXmlSchemaInstanceNamespace = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String PassportSoapFaultNamespace = "http://schemas.microsoft.com/Passport/SoapServices/SOAPFault";
    public static final String WSTrustFebruary2005Namespace = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    public static final String WSAddressingNamespace = "http://www.w3.org/2005/08/addressing";
    public static final String AutodiscoverSoapNamespace = "http://schemas.microsoft.com/exchange/2010/Autodiscover";
    public static final String WSSecurityUtilityNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static final String WSSecuritySecExtNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final LazyMember<ServiceObjectInfo> SERVICE_OBJECT_INFO = new LazyMember<ServiceObjectInfo>(new ILazyMember<ServiceObjectInfo>(){

        @Override
        public ServiceObjectInfo createInstance() {
            return new ServiceObjectInfo();
        }
    });
    private static final String XML_SCHEMA_DATE_FORMAT = "yyyy-MM-dd'Z'";
    private static final String XML_SCHEMA_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final Pattern PATTERN_TIME_SPAN = Pattern.compile("-P");
    private static final Pattern PATTERN_YEAR = Pattern.compile("(\\d+)Y");
    private static final Pattern PATTERN_MONTH = Pattern.compile("(\\d+)M");
    private static final Pattern PATTERN_DAY = Pattern.compile("(\\d+)D");
    private static final Pattern PATTERN_HOUR = Pattern.compile("(\\d+)H");
    private static final Pattern PATTERN_MINUTES = Pattern.compile("(\\d+)M");
    private static final Pattern PATTERN_SECONDS = Pattern.compile("(\\d+)\\.");
    private static final Pattern PATTERN_MILLISECONDS = Pattern.compile("(\\d+)S");
    private static final LazyMember<Map<Class<?>, Map<String, ExchangeVersion>>> ENUM_VERSION_DICTIONARIES = new LazyMember(new ILazyMember<Map<Class<?>, Map<String, ExchangeVersion>>>(){

        @Override
        public Map<Class<?>, Map<String, ExchangeVersion>> createInstance() {
            HashMap enumDicts = new HashMap();
            enumDicts.put(WellKnownFolderName.class, EwsUtilities.buildEnumDict(WellKnownFolderName.class));
            enumDicts.put(ItemTraversal.class, EwsUtilities.buildEnumDict(ItemTraversal.class));
            enumDicts.put(FileAsMapping.class, EwsUtilities.buildEnumDict(FileAsMapping.class));
            enumDicts.put(EventType.class, EwsUtilities.buildEnumDict(EventType.class));
            enumDicts.put(MeetingRequestsDeliveryScope.class, EwsUtilities.buildEnumDict(MeetingRequestsDeliveryScope.class));
            return enumDicts;
        }
    });
    private static final LazyMember<Map<Class<?>, Map<String, String>>> SCHEMA_TO_ENUM_DICTIONARIES = new LazyMember(new ILazyMember<Map<Class<?>, Map<String, String>>>(){

        @Override
        public Map<Class<?>, Map<String, String>> createInstance() {
            HashMap enumDicts = new HashMap();
            enumDicts.put(EventType.class, EwsUtilities.buildSchemaToEnumDict(EventType.class));
            enumDicts.put(MailboxType.class, EwsUtilities.buildSchemaToEnumDict(MailboxType.class));
            enumDicts.put(FileAsMapping.class, EwsUtilities.buildSchemaToEnumDict(FileAsMapping.class));
            enumDicts.put(RuleProperty.class, EwsUtilities.buildSchemaToEnumDict(RuleProperty.class));
            return enumDicts;
        }
    });
    public static final LazyMember<Map<Class<?>, Map<String, String>>> ENUM_TO_SCHEMA_DICTIONARIES = new LazyMember(new ILazyMember<Map<Class<?>, Map<String, String>>>(){

        @Override
        public Map<Class<?>, Map<String, String>> createInstance() {
            HashMap enumDicts = new HashMap();
            enumDicts.put(EventType.class, EwsUtilities.buildEnumToSchemaDict(EventType.class));
            enumDicts.put(MailboxType.class, EwsUtilities.buildEnumToSchemaDict(MailboxType.class));
            enumDicts.put(FileAsMapping.class, EwsUtilities.buildEnumToSchemaDict(FileAsMapping.class));
            enumDicts.put(RuleProperty.class, EwsUtilities.buildEnumToSchemaDict(RuleProperty.class));
            return enumDicts;
        }
    });
    public static final String DomainRegex = "^[-a-zA-Z0-9_.]+$";

    private EwsUtilities() {
        throw new UnsupportedOperationException();
    }

    public static String getBuildVersion() {
        return "0.0.0.0";
    }

    public static void ewsAssert(boolean condition, String caller, String message) {
        if (!condition) {
            throw new RuntimeException(String.format("[%s] %s", caller, message));
        }
    }

    public static String getNamespacePrefix(XmlNamespace xmlNamespace) {
        return xmlNamespace.getNameSpacePrefix();
    }

    public static String getNamespaceUri(XmlNamespace xmlNamespace) {
        return xmlNamespace.getNameSpaceUri();
    }

    public static XmlNamespace getNamespaceFromUri(String namespaceUri) {
        if (EwsErrorsNamespace.equals(namespaceUri)) {
            return XmlNamespace.Errors;
        }
        if (EwsTypesNamespace.equals(namespaceUri)) {
            return XmlNamespace.Types;
        }
        if (EwsMessagesNamespace.equals(namespaceUri)) {
            return XmlNamespace.Messages;
        }
        if (EwsSoapNamespace.equals(namespaceUri)) {
            return XmlNamespace.Soap;
        }
        if (EwsSoap12Namespace.equals(namespaceUri)) {
            return XmlNamespace.Soap12;
        }
        if (EwsXmlSchemaInstanceNamespace.equals(namespaceUri)) {
            return XmlNamespace.XmlSchemaInstance;
        }
        if (PassportSoapFaultNamespace.equals(namespaceUri)) {
            return XmlNamespace.PassportSoapFault;
        }
        if (WSTrustFebruary2005Namespace.equals(namespaceUri)) {
            return XmlNamespace.WSTrustFebruary2005;
        }
        if (WSAddressingNamespace.equals(namespaceUri)) {
            return XmlNamespace.WSAddressing;
        }
        return XmlNamespace.NotSpecified;
    }

    public static <TServiceObject extends ServiceObject> TServiceObject createEwsObjectFromXmlElementName(Class<?> itemClass, ExchangeService service, String xmlElementName) throws Exception {
        ServiceObjectInfo member = SERVICE_OBJECT_INFO.getMember();
        Map<String, Class<?>> map = member.getXmlElementNameToServiceObjectClassMap();
        Class<?> ic = map.get(xmlElementName);
        if (ic != null) {
            Map<Class<?>, ICreateServiceObjectWithServiceParam> serviceParam = member.getServiceObjectConstructorsWithServiceParam();
            ICreateServiceObjectWithServiceParam creationDelegate = serviceParam.get(ic);
            if (creationDelegate != null) {
                return (TServiceObject)((ServiceObject)creationDelegate.createServiceObjectWithServiceParam(service));
            }
            throw new IllegalArgumentException("No appropriate constructor could be found for this item class.");
        }
        return (TServiceObject)((ServiceObject)itemClass.newInstance());
    }

    public static Item createItemFromItemClass(ItemAttachment itemAttachment, Class<?> itemClass, boolean isNew) throws Exception {
        ServiceObjectInfo member = SERVICE_OBJECT_INFO.getMember();
        Map<Class<?>, ICreateServiceObjectWithAttachmentParam> dataMap = member.getServiceObjectConstructorsWithAttachmentParam();
        ICreateServiceObjectWithAttachmentParam creationDelegate = dataMap.get(itemClass);
        if (creationDelegate != null) {
            return (Item)creationDelegate.createServiceObjectWithAttachmentParam(itemAttachment, isNew);
        }
        throw new IllegalArgumentException("No appropriate constructor could be found for this item class.");
    }

    public static Item createItemFromXmlElementName(ItemAttachment itemAttachment, String xmlElementName) throws Exception {
        ServiceObjectInfo member = SERVICE_OBJECT_INFO.getMember();
        Map<String, Class<?>> map = member.getXmlElementNameToServiceObjectClassMap();
        Class<?> itemClass = map.get(xmlElementName);
        if (itemClass != null) {
            return EwsUtilities.createItemFromItemClass(itemAttachment, itemClass, false);
        }
        return null;
    }

    public static Class<?> getItemTypeFromXmlElementName(String xmlElementName) {
        ServiceObjectInfo member = SERVICE_OBJECT_INFO.getMember();
        Map<String, Class<?>> map = member.getXmlElementNameToServiceObjectClassMap();
        return map.get(xmlElementName);
    }

    public static <TItem extends Item> TItem findFirstItemOfType(Class<TItem> cls, Iterable<Item> items) {
        for (Item item : items) {
            Class<?> itemClass = item.getClass();
            if (!itemClass.equals(cls)) continue;
            return (TItem)item;
        }
        return null;
    }

    private static void writeTraceStartElement(XMLStreamWriter writer, String traceTag, boolean includeVersion) throws XMLStreamException {
        writer.writeStartElement("Trace");
        writer.writeAttribute("Tag", traceTag);
        writer.writeAttribute("Tid", Thread.currentThread().getId() + "");
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String formattedString = df.format(d);
        writer.writeAttribute("Time", formattedString);
        if (includeVersion) {
            writer.writeAttribute("Version", EwsUtilities.getBuildVersion());
        }
    }

    public static String formatLogMessage(String entryKind, String logEntry) throws XMLStreamException, IOException {
        String lineSeparator = System.getProperty("line.separator");
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(outStream);
        EwsUtilities.writeTraceStartElement(writer, entryKind, false);
        writer.writeCharacters(lineSeparator);
        writer.writeCharacters(logEntry);
        writer.writeCharacters(lineSeparator);
        writer.writeEndElement();
        writer.writeCharacters(lineSeparator);
        writer.flush();
        writer.close();
        outStream.flush();
        String formattedLogMessage = outStream.toString();
        formattedLogMessage = formattedLogMessage.replaceAll("&apos;", "'");
        formattedLogMessage = formattedLogMessage.replaceAll("&quot;", "\"");
        formattedLogMessage = formattedLogMessage.replaceAll("&gt;", ">");
        formattedLogMessage = formattedLogMessage.replaceAll("&lt;", "<");
        formattedLogMessage = formattedLogMessage.replaceAll("&amp;", "&");
        outStream.close();
        return formattedLogMessage;
    }

    public static String formatHttpResponseHeaders(HttpWebRequest response) throws EWSHttpException {
        int code = response.getResponseCode();
        String contentType = response.getResponseContentType();
        Map<String, String> headers = response.getResponseHeaders();
        return code + " " + contentType + "\n" + EwsUtilities.formatHttpHeaders(headers) + "\n";
    }

    public static String formatHttpRequestHeaders(HttpWebRequest request) throws URISyntaxException, EWSHttpException {
        String method = request.getRequestMethod().toUpperCase();
        String path = request.getUrl().toURI().getPath();
        Map<String, String> property = request.getRequestProperty();
        String headers = EwsUtilities.formatHttpHeaders(property);
        return String.format("%s %s HTTP/%s\n", method, path, "1.1") + headers + "\n";
    }

    private static String formatHttpHeaders(Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            sb.append(String.format("%s : %s\n", header.getKey(), header.getValue()));
        }
        return sb.toString();
    }

    public static String formatLogMessageWithXmlContent(String traceTypeStr, ByteArrayOutputStream stream) {
        try {
            return EwsUtilities.formatLogMessage(traceTypeStr, stream.toString());
        }
        catch (Exception e) {
            return stream.toString();
        }
    }

    public static String boolToXSBool(Boolean value) {
        return value != false ? XSTrue : XSFalse;
    }

    public static <T extends Enum<?>> void parseEnumValueList(Class<T> c, List<T> list, String value, char ... separators) {
        String[] enumValues;
        EwsUtilities.ewsAssert(c.isEnum(), "EwsUtilities.ParseEnumValueList", "T is not an enum type.");
        StringBuilder regexp = new StringBuilder();
        regexp.append("[");
        for (char s : separators) {
            regexp.append("[");
            regexp.append(Pattern.quote(s + ""));
            regexp.append("]");
        }
        regexp.append("]");
        for (String enumValue : enumValues = value.split(regexp.toString())) {
            for (Enum o : (Enum[])c.getEnumConstants()) {
                if (!o.toString().equals(enumValue)) continue;
                list.add(o);
            }
        }
    }

    public static String serializeEnum(Object value) {
        Enum e;
        String enumStr;
        String strValue = value.toString();
        Map<Class<?>, Map<String, String>> member = ENUM_TO_SCHEMA_DICTIONARIES.getMember();
        Map<String, String> enumToStringDict = member.get(value.getClass());
        if (enumToStringDict != null && (enumStr = enumToStringDict.get((e = (Enum)value).name())) != null) {
            strValue = enumStr;
        }
        return strValue;
    }

    public static <T> T parse(Class<T> cls, String value) throws ParseException {
        if (cls.isEnum()) {
            String strEnumName;
            Map<Class<?>, Map<String, String>> member = SCHEMA_TO_ENUM_DICTIONARIES.getMember();
            String val = value;
            Map<String, String> stringToEnumDict = member.get(cls);
            if (stringToEnumDict != null && (strEnumName = stringToEnumDict.get(value)) != null) {
                val = strEnumName;
            }
            for (T o : cls.getEnumConstants()) {
                if (!o.toString().equals(val)) continue;
                return o;
            }
            return null;
        }
        if (Number.class.isAssignableFrom(cls)) {
            if (Double.class.isAssignableFrom(cls)) {
                return (T)Double.valueOf(Double.parseDouble(value));
            }
            if (Integer.class.isAssignableFrom(cls)) {
                return (T)Integer.valueOf(Integer.parseInt(value));
            }
            if (Long.class.isAssignableFrom(cls)) {
                return (T)Long.valueOf(Long.parseLong(value));
            }
            if (Float.class.isAssignableFrom(cls)) {
                return (T)Float.valueOf(Float.parseFloat(value));
            }
            if (Byte.class.isAssignableFrom(cls)) {
                return (T)Byte.valueOf(Byte.parseByte(value));
            }
            if (Short.class.isAssignableFrom(cls)) {
                return (T)Short.valueOf(Short.parseShort(value));
            }
            if (BigInteger.class.isAssignableFrom(cls)) {
                return (T)new BigInteger(value);
            }
            if (BigDecimal.class.isAssignableFrom(cls)) {
                return (T)new BigDecimal(value);
            }
        } else {
            if (Date.class.isAssignableFrom(cls)) {
                DateFormat df = EwsUtilities.createDateFormat(XML_SCHEMA_DATE_TIME_FORMAT);
                return (T)df.parse(value);
            }
            if (Boolean.class.isAssignableFrom(cls)) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(value));
            }
            if (String.class.isAssignableFrom(cls)) {
                return (T)value;
            }
        }
        return null;
    }

    private static <E extends Enum<E>> Map<String, String> buildSchemaToEnumDict(Class<E> c) {
        Field[] fields;
        HashMap<String, String> dict = new HashMap<String, String>();
        for (Field f : fields = c.getDeclaredFields()) {
            if (!f.isEnumConstant() || !f.isAnnotationPresent(EwsEnum.class)) continue;
            EwsEnum ewsEnum = f.getAnnotation(EwsEnum.class);
            String fieldName = f.getName();
            String schemaName = ewsEnum.schemaName();
            if (schemaName.isEmpty()) continue;
            dict.put(schemaName, fieldName);
        }
        return dict;
    }

    public static void validateParamCollection(EventType[] eventTypes, String paramName) throws Exception {
        EwsUtilities.validateParam(eventTypes, paramName);
        int count = 0;
        for (EventType event : eventTypes) {
            try {
                EwsUtilities.validateParam((Object)event, String.format("collection[%d] , ", count));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("The element at position %d is invalid", count), e);
            }
            ++count;
        }
        if (count == 0) {
            throw new IllegalArgumentException(String.format("The collection \"%s\" is empty.", paramName));
        }
    }

    public static String dateTimeToXSDate(Date date) {
        return EwsUtilities.formatDate(date, XML_SCHEMA_DATE_FORMAT);
    }

    public static String dateTimeToXSDateTime(Date date) {
        return EwsUtilities.formatDate(date, XML_SCHEMA_DATE_TIME_FORMAT);
    }

    public static String getTimeSpanToXSDuration(TimeSpan timeOffset) {
        String offsetStr = timeOffset.getTotalSeconds() < 0.0 ? "-" : "";
        long days = Math.abs(timeOffset.getDays());
        long hours = Math.abs(timeOffset.getHours());
        long minutes = Math.abs(timeOffset.getMinutes());
        long seconds = Math.abs(timeOffset.getSeconds());
        long milliseconds = Math.abs(timeOffset.getMilliseconds());
        return offsetStr + "P" + days + "DT" + hours + "H" + minutes + "M" + seconds + "." + milliseconds + "S";
    }

    public static TimeSpan getXSDurationToTimeSpan(String xsDuration) {
        Matcher m = PATTERN_TIME_SPAN.matcher(xsDuration);
        boolean negative = false;
        if (m.find()) {
            negative = true;
        }
        if (negative) {
            xsDuration = xsDuration.replace("-P", "P");
        }
        Period period = ISOPeriodFormat.standard().parsePeriod(xsDuration);
        long retval = period.toStandardDuration().getMillis();
        if (negative) {
            retval = -retval;
        }
        return new TimeSpan(retval);
    }

    public static String timeSpanToXSTime(TimeSpan timeSpan) {
        DecimalFormat myFormatter = new DecimalFormat("00");
        return String.format("%s:%s:%s", myFormatter.format(timeSpan.getHours()), myFormatter.format(timeSpan.getMinutes()), myFormatter.format(timeSpan.getSeconds()));
    }

    public static String domainFromEmailAddress(String emailAddress) throws FormatException {
        String[] emailAddressParts = emailAddress.split("@");
        if (emailAddressParts.length != 2 || emailAddressParts[1] == null || emailAddressParts[1].isEmpty()) {
            throw new FormatException("The e-mail address is formed incorrectly.");
        }
        return emailAddressParts[1];
    }

    public static int getDim(Object array) {
        int dim = 0;
        Class<?> c = array.getClass();
        while (c.isArray()) {
            c = c.getComponentType();
            ++dim;
        }
        return dim;
    }

    public static void validateParamAllowNull(Object param, String paramName) throws Exception {
        ServiceObject ewsObject;
        if (param instanceof ISelfValidate) {
            ISelfValidate selfValidate = (ISelfValidate)param;
            try {
                selfValidate.validate();
            }
            catch (ServiceValidationException e) {
                throw new Exception(String.format("%s %s", "Validation failed.", paramName), e);
            }
        }
        if (param instanceof ServiceObject && (ewsObject = (ServiceObject)param).isNew()) {
            throw new Exception(String.format("%s %s", "This service object doesn't have an ID.", paramName));
        }
    }

    public static void validateParam(Object param, String paramName) throws Exception {
        boolean isValid;
        if (param instanceof String) {
            String strParam = (String)param;
            isValid = !strParam.isEmpty();
        } else {
            boolean bl = isValid = param != null;
        }
        if (!isValid) {
            throw new Exception(String.format("Argument %s not valid", paramName));
        }
        EwsUtilities.validateParamAllowNull(param, paramName);
    }

    public static <T> void validateParamCollection(Iterator<T> collection, String paramName) throws Exception {
        EwsUtilities.validateParam(collection, paramName);
        int count = 0;
        while (collection.hasNext()) {
            T obj = collection.next();
            try {
                EwsUtilities.validateParam(obj, String.format("collection[%d],", count));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("The element at position %d is invalid", count), e);
            }
            ++count;
        }
        if (count == 0) {
            throw new IllegalArgumentException(String.format("The collection \"%s\" is empty.", paramName));
        }
    }

    public static void validateNonBlankStringParamAllowNull(String param, String paramName) throws ArgumentException, ServiceLocalException {
        if (param != null && param.length() == EwsUtilities.countMatchingChars(param, new IPredicate<Character>(){

            @Override
            public boolean predicate(Character obj) {
                return Character.isWhitespace(obj.charValue());
            }
        })) {
            throw new ArgumentException("The string argument contains only white space characters.", paramName);
        }
    }

    public static void validateNonBlankStringParam(String param, String paramName) throws ArgumentNullException, ArgumentException, ServiceLocalException {
        if (param == null) {
            throw new ArgumentNullException(paramName);
        }
        EwsUtilities.validateNonBlankStringParamAllowNull(param, paramName);
    }

    public static void validateEnumVersionValue(Enum<?> enumValue, ExchangeVersion requestVersion) throws ServiceVersionException {
        int i;
        Map<Class<?>, Map<String, ExchangeVersion>> member = ENUM_VERSION_DICTIONARIES.getMember();
        Map<String, ExchangeVersion> enumVersionDict = member.get(enumValue.getClass());
        ExchangeVersion enumVersion = enumVersionDict.get(enumValue.toString());
        if (enumVersion != null && (i = requestVersion.compareTo(enumVersion)) < 0) {
            throw new ServiceVersionException(String.format("Enumeration value %s in enumeration type %s is only valid for Exchange version %s or later.", new Object[]{enumValue.toString(), enumValue.getClass().getName(), enumVersion}));
        }
    }

    public static void validateServiceObjectVersion(ServiceObject serviceObject, ExchangeVersion requestVersion) throws ServiceVersionException {
        ExchangeVersion minimumRequiredServerVersion = serviceObject.getMinimumRequiredServerVersion();
        if (requestVersion.ordinal() < minimumRequiredServerVersion.ordinal()) {
            String msg = String.format("The object type %s is only valid for Exchange Server version %s or later versions.", serviceObject.getClass().getName(), minimumRequiredServerVersion.toString());
            throw new ServiceVersionException(msg);
        }
    }

    public static void validatePropertyVersion(ExchangeService service, ExchangeVersion minimumServerVersion, String propertyName) throws ServiceVersionException {
        if (service.getRequestedServerVersion().ordinal() < minimumServerVersion.ordinal()) {
            throw new ServiceVersionException(String.format("The property %s is valid only for Exchange %s or later versions.", new Object[]{propertyName, minimumServerVersion}));
        }
    }

    public static void validateMethodVersion(ExchangeService service, ExchangeVersion minimumServerVersion, String methodName) throws ServiceVersionException {
        if (service.getRequestedServerVersion().ordinal() < minimumServerVersion.ordinal()) {
            throw new ServiceVersionException(String.format("Method %s is only valid for Exchange Server version %s or later.", new Object[]{methodName, minimumServerVersion}));
        }
    }

    public static void validateClassVersion(ExchangeService service, ExchangeVersion minimumServerVersion, String className) throws ServiceVersionException {
        if (service.getRequestedServerVersion().ordinal() < minimumServerVersion.ordinal()) {
            throw new ServiceVersionException(String.format("Class %s is only valid for Exchange version %s or later.", new Object[]{className, minimumServerVersion}));
        }
    }

    public static void validateDomainNameAllowNull(String domainName, String paramName) throws ArgumentException {
        Pattern domainNamePattern;
        Matcher domainNameMatcher;
        if (domainName != null && !(domainNameMatcher = (domainNamePattern = Pattern.compile(DomainRegex)).matcher(domainName)).find()) {
            throw new ArgumentException(String.format("'%s' is not a valid domain name.", domainName), paramName);
        }
    }

    private static <E extends Enum<E>> Map<String, ExchangeVersion> buildEnumDict(Class<E> c) {
        Field[] fields;
        HashMap<String, ExchangeVersion> dict = new HashMap<String, ExchangeVersion>();
        for (Field f : fields = c.getDeclaredFields()) {
            if (!f.isEnumConstant() || !f.isAnnotationPresent(RequiredServerVersion.class)) continue;
            RequiredServerVersion ewsEnum = f.getAnnotation(RequiredServerVersion.class);
            String fieldName = f.getName();
            ExchangeVersion exchangeVersion = ewsEnum.version();
            dict.put(fieldName, exchangeVersion);
        }
        return dict;
    }

    private static Map<String, String> buildEnumToSchemaDict(Class<?> c) {
        Field[] fields;
        HashMap<String, String> dict = new HashMap<String, String>();
        for (Field f : fields = c.getFields()) {
            if (!f.isEnumConstant() || !f.isAnnotationPresent(EwsEnum.class)) continue;
            EwsEnum ewsEnum = f.getAnnotation(EwsEnum.class);
            String fieldName = f.getName();
            String schemaName = ewsEnum.schemaName();
            if (schemaName.isEmpty()) continue;
            dict.put(fieldName, schemaName);
        }
        return dict;
    }

    public static <T> int getEnumeratedObjectCount(Iterator<T> objects) {
        int count = 0;
        while (objects != null && objects.hasNext()) {
            objects.next();
            ++count;
        }
        return count;
    }

    public static <T> Object getEnumeratedObjectAt(Iterable<T> objects, int index) {
        int count = 0;
        for (T obj : objects) {
            if (count == index) {
                return obj;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException("The IEnumerable doesn't contain that many objects.");
    }

    public static int countMatchingChars(String str, IPredicate<Character> charPredicate) throws ServiceLocalException {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (!charPredicate.predicate(Character.valueOf(str.charAt(i)))) continue;
            ++count;
        }
        return count;
    }

    public static <T> boolean trueForAll(Iterable<T> collection, IPredicate<T> predicate) throws ServiceLocalException {
        for (T entry : collection) {
            if (predicate.predicate(entry)) continue;
            return false;
        }
        return true;
    }

    public static <T> void forEach(Iterable<T> collection, IAction<T> action) {
        for (T entry : collection) {
            action.action(entry);
        }
    }

    private static String formatDate(Date date, String format) {
        DateFormat utcFormatter = EwsUtilities.createDateFormat(format);
        return utcFormatter.format(date);
    }

    private static DateFormat createDateFormat(String format) {
        SimpleDateFormat utcFormatter = new SimpleDateFormat(format);
        utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return utcFormatter;
    }
}

