/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.Collection;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.property.complex.FolderId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CreateRequest<TServiceObject extends ServiceObject, TResponse extends ServiceResponse>
extends MultiResponseServiceRequest<TResponse> {
    private FolderId parentFolderId;
    private Collection<TServiceObject> objects;

    protected CreateRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        if (this.getParentFolderId() != null) {
            this.getParentFolderId().validate(this.getService().getRequestedServerVersion());
        }
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return EwsUtilities.getEnumeratedObjectCount(this.objects.iterator());
    }

    protected abstract String getParentFolderXmlElementName();

    protected abstract String getObjectCollectionXmlElementName();

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.parentFolderId != null) {
            writer.writeStartElement(XmlNamespace.Messages, this.getParentFolderXmlElementName());
            this.getParentFolderId().writeToXml(writer);
            writer.writeEndElement();
        }
        writer.writeStartElement(XmlNamespace.Messages, this.getObjectCollectionXmlElementName());
        if (null != this.objects) {
            for (ServiceObject obj : this.objects) {
                obj.writeToXml(writer);
            }
        }
        writer.writeEndElement();
    }

    protected Iterable<TServiceObject> getObjects() {
        return this.objects;
    }

    protected void setObjects(Collection<TServiceObject> value) {
        this.objects = value;
    }

    public FolderId getParentFolderId() {
        return this.parentFolderId;
    }

    public void setParentFolderId(FolderId value) {
        this.parentFolderId = value;
    }
}

