/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.DeleteRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.misc.FolderIdWrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmptyFolderRequest
extends DeleteRequest<ServiceResponse> {
    private FolderIdWrapperList folderIds = new FolderIdWrapperList();
    private boolean deleteSubFolders;

    public EmptyFolderRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getFolderIds(), "FolderIds");
        this.getFolderIds().validate(this.getService().getRequestedServerVersion());
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getFolderIds().getCount();
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    public String getXmlElementName() {
        return "EmptyFolder";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "EmptyFolderResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "EmptyFolderResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getFolderIds().writeToXml(writer, XmlNamespace.Messages, "FolderIds");
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        writer.writeAttributeValue("DeleteSubFolders", this.deleteSubFolders);
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }

    public FolderIdWrapperList getFolderIds() {
        return this.folderIds;
    }

    protected boolean getDeleteSubFolders() {
        return this.deleteSubFolders;
    }

    public void setDeleteSubFolders(boolean value) {
        this.deleteSubFolders = value;
    }
}

