/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.io.IOException;
import java.util.concurrent.Future;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.TraceFlags;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRequestException;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.core.request.ServiceRequestBase;
import microsoft.exchange.webservices.data.misc.AsyncCallback;
import microsoft.exchange.webservices.data.misc.AsyncExecutor;
import microsoft.exchange.webservices.data.misc.AsyncRequestResult;
import microsoft.exchange.webservices.data.misc.CallableMethod;
import microsoft.exchange.webservices.data.misc.IAsyncResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleServiceRequestBase<T>
extends ServiceRequestBase<T> {
    protected SimpleServiceRequestBase(ExchangeService service) throws Exception {
        super(service);
    }

    protected T internalExecute() throws Exception {
        HttpWebRequest response = null;
        try {
            response = this.validateAndEmitRequest();
            return this.readResponse(response);
        }
        catch (IOException ex) {
            throw new ServiceRequestException(String.format("The request failed. %s", ex.getMessage()), ex);
        }
        catch (Exception e) {
            if (response != null) {
                this.getService().processHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, response);
            }
            throw new ServiceRequestException(String.format("The request failed. %s", e.getMessage()), e);
        }
    }

    protected T endInternalExecute(IAsyncResult asyncResult) throws Exception {
        HttpWebRequest response = (HttpWebRequest)asyncResult.get();
        return this.readResponse(response);
    }

    public AsyncRequestResult beginExecute(AsyncCallback callback) throws Exception {
        this.validate();
        HttpWebRequest request = this.buildEwsHttpWebRequest();
        AsyncExecutor es = new AsyncExecutor();
        CallableMethod cl = new CallableMethod(request);
        Future<Object> task = es.submit(cl, callback);
        es.shutdown();
        return new AsyncRequestResult(this, request, task, null);
    }
}

