/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.schema;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ILazyMember;
import microsoft.exchange.webservices.data.core.LazyMember;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.ExtendedPropertyCollection;
import microsoft.exchange.webservices.data.property.complex.ICreateComplexPropertyDelegate;
import microsoft.exchange.webservices.data.property.definition.ComplexPropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.IndexedPropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class ServiceObjectSchema
implements Iterable<PropertyDefinition> {
    private static final Log LOG = LogFactory.getLog(ServiceObjectSchema.class);
    private static final Object lockObject = new Object();
    private static LazyMember<List<Class<?>>> allSchemaTypes = new LazyMember(new ILazyMember<List<Class<?>>>(){

        @Override
        public List<Class<?>> createInstance() {
            ArrayList typeList = new ArrayList();
            return typeList;
        }
    });
    private static LazyMember<Map<String, PropertyDefinitionBase>> allSchemaProperties = new LazyMember<Map<String, PropertyDefinitionBase>>(new ILazyMember<Map<String, PropertyDefinitionBase>>(){

        @Override
        public Map<String, PropertyDefinitionBase> createInstance() {
            HashMap<String, PropertyDefinitionBase> propDefDictionary = new HashMap<String, PropertyDefinitionBase>();
            for (Class c : (List)allSchemaTypes.getMember()) {
                ServiceObjectSchema.addSchemaPropertiesToDictionary(c, propDefDictionary);
            }
            return propDefDictionary;
        }
    });
    public static final PropertyDefinition extendedProperties = new ComplexPropertyDefinition<ExtendedPropertyCollection>(ExtendedPropertyCollection.class, "ExtendedProperty", EnumSet.of(PropertyDefinitionFlags.AutoInstantiateOnRead, PropertyDefinitionFlags.ReuseInstance, PropertyDefinitionFlags.CanSet, PropertyDefinitionFlags.CanUpdate), ExchangeVersion.Exchange2007_SP1, new ICreateComplexPropertyDelegate<ExtendedPropertyCollection>(){

        @Override
        public ExtendedPropertyCollection createComplexProperty() {
            return new ExtendedPropertyCollection();
        }
    });
    private Map<String, PropertyDefinition> properties = new HashMap<String, PropertyDefinition>();
    private List<PropertyDefinition> visibleProperties = new ArrayList<PropertyDefinition>();
    private List<PropertyDefinition> firstClassProperties = new ArrayList<PropertyDefinition>();
    private List<PropertyDefinition> firstClassSummaryProperties = new ArrayList<PropertyDefinition>();
    private List<IndexedPropertyDefinition> indexedProperties = new ArrayList<IndexedPropertyDefinition>();

    protected static void addSchemaPropertiesToDictionary(Class<?> type, Map<String, PropertyDefinitionBase> propDefDictionary) {
        Field[] fields;
        for (Field field : fields = type.getDeclaredFields()) {
            int modifier = field.getModifiers();
            if (!Modifier.isPublic(modifier) || !Modifier.isStatic(modifier)) continue;
            try {
                PropertyDefinition propertyDefinition;
                Object o = field.get(null);
                if (!(o instanceof PropertyDefinition) || null == (propertyDefinition = (PropertyDefinition)o).getUri() || propertyDefinition.getUri().isEmpty()) continue;
                if (propDefDictionary.containsKey(propertyDefinition.getUri())) {
                    PropertyDefinitionBase existingPropertyDefinition = propDefDictionary.get(propertyDefinition.getUri());
                    EwsUtilities.ewsAssert(existingPropertyDefinition == propertyDefinition, "Schema.allSchemaProperties.delegate", String.format("There are at least two distinct property definitions with the following URI: %s", propertyDefinition.getUri()));
                    continue;
                }
                propDefDictionary.put(propertyDefinition.getUri(), propertyDefinition);
                List<PropertyDefinition> associatedInternalProperties = propertyDefinition.getAssociatedInternalProperties();
                for (PropertyDefinition associatedInternalProperty : associatedInternalProperties) {
                    propDefDictionary.put(associatedInternalProperty.getUri(), associatedInternalProperty);
                }
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e);
            }
        }
    }

    protected static void addSchemaPropertyNamesToDictionary(Class<?> type, Map<PropertyDefinition, String> propertyNameDictionary) {
        Field[] fields;
        for (Field field : fields = type.getDeclaredFields()) {
            int modifier = field.getModifiers();
            if (!Modifier.isPublic(modifier) || !Modifier.isStatic(modifier)) continue;
            try {
                Object o = field.get(null);
                if (!(o instanceof PropertyDefinition)) continue;
                PropertyDefinition propertyDefinition = (PropertyDefinition)o;
                propertyNameDictionary.put(propertyDefinition, field.getName());
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e);
            }
        }
    }

    protected ServiceObjectSchema() {
        this.registerProperties();
    }

    public static PropertyDefinitionBase findPropertyDefinition(String uri) {
        return allSchemaProperties.getMember().get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeSchemaPropertyNames() {
        Object object = lockObject;
        synchronized (object) {
            for (Class<?> type : allSchemaTypes.getMember()) {
                Field[] fields;
                for (Field field : fields = type.getDeclaredFields()) {
                    int modifier = field.getModifiers();
                    if (!Modifier.isPublic(modifier) || !Modifier.isStatic(modifier)) continue;
                    try {
                        Object o = field.get(null);
                        if (!(o instanceof PropertyDefinition)) continue;
                        PropertyDefinition propertyDefinition = (PropertyDefinition)o;
                        propertyDefinition.setName(field.getName());
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error((Object)e);
                    }
                    catch (IllegalAccessException e) {
                        LOG.error((Object)e);
                    }
                }
            }
        }
    }

    private void registerProperty(PropertyDefinition property, boolean isInternal) {
        this.properties.put(property.getXmlElement(), property);
        if (!isInternal) {
            this.visibleProperties.add(property);
        }
        if (!property.hasFlag(PropertyDefinitionFlags.MustBeExplicitlyLoaded)) {
            this.firstClassProperties.add(property);
        }
        if (property.hasFlag(PropertyDefinitionFlags.CanFind)) {
            this.firstClassSummaryProperties.add(property);
        }
    }

    protected void registerProperty(PropertyDefinition property) {
        this.registerProperty(property, false);
    }

    protected void registerInternalProperty(PropertyDefinition property) {
        this.registerProperty(property, true);
    }

    protected void registerIndexedProperty(IndexedPropertyDefinition indexedProperty) {
        this.indexedProperties.add(indexedProperty);
    }

    protected void registerProperties() {
    }

    public List<PropertyDefinition> getFirstClassProperties() {
        return this.firstClassProperties;
    }

    public List<PropertyDefinition> getFirstClassSummaryProperties() {
        return this.firstClassSummaryProperties;
    }

    public boolean tryGetPropertyDefinition(String xmlElementName, OutParam<PropertyDefinition> propertyDefinitionOutParam) {
        if (this.properties.containsKey(xmlElementName)) {
            propertyDefinitionOutParam.setParam((Object)this.properties.get(xmlElementName));
            return true;
        }
        return false;
    }

    @Override
    public Iterator<PropertyDefinition> iterator() {
        return this.visibleProperties.iterator();
    }
}

