/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.UserConfigurationProperties;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.exception.misc.InvalidOperationException;
import microsoft.exchange.webservices.data.core.exception.service.local.PropertyException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.UserConfigurationDictionary;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserConfiguration {
    private static final Log LOG = LogFactory.getLog(UserConfiguration.class);
    private static ExchangeVersion ObjectVersion = ExchangeVersion.Exchange2010;
    private static final EnumSet<UserConfigurationProperties> PropertiesAvailableForNewObject = EnumSet.of(UserConfigurationProperties.BinaryData, UserConfigurationProperties.Dictionary, UserConfigurationProperties.XmlData);
    private final UserConfigurationProperties NoProperties = UserConfigurationProperties.values()[0];
    private ExchangeService service;
    private String name;
    private FolderId parentFolderId = null;
    private ItemId itemId = null;
    private UserConfigurationDictionary dictionary = null;
    private byte[] xmlData = null;
    private byte[] binaryData = null;
    private EnumSet<UserConfigurationProperties> propertiesAvailableForAccess;
    private EnumSet<UserConfigurationProperties> updatedProperties;
    private boolean isNew = false;

    public UserConfiguration(ExchangeService service) throws Exception {
        this(service, PropertiesAvailableForNewObject);
    }

    private static void writeByteArrayToXml(EwsServiceXmlWriter writer, byte[] byteArray, String xmlElementName) throws XMLStreamException, ServiceXmlSerializationException {
        EwsUtilities.ewsAssert(writer != null, "UserConfiguration.WriteByteArrayToXml", "writer is null");
        EwsUtilities.ewsAssert(xmlElementName != null, "UserConfiguration.WriteByteArrayToXml", "xmlElementName is null");
        writer.writeStartElement(XmlNamespace.Types, xmlElementName);
        if (byteArray != null && byteArray.length > 0) {
            writer.writeValue(Base64.encodeBase64String((byte[])byteArray), xmlElementName);
        }
        writer.writeEndElement();
    }

    public static void writeUserConfigurationNameToXml(EwsServiceXmlWriter writer, XmlNamespace xmlNamespace, String name, FolderId parentFolderId) throws Exception {
        EwsUtilities.ewsAssert(writer != null, "UserConfiguration.WriteUserConfigurationNameToXml", "writer is null");
        EwsUtilities.ewsAssert(name != null, "UserConfiguration.WriteUserConfigurationNameToXml", "name is null");
        EwsUtilities.ewsAssert(parentFolderId != null, "UserConfiguration.WriteUserConfigurationNameToXml", "parentFolderId is null");
        writer.writeStartElement(xmlNamespace, "UserConfigurationName");
        writer.writeAttributeValue("Name", name);
        parentFolderId.writeToXml(writer);
        writer.writeEndElement();
    }

    public UserConfiguration(ExchangeService service, EnumSet<UserConfigurationProperties> requestedProperties) throws Exception {
        EwsUtilities.validateParam(service, "service");
        if (service.getRequestedServerVersion().ordinal() < ObjectVersion.ordinal()) {
            throw new ServiceVersionException(String.format("The object type %s is only valid for Exchange Server version %s or later versions.", new Object[]{this.getClass().getName(), ObjectVersion}));
        }
        this.service = service;
        this.isNew = true;
        this.initializeProperties(requestedProperties);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public FolderId getParentFolderId() {
        return this.parentFolderId;
    }

    public void setParentFolderId(FolderId value) {
        this.parentFolderId = value;
    }

    public ItemId getItemId() {
        return this.itemId;
    }

    public UserConfigurationDictionary getDictionary() {
        return this.dictionary;
    }

    public byte[] getXmlData() throws PropertyException {
        this.validatePropertyAccess(UserConfigurationProperties.XmlData);
        return this.xmlData;
    }

    public void setXmlData(byte[] value) {
        this.xmlData = value;
        this.markPropertyForUpdate(UserConfigurationProperties.XmlData);
    }

    public byte[] getBinaryData() throws PropertyException {
        this.validatePropertyAccess(UserConfigurationProperties.BinaryData);
        return this.binaryData;
    }

    public void setBinaryData(byte[] value) {
        this.binaryData = value;
        this.markPropertyForUpdate(UserConfigurationProperties.BinaryData);
    }

    public boolean getIsDirty() {
        return !this.updatedProperties.contains((Object)this.NoProperties) || this.dictionary.getIsDirty();
    }

    public static UserConfiguration bind(ExchangeService service, String name, FolderId parentFolderId, UserConfigurationProperties properties) throws IndexOutOfBoundsException, Exception {
        UserConfiguration result = service.getUserConfiguration(name, parentFolderId, properties);
        result.isNew = false;
        return result;
    }

    public static UserConfiguration bind(ExchangeService service, String name, WellKnownFolderName parentFolderName, UserConfigurationProperties properties) throws IndexOutOfBoundsException, Exception {
        return UserConfiguration.bind(service, name, new FolderId(parentFolderName), properties);
    }

    public void save(String name, FolderId parentFolderId) throws Exception {
        EwsUtilities.validateParam(name, "name");
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        parentFolderId.validate(this.service.getRequestedServerVersion());
        if (!this.isNew) {
            throw new InvalidOperationException("Calling Save isn't allowed because this user configuration isn't new. To apply local changes to this user configuration, call Update instead.");
        }
        this.parentFolderId = parentFolderId;
        this.name = name;
        this.service.createUserConfiguration(this);
        this.isNew = false;
        this.resetIsDirty();
    }

    public void save(String name, WellKnownFolderName parentFolderName) throws Exception {
        this.save(name, new FolderId(parentFolderName));
    }

    public void update() throws Exception {
        if (this.isNew) {
            throw new InvalidOperationException("This user configuration can't be updated because it's never been saved.");
        }
        if (this.isPropertyUpdated(UserConfigurationProperties.BinaryData) || this.isPropertyUpdated(UserConfigurationProperties.Dictionary) || this.isPropertyUpdated(UserConfigurationProperties.XmlData)) {
            this.service.updateUserConfiguration(this);
        }
        this.resetIsDirty();
    }

    public void delete() throws Exception {
        if (this.isNew) {
            throw new InvalidOperationException("This user configuration object can't be deleted because it's never been saved.");
        }
        this.service.deleteUserConfiguration(this.name, this.parentFolderId);
    }

    public void load(UserConfigurationProperties properties) throws Exception {
        this.initializeProperties(EnumSet.of(properties));
        this.service.loadPropertiesForUserConfiguration(this, properties);
    }

    public void writeToXml(EwsServiceXmlWriter writer, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        EwsUtilities.ewsAssert(writer != null, "UserConfiguration.WriteToXml", "writer is null");
        EwsUtilities.ewsAssert(xmlElementName != null, "UserConfiguration.WriteToXml", "xmlElementName is null");
        writer.writeStartElement(xmlNamespace, xmlElementName);
        UserConfiguration.writeUserConfigurationNameToXml(writer, XmlNamespace.Types, this.name, this.parentFolderId);
        if (this.isPropertyUpdated(UserConfigurationProperties.Dictionary)) {
            this.dictionary.writeToXml(writer, "Dictionary");
        }
        if (this.isPropertyUpdated(UserConfigurationProperties.XmlData)) {
            this.writeXmlDataToXml(writer);
        }
        if (this.isPropertyUpdated(UserConfigurationProperties.BinaryData)) {
            this.writeBinaryDataToXml(writer);
        }
        writer.writeEndElement();
    }

    private boolean isPropertyUpdated(UserConfigurationProperties property) {
        boolean isPropertyDirty = false;
        boolean isPropertyEmpty = false;
        switch (property) {
            case Dictionary: {
                isPropertyDirty = this.getDictionary().getIsDirty();
                isPropertyEmpty = this.getDictionary().getCount() == 0;
                break;
            }
            case XmlData: {
                isPropertyDirty = this.updatedProperties.contains((Object)property);
                isPropertyEmpty = this.xmlData == null || this.xmlData.length == 0;
                break;
            }
            case BinaryData: {
                isPropertyDirty = this.updatedProperties.contains((Object)property);
                isPropertyEmpty = this.binaryData == null || this.binaryData.length == 0;
                break;
            }
            default: {
                EwsUtilities.ewsAssert(false, "UserConfiguration.IsPropertyUpdated", "property not supported: " + property.toString());
            }
        }
        return isPropertyDirty && (!isPropertyEmpty || !this.isNew);
    }

    private void writeXmlDataToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        EwsUtilities.ewsAssert(writer != null, "UserConfiguration.WriteXmlDataToXml", "writer is null");
        UserConfiguration.writeByteArrayToXml(writer, this.xmlData, "XmlData");
    }

    private void writeBinaryDataToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        EwsUtilities.ewsAssert(writer != null, "UserConfiguration.WriteBinaryDataToXml", "writer is null");
        UserConfiguration.writeByteArrayToXml(writer, this.binaryData, "BinaryData");
    }

    public void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        EwsUtilities.ewsAssert(reader != null, "UserConfiguration.loadFromXml", "reader is null");
        reader.readStartElement(XmlNamespace.Messages, "UserConfiguration");
        reader.read();
        do {
            if (reader.getNodeType().getNodeType() == 1) {
                if (reader.getLocalName().equals("UserConfigurationName")) {
                    String responseName = reader.readAttributeValue("Name");
                    EwsUtilities.ewsAssert(this.name.equals(responseName), "UserConfiguration.loadFromXml", "UserConfigurationName does not match: Expected: " + this.name + " Name in response: " + responseName);
                    reader.skipCurrentElement();
                } else if (reader.getLocalName().equals("ItemId")) {
                    this.itemId = new ItemId();
                    this.itemId.loadFromXml(reader, "ItemId");
                } else if (reader.getLocalName().equals("Dictionary")) {
                    this.dictionary.loadFromXml(reader, "Dictionary");
                } else if (reader.getLocalName().equals("XmlData")) {
                    this.xmlData = Base64.decodeBase64((String)reader.readElementValue());
                } else if (reader.getLocalName().equals("BinaryData")) {
                    this.binaryData = Base64.decodeBase64((String)reader.readElementValue());
                } else {
                    EwsUtilities.ewsAssert(false, "UserConfiguration.loadFromXml", "Xml element not supported: " + reader.getLocalName());
                }
            }
            reader.read();
        } while (!reader.isEndElement(XmlNamespace.Messages, "UserConfiguration"));
    }

    private void initializeProperties(EnumSet<UserConfigurationProperties> requestedProperties) {
        this.itemId = null;
        this.dictionary = new UserConfigurationDictionary();
        this.xmlData = null;
        this.binaryData = null;
        this.propertiesAvailableForAccess = requestedProperties;
        this.resetIsDirty();
    }

    private void resetIsDirty() {
        try {
            this.updatedProperties = EnumSet.of(this.NoProperties);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        this.dictionary.setIsDirty(false);
    }

    private void validatePropertyAccess(UserConfigurationProperties property) throws PropertyException {
        if (!this.propertiesAvailableForAccess.contains((Object)property)) {
            throw new PropertyException("You must load or assign this property before you can read its value.", property.toString());
        }
    }

    private void markPropertyForUpdate(UserConfigurationProperties property) {
        this.updatedProperties.add(property);
        this.propertiesAvailableForAccess.add(property);
    }
}

