/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.notification;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.error.ServiceError;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceResult;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentNullException;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentOutOfRangeException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.request.GetStreamingEventsRequest;
import microsoft.exchange.webservices.data.core.request.HangingRequestDisconnectEventArgs;
import microsoft.exchange.webservices.data.core.request.HangingServiceRequestBase;
import microsoft.exchange.webservices.data.core.response.GetStreamingEventsResponse;
import microsoft.exchange.webservices.data.notification.GetStreamingEventsResults;
import microsoft.exchange.webservices.data.notification.NotificationEventArgs;
import microsoft.exchange.webservices.data.notification.StreamingSubscription;
import microsoft.exchange.webservices.data.notification.SubscriptionErrorEventArgs;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StreamingSubscriptionConnection
implements Closeable,
HangingServiceRequestBase.IHandleResponseObject,
HangingServiceRequestBase.IHangingRequestDisconnectHandler {
    private static final Log LOG = LogFactory.getLog(StreamingSubscriptionConnection.class);
    private Map<String, StreamingSubscription> subscriptions;
    private int connectionTimeout;
    private ExchangeService session;
    private boolean isDisposed;
    private GetStreamingEventsRequest currentHangingRequest;
    private List<INotificationEventDelegate> onNotificationEvent = new ArrayList<INotificationEventDelegate>();
    private List<ISubscriptionErrorDelegate> onSubscriptionError = new ArrayList<ISubscriptionErrorDelegate>();
    private List<ISubscriptionErrorDelegate> onDisconnect = new ArrayList<ISubscriptionErrorDelegate>();

    public void addOnNotificationEvent(INotificationEventDelegate notificationEvent) {
        this.onNotificationEvent.add(notificationEvent);
    }

    public void removeNotificationEvent(INotificationEventDelegate notificationEvent) {
        this.onNotificationEvent.remove(notificationEvent);
    }

    public void clearNotificationEvent() {
        this.onNotificationEvent.clear();
    }

    public void addOnSubscriptionError(ISubscriptionErrorDelegate subscriptionError) {
        this.onSubscriptionError.add(subscriptionError);
    }

    public void removeSubscriptionError(ISubscriptionErrorDelegate subscriptionError) {
        this.onSubscriptionError.remove(subscriptionError);
    }

    public void clearSubscriptionError() {
        this.onSubscriptionError.clear();
    }

    public void addOnDisconnect(ISubscriptionErrorDelegate disconnect) {
        this.onDisconnect.add(disconnect);
    }

    public void removeDisconnect(ISubscriptionErrorDelegate disconnect) {
        this.onDisconnect.remove(disconnect);
    }

    public void clearDisconnect() {
        this.onDisconnect.clear();
    }

    public StreamingSubscriptionConnection(ExchangeService service, int lifetime) throws Exception {
        EwsUtilities.validateParam(service, "service");
        EwsUtilities.validateClassVersion(service, ExchangeVersion.Exchange2010_SP1, this.getClass().getName());
        if (lifetime < 1 || lifetime > 30) {
            throw new ArgumentOutOfRangeException("lifetime");
        }
        this.session = service;
        this.subscriptions = new HashMap<String, StreamingSubscription>();
        this.connectionTimeout = lifetime;
    }

    public StreamingSubscriptionConnection(ExchangeService service, Iterable<StreamingSubscription> subscriptions, int lifetime) throws Exception {
        this(service, lifetime);
        EwsUtilities.validateParamCollection(subscriptions.iterator(), "subscriptions");
        for (StreamingSubscription subscription : subscriptions) {
            this.subscriptions.put(subscription.getId(), subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(StreamingSubscription subscription) throws Exception {
        this.throwIfDisposed();
        EwsUtilities.validateParam(subscription, "subscription");
        this.validateConnectionState(false, "Subscriptions can't be added to an open connection.");
        StreamingSubscriptionConnection streamingSubscriptionConnection = this;
        synchronized (streamingSubscriptionConnection) {
            if (this.subscriptions.containsKey(subscription.getId())) {
                return;
            }
            this.subscriptions.put(subscription.getId(), subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(StreamingSubscription subscription) throws Exception {
        this.throwIfDisposed();
        EwsUtilities.validateParam(subscription, "subscription");
        this.validateConnectionState(false, "Subscriptions can't be removed from an open connection.");
        StreamingSubscriptionConnection streamingSubscriptionConnection = this;
        synchronized (streamingSubscriptionConnection) {
            this.subscriptions.remove(subscription.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ServiceLocalException, Exception {
        StreamingSubscriptionConnection streamingSubscriptionConnection = this;
        synchronized (streamingSubscriptionConnection) {
            this.throwIfDisposed();
            this.validateConnectionState(false, "The connection has already opened.");
            if (this.subscriptions.size() == 0) {
                throw new ServiceLocalException("You must add at least one subscription to this connection before it can be opened.");
            }
            this.currentHangingRequest = new GetStreamingEventsRequest(this.session, this, this.subscriptions.keySet(), this.connectionTimeout);
            this.currentHangingRequest.addOnDisconnectEvent(this);
            this.currentHangingRequest.internalExecute();
        }
    }

    private void onRequestDisconnect(Object sender, HangingRequestDisconnectEventArgs args) {
        this.internalOnDisconnect(args.getException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StreamingSubscriptionConnection streamingSubscriptionConnection = this;
        synchronized (streamingSubscriptionConnection) {
            try {
                this.throwIfDisposed();
                this.validateConnectionState(true, "The connection is already closed.");
                this.currentHangingRequest.disconnect();
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    private void internalOnDisconnect(Exception ex) {
        if (!this.onDisconnect.isEmpty()) {
            for (ISubscriptionErrorDelegate disconnect : this.onDisconnect) {
                disconnect.subscriptionErrorDelegate(this, new SubscriptionErrorEventArgs(null, ex));
            }
        }
        this.currentHangingRequest = null;
    }

    public boolean getIsOpen() throws Exception {
        this.throwIfDisposed();
        if (this.currentHangingRequest == null) {
            return false;
        }
        return this.currentHangingRequest.isConnected();
    }

    private void validateConnectionState(boolean isConnectedExpected, String errorMessage) throws Exception {
        if (isConnectedExpected && !this.getIsOpen() || !isConnectedExpected && this.getIsOpen()) {
            throw new ServiceLocalException(errorMessage);
        }
    }

    private void handleServiceResponseObject(Object response) throws ArgumentException {
        GetStreamingEventsResponse gseResponse = (GetStreamingEventsResponse)response;
        if (gseResponse == null) {
            throw new ArgumentNullException("GetStreamingEventsResponse must not be null", "GetStreamingEventsResponse");
        }
        if (gseResponse.getResult() == ServiceResult.Success || gseResponse.getResult() == ServiceResult.Warning) {
            if (gseResponse.getResults().getNotifications().size() > 0) {
                this.issueNotificationEvents(gseResponse);
            }
        } else if (gseResponse.getResult() == ServiceResult.Error) {
            if (gseResponse.getErrorSubscriptionIds() == null || gseResponse.getErrorSubscriptionIds().size() == 0) {
                this.issueGeneralFailure(gseResponse);
            } else {
                this.issueSubscriptionFailures(gseResponse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void issueSubscriptionFailures(GetStreamingEventsResponse gseResponse) {
        ServiceResponseException exception = new ServiceResponseException(gseResponse);
        for (String id : gseResponse.getErrorSubscriptionIds()) {
            StreamingSubscription subscription = null;
            StreamingSubscriptionConnection streamingSubscriptionConnection = this;
            synchronized (streamingSubscriptionConnection) {
                if (this.subscriptions != null && this.subscriptions.containsKey(id)) {
                    subscription = this.subscriptions.get(id);
                }
            }
            if (subscription != null) {
                SubscriptionErrorEventArgs eventArgs = new SubscriptionErrorEventArgs(subscription, exception);
                if (!this.onSubscriptionError.isEmpty()) {
                    for (ISubscriptionErrorDelegate subError : this.onSubscriptionError) {
                        subError.subscriptionErrorDelegate(this, eventArgs);
                    }
                }
            }
            if (gseResponse.getErrorCode() == ServiceError.ErrorMissedNotificationEvents) continue;
            streamingSubscriptionConnection = this;
            synchronized (streamingSubscriptionConnection) {
                if (this.subscriptions != null && this.subscriptions.containsKey(id)) {
                    this.subscriptions.remove(id);
                }
            }
        }
    }

    private void issueGeneralFailure(GetStreamingEventsResponse gseResponse) {
        SubscriptionErrorEventArgs eventArgs = new SubscriptionErrorEventArgs(null, new ServiceResponseException(gseResponse));
        if (!this.onSubscriptionError.isEmpty()) {
            for (ISubscriptionErrorDelegate subError : this.onSubscriptionError) {
                subError.subscriptionErrorDelegate(this, eventArgs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void issueNotificationEvents(GetStreamingEventsResponse gseResponse) {
        for (GetStreamingEventsResults.NotificationGroup events : gseResponse.getResults().getNotifications()) {
            StreamingSubscription subscription = null;
            StreamingSubscriptionConnection streamingSubscriptionConnection = this;
            synchronized (streamingSubscriptionConnection) {
                if (this.subscriptions != null && this.subscriptions.containsKey(events.subscriptionId)) {
                    subscription = this.subscriptions.get(events.subscriptionId);
                }
            }
            if (subscription == null) continue;
            NotificationEventArgs eventArgs = new NotificationEventArgs(subscription, events.events);
            if (this.onNotificationEvent.isEmpty()) continue;
            for (INotificationEventDelegate notifyEvent : this.onNotificationEvent) {
                notifyEvent.notificationEventDelegate(this, eventArgs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        StreamingSubscriptionConnection streamingSubscriptionConnection = this;
        synchronized (streamingSubscriptionConnection) {
            if (!this.isDisposed) {
                if (this.currentHangingRequest != null) {
                    this.currentHangingRequest = null;
                }
                this.subscriptions = null;
                this.session = null;
                this.isDisposed = true;
            }
        }
    }

    private void throwIfDisposed() throws Exception {
        if (this.isDisposed) {
            throw new Exception(this.getClass().getName());
        }
    }

    @Override
    public void handleResponseObject(Object response) throws ArgumentException {
        this.handleServiceResponseObject(response);
    }

    @Override
    public void hangingRequestDisconnectHandler(Object sender, HangingRequestDisconnectEventArgs args) {
        this.onRequestDisconnect(sender, args);
    }

    public static interface ISubscriptionErrorDelegate {
        public void subscriptionErrorDelegate(Object var1, SubscriptionErrorEventArgs var2);
    }

    public static interface INotificationEventDelegate {
        public void notificationEventDelegate(Object var1, NotificationEventArgs var2);
    }
}

