/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.recurrence;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.time.DayOfTheWeek;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentOutOfRangeException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DayOfTheWeekCollection
extends ComplexProperty
implements Iterable<DayOfTheWeek> {
    private List<DayOfTheWeek> items = new ArrayList<DayOfTheWeek>();

    private String toString(String separator) {
        if (this.getCount() == 0) {
            return "";
        }
        StringBuilder daysOfTheWeekstr = new StringBuilder();
        for (int i = 0; i < this.getCount(); ++i) {
            if (daysOfTheWeekstr.length() == 0) {
                daysOfTheWeekstr.append(this.items.get(i).toString());
                continue;
            }
            daysOfTheWeekstr.append(separator);
            daysOfTheWeekstr.append(this.items.get(i).toString());
        }
        return daysOfTheWeekstr.toString();
    }

    @Override
    public void loadFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, xmlElementName);
        EwsUtilities.parseEnumValueList(DayOfTheWeek.class, this.items, reader.readElementValue(), ' ');
    }

    @Override
    public void writeToXml(EwsServiceXmlWriter writer, String xmlElementName) throws XMLStreamException, ServiceXmlSerializationException {
        String daysOfWeekAsString = this.toString(" ");
        if (!StringUtils.isEmpty((CharSequence)daysOfWeekAsString)) {
            writer.writeElementValue(XmlNamespace.Types, "DaysOfWeek", daysOfWeekAsString);
        }
    }

    public String toString() {
        return this.toString(",");
    }

    public void add(DayOfTheWeek dayOfTheWeek) {
        if (!this.items.contains((Object)dayOfTheWeek)) {
            this.items.add(dayOfTheWeek);
            this.changed();
        }
    }

    public void addRange(Iterator<DayOfTheWeek> daysOfTheWeek) {
        while (daysOfTheWeek.hasNext()) {
            this.add(daysOfTheWeek.next());
        }
    }

    public void clear() {
        if (this.getCount() > 0) {
            this.items.clear();
            this.changed();
        }
    }

    public boolean remove(DayOfTheWeek dayOfTheWeek) {
        boolean result = this.items.remove((Object)dayOfTheWeek);
        if (result) {
            this.changed();
        }
        return result;
    }

    public void removeAt(int index) throws ArgumentOutOfRangeException {
        if (index < 0 || index >= this.getCount()) {
            throw new ArgumentOutOfRangeException("index", "index is out of range.");
        }
        this.items.remove(index);
        this.changed();
    }

    public DayOfTheWeek getWeekCollectionAtIndex(int index) {
        return this.items.get(index);
    }

    public int getCount() {
        return this.items.size();
    }

    @Override
    public Iterator<DayOfTheWeek> iterator() {
        return this.items.iterator();
    }
}

