/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover.response;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import microsoft.exchange.webservices.data.autodiscover.enumeration.DomainSettingName;
import microsoft.exchange.webservices.data.autodiscover.exception.error.DomainSettingError;
import microsoft.exchange.webservices.data.autodiscover.response.AutodiscoverResponse;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetDomainSettingsResponse
extends AutodiscoverResponse {
    private static final Log LOG = LogFactory.getLog(GetDomainSettingsResponse.class);
    private String domain = "";
    private String redirectTarget;
    private Map<DomainSettingName, Object> settings = new HashMap<DomainSettingName, Object>();
    private Collection<DomainSettingError> domainSettingErrors = new ArrayList<DomainSettingError>();

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String value) {
        this.domain = value;
    }

    public String getRedirectTarget() {
        return this.redirectTarget;
    }

    public Map<DomainSettingName, Object> getSettings() {
        return this.settings;
    }

    public Collection<DomainSettingError> getDomainSettingErrors() {
        return this.domainSettingErrors;
    }

    @Override
    public void loadFromXml(EwsXmlReader reader, String endElementName) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().nodeType != 1) continue;
            if (reader.getLocalName().equals("RedirectTarget")) {
                this.redirectTarget = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("DomainSettingErrors")) {
                this.loadDomainSettingErrorsFromXml(reader);
                continue;
            }
            if (reader.getLocalName().equals("DomainSettings")) {
                try {
                    this.loadDomainSettingsFromXml(reader);
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
                continue;
            }
            super.loadFromXml(reader, endElementName);
            break;
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, endElementName));
    }

    protected void loadDomainSettingsFromXml(EwsXmlReader reader) throws Exception {
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (reader.getNodeType().nodeType != 1 || !reader.getLocalName().equals("DomainSetting")) continue;
                String settingClass = reader.readAttributeValue(XmlNamespace.XmlSchemaInstance, "type");
                if (settingClass.equals("DomainStringSetting")) {
                    this.readSettingFromXml(reader);
                    continue;
                }
                EwsUtilities.ewsAssert(false, "GetDomainSettingsResponse.LoadDomainSettingsFromXml", String.format("%s,%s", "Invalid setting class '%s' returned", settingClass));
                break;
            } while (!reader.isEndElement(XmlNamespace.Autodiscover, "DomainSettings"));
        } else {
            reader.read();
        }
    }

    private void readSettingFromXml(EwsXmlReader reader) throws Exception {
        DomainSettingName name = null;
        String value = null;
        do {
            reader.read();
            if (reader.getNodeType().nodeType != 1) continue;
            if (reader.getLocalName().equals("DomainStringSetting")) {
                name = reader.readElementValue(DomainSettingName.class);
                continue;
            }
            if (!reader.getLocalName().equals("Value")) continue;
            value = reader.readElementValue();
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, "DomainSetting"));
        EwsUtilities.ewsAssert(name != null, "GetDomainSettingsResponse.ReadSettingFromXml", "Missing name element in domain setting");
        this.settings.put(name, value);
    }

    private void loadDomainSettingErrorsFromXml(EwsXmlReader reader) throws Exception {
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (reader.getNodeType().nodeType != 1 || !reader.getLocalName().equals("DomainSettingError")) continue;
                DomainSettingError error = new DomainSettingError();
                error.loadFromXml(reader);
                this.domainSettingErrors.add(error);
            } while (!reader.isEndElement(XmlNamespace.Autodiscover, "DomainSettingErrors"));
        } else {
            reader.read();
        }
    }
}

