/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.request.DeleteRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.misc.FolderIdWrapperList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteFolderRequest
extends DeleteRequest<ServiceResponse> {
    private static final Log LOG = LogFactory.getLog(DeleteFolderRequest.class);
    private FolderIdWrapperList folderIds = new FolderIdWrapperList();

    public DeleteFolderRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getFolderIds(), "FolderIds");
        this.getFolderIds().validate(this.getService().getRequestedServerVersion());
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getFolderIds().getCount();
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    public String getXmlElementName() {
        return "DeleteFolder";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "DeleteFolderResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "DeleteFolderResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) {
        try {
            this.getFolderIds().writeToXml(writer, XmlNamespace.Messages, "FolderIds");
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public FolderIdWrapperList getFolderIds() {
        return this.folderIds;
    }
}

