/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.ExecuteDiagnosticMethodResponse;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecuteDiagnosticMethodRequest
extends MultiResponseServiceRequest<ExecuteDiagnosticMethodResponse> {
    private Node xmlNode;
    private String verb;

    public ExecuteDiagnosticMethodRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    public String getXmlElementName() {
        return "ExecuteDiagnosticMethod";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        writer.writeElementValue(XmlNamespace.Messages, "Verb", this.getVerb());
        writer.writeStartElement(XmlNamespace.Messages, "Parameter");
        writer.writeNode(this.getParameter());
        writer.writeEndElement();
    }

    @Override
    protected String getResponseXmlElementName() {
        return "ExecuteDiagnosticMethodResponse";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected String getVerb() {
        return this.verb;
    }

    public void setVerb(String value) {
        this.verb = value;
    }

    protected Node getParameter() {
        return this.xmlNode;
    }

    public void setParameter(Node value) {
        this.xmlNode = value;
    }

    @Override
    protected ExecuteDiagnosticMethodResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ExecuteDiagnosticMethodResponse(service);
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "ExecuteDiagnosticMethodResponseMessage";
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }
}

