/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.GetEventsResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetEventsRequest
extends MultiResponseServiceRequest<GetEventsResponse> {
    private String subscriptionId;
    private String watermark;

    public GetEventsRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected GetEventsResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new GetEventsResponse();
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    public String getXmlElementName() {
        return "GetEvents";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetEventsResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "GetEventsResponseMessage";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateNonBlankStringParam(this.getSubscriptionId(), "SubscriptionId");
        EwsUtilities.validateNonBlankStringParam(this.getWatermark(), "Watermark");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeElementValue(XmlNamespace.Messages, "SubscriptionId", this.getSubscriptionId());
        writer.writeElementValue(XmlNamespace.Messages, "Watermark", this.getWatermark());
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getWatermark() {
        return this.watermark;
    }

    public void setWatermark(String watermark) {
        this.watermark = watermark;
    }
}

