/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.response;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.misc.HangingRequestDisconnectReason;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.request.HangingServiceRequestBase;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.notification.GetStreamingEventsResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetStreamingEventsResponse
extends ServiceResponse {
    private GetStreamingEventsResults results = new GetStreamingEventsResults();
    private HangingServiceRequestBase request;
    private List<String> errorSubscriptionIds;

    public GetStreamingEventsResponse(HangingServiceRequestBase request) {
        ArrayList<String> string = new ArrayList<String>();
        this.setErrorSubscriptionIds(string);
        this.request = request;
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws Exception {
        String connectionStatus;
        super.readElementsFromXml(reader);
        reader.read();
        if (reader.getLocalName().equals("Notifications")) {
            this.results.loadFromXml(reader);
        } else if (reader.getLocalName().equals("ConnectionStatus") && (connectionStatus = reader.readElementValue(XmlNamespace.Messages, "ConnectionStatus")).equals(ConnectionStatus.Closed.toString())) {
            this.request.disconnect(HangingRequestDisconnectReason.Clean, null);
        }
    }

    @Override
    protected boolean loadExtraErrorDetailsFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        boolean baseReturnVal = super.loadExtraErrorDetailsFromXml(reader, xmlElementName);
        if (reader.isStartElement(XmlNamespace.Messages, "ErrorSubscriptionIds")) {
            do {
                reader.read();
                if (reader.getNodeType().getNodeType() != 1 || !reader.getLocalName().equals("SubscriptionId")) continue;
                this.getErrorSubscriptionIds().add(reader.readElementValue(XmlNamespace.Messages, "SubscriptionId"));
            } while (!reader.isEndElement(XmlNamespace.Messages, "ErrorSubscriptionIds"));
            return true;
        }
        return baseReturnVal;
    }

    public GetStreamingEventsResults getResults() {
        return this.results;
    }

    public List<String> getErrorSubscriptionIds() {
        return this.errorSubscriptionIds;
    }

    private void setErrorSubscriptionIds(List<String> value) {
        this.errorSubscriptionIds = value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConnectionStatus {
        OK,
        Closed;

    }
}

