/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.core.request.ServiceRequestBase;
import microsoft.exchange.webservices.data.core.request.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.core.request.WaitHandle;
import microsoft.exchange.webservices.data.misc.AsyncCallback;
import microsoft.exchange.webservices.data.misc.IAsyncResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncRequestResult
implements IAsyncResult {
    ServiceRequestBase serviceRequest;
    HttpWebRequest webRequest;
    AsyncCallback wasasyncCallback;
    IAsyncResult webAsyncResult;
    Object asyncState;
    Future<?> task;

    AsyncRequestResult(Future<?> task) {
        this.task = task;
    }

    public AsyncRequestResult(ServiceRequestBase serviceRequest, HttpWebRequest webRequest, Future<?> task, Object asyncState) throws Exception {
        EwsUtilities.validateParam(serviceRequest, "serviceRequest");
        EwsUtilities.validateParam(webRequest, "webRequest");
        EwsUtilities.validateParam(task, "task");
        this.serviceRequest = serviceRequest;
        this.webRequest = webRequest;
        this.asyncState = asyncState;
        this.task = task;
    }

    public void setServiceRequestBase(ServiceRequestBase serviceRequest) {
        this.serviceRequest = serviceRequest;
    }

    private ServiceRequestBase getServiceRequest() {
        return this.serviceRequest;
    }

    public void setHttpWebRequest(HttpWebRequest webRequest) {
        this.webRequest = webRequest;
    }

    public HttpWebRequest getHttpWebRequest() {
        return this.webRequest;
    }

    public FutureTask<?> getTask() {
        return (FutureTask)this.task;
    }

    public static <T extends SimpleServiceRequestBase> T extractServiceRequest(ExchangeService exchangeService, Future<?> asyncResult) throws Exception {
        EwsUtilities.validateParam(asyncResult, "asyncResult");
        AsyncRequestResult asyncRequestResult = (AsyncRequestResult)asyncResult;
        if (asyncRequestResult == null) {
            throw new ArgumentException("Invalid AsyncResult.", "asyncResult");
        }
        if (asyncRequestResult.serviceRequest == null) {
            throw new ArgumentException("Invalid AsyncResult.", "asyncResult");
        }
        if (!asyncRequestResult.serviceRequest.getService().equals(exchangeService)) {
            throw new ArgumentException("Invalid AsyncResult.", "asyncResult");
        }
        SimpleServiceRequestBase serviceRequest = (SimpleServiceRequestBase)asyncRequestResult.getServiceRequest();
        if (serviceRequest == null) {
            throw new ArgumentException("Invalid AsyncResult.", "asyncResult");
        }
        return (T)serviceRequest;
    }

    @Override
    public boolean cancel(boolean arg0) {
        return false;
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return null;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public Object getAsyncState() {
        return null;
    }

    @Override
    public WaitHandle getAsyncWaitHanle() {
        return null;
    }

    @Override
    public boolean getCompleteSynchronously() {
        return false;
    }

    @Override
    public boolean getIsCompleted() {
        return false;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        return this.task.get();
    }
}

