/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.Collection;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.service.MessageDisposition;
import microsoft.exchange.webservices.data.core.enumeration.service.SendInvitationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.CreateRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.service.ServiceObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CreateItemRequestBase<TServiceObject extends ServiceObject, TResponse extends ServiceResponse>
extends CreateRequest<TServiceObject, TResponse> {
    private MessageDisposition messageDisposition = null;
    private SendInvitationsMode sendInvitationsMode = null;

    protected CreateItemRequestBase(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getItems(), "Items");
    }

    @Override
    public String getXmlElementName() {
        return "CreateItem";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "CreateItemResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "CreateItemResponseMessage";
    }

    @Override
    protected String getParentFolderXmlElementName() {
        return "SavedItemFolderId";
    }

    @Override
    protected String getObjectCollectionXmlElementName() {
        return "Items";
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        if (this.messageDisposition != null) {
            writer.writeAttributeValue("MessageDisposition", (Object)this.getMessageDisposition());
        }
        if (this.sendInvitationsMode != null) {
            writer.writeAttributeValue("SendMeetingInvitations", (Object)this.sendInvitationsMode);
        }
    }

    public MessageDisposition getMessageDisposition() {
        return this.messageDisposition;
    }

    public void setMessageDisposition(MessageDisposition value) {
        this.messageDisposition = value;
    }

    public SendInvitationsMode getSendInvitationsMode() {
        return this.sendInvitationsMode;
    }

    public void setSendInvitationsMode(SendInvitationsMode value) {
        this.sendInvitationsMode = value;
    }

    public void setItems(Collection<TServiceObject> value) {
        this.setObjects(value);
    }

    public Iterable<TServiceObject> getItems() {
        return this.getObjects();
    }
}

